/*
 * Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 *
 * (c) Copyright 1996 - 2001 Gary Henderson (gary@daniver.demon.co.uk) and
 *                           Jerremy Koot (jkoot@snes9x.com)
 *
 * Super FX C emulator code 
 * (c) Copyright 1997 - 1999 Ivar (Ivar@snes9x.com) and
 *                           Gary Henderson.
 * Super FX assembler emulator code (c) Copyright 1998 zsKnight and _Demo_.
 *
 * DSP1 emulator code (c) Copyright 1998 Ivar, _Demo_ and Gary Henderson.
 * C4 asm and some C emulation code (c) Copyright 2000 zsKnight and _Demo_.
 * C4 C code (c) Copyright 2001 Gary Henderson (gary@daniver.demon.co.uk).
 *
 * DOS port code contains the works of other authors. See headers in
 * individual files.
 *
 * Snes9x homepage: www.snes9x.com
 *
 * Permission to use, copy, modify and distribute Snes9x in both binary and
 * source form, for non-commercial purposes, is hereby granted without fee,
 * providing that this license information and copyright notice appear with
 * all copies and any derived work.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event shall the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Snes9x is freeware for PERSONAL USE only. Commercial users should
 * seek permission of the copyright holders first. Commercial use includes
 * charging money for Snes9x or software derived from Snes9x.
 *
 * The copyright holders request that bug fixes and improvements to the code
 * should be forwarded to them so everyone can benefit from the modifications
 * in future versions.
 *
 * Super NES and Super Nintendo Entertainment System are trademarks of
 * Nintendo Co., Limited and its subsidiary companies.
 */
#include "snes9x.h"
#include "apu.h"

static inline void APUTimerPulse()
{
	if (APU.TimerEnabled [2]) {
		APU.Timer [2]++;
		if (APU.Timer [2] >= APU.TimerTarget [2]) {
			IAPU.RAM [0xff] = (IAPU.RAM [0xff] + 1) & 0xf;
			APU.Timer [2] -= APU.TimerTarget [2];
#ifdef SPC700_SHUTDOWN
			IAPU.WaitCounter = 1;
			IAPU.APUExecuting = Settings.APUEnabled;
#endif
		}
	}
	if ((EXT.t64Cnt & 7) == 7) {
		if (APU.TimerEnabled [0]) {
			APU.Timer [0]++;
			if (APU.Timer [0] >= APU.TimerTarget [0]) {
				IAPU.RAM [0xfd] = (IAPU.RAM [0xfd] + 1) & 0xf;
				APU.Timer [0] -= APU.TimerTarget [0];
#ifdef SPC700_SHUTDOWN
				IAPU.WaitCounter = 1;
				IAPU.APUExecuting = Settings.APUEnabled;
#endif
			}
		}
		if (APU.TimerEnabled [1]) {
			APU.Timer [1]++;
			if (APU.Timer [1] >= APU.TimerTarget [1]) {
				IAPU.RAM [0xfe] = (IAPU.RAM [0xfe] + 1) & 0xf;
				APU.Timer [1] -= APU.TimerTarget [1];
#ifdef SPC700_SHUTDOWN
				IAPU.WaitCounter = 1;
				IAPU.APUExecuting = Settings.APUEnabled;
#endif
			}
		}
	}
}

void S9xAPUMainLoop()
{
	while(CPU.Cycles >= EXT.NextAPUTimerPos) {
		if (IAPU.APUExecuting) {
			while (APU.Cycles < EXT.NextAPUTimerPos)
				APU_EXECUTE1();
		}
		else {
			APU.Cycles = EXT.NextAPUTimerPos;
		}

		APUTimerPulse();

		//SNESAPU
		EXT.t64Cnt++;

		EXT.NextAPUTimerPos += ((EXT.APUTimerCounter_err += EXT.APUTimerCounter) >> FIXED_POINT_SHIFT);
		EXT.APUTimerCounter_err &= FIXED_POINT_REMAINDER;
	}
	APU_EXECUTE();
}

