#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shlobj.h>

LPITEMIDLIST GetNextIDL(LPCITEMIDLIST pidl)
{
   LPSTR lpMem=(LPSTR)pidl;

   lpMem+=pidl->mkid.cb;

   return (LPITEMIDLIST)lpMem;
}

static UINT Pidl_GetSize(LPCITEMIDLIST pidl)
{
    UINT cbTotal = 0;
    if (pidl)
    {
        cbTotal += sizeof(pidl->mkid.cb);       // Null terminator
        while (pidl->mkid.cb)
        {
            cbTotal += pidl->mkid.cb;
            pidl = GetNextIDL(pidl);
        }
    }

    return cbTotal;
}

static LPITEMIDLIST Create(UINT cbSize)
{
    LPMALLOC lpMalloc;
    HRESULT  hr;
    LPITEMIDLIST pidl=0;

    hr=SHGetMalloc(&lpMalloc);

    if (FAILED(hr))
       return 0;

    pidl=(LPITEMIDLIST)lpMalloc->Alloc(cbSize);

    if (pidl)
        _fmemset(pidl, 0, cbSize);      // zero-init for external task   alloc

    if (lpMalloc) lpMalloc->Release();

    return pidl;
}

LPITEMIDLIST ConcatPidls(LPCITEMIDLIST pidl1, LPCITEMIDLIST pidl2)
{
    LPITEMIDLIST pidlNew;
    UINT cb1;
    UINT cb2;

    if (pidl1)  //May be NULL
       cb1 = Pidl_GetSize(pidl1) - sizeof(pidl1->mkid.cb);
    else
       cb1 = 0;

    cb2 = Pidl_GetSize(pidl2);

    pidlNew = Create(cb1 + cb2);
    if (pidlNew)
    {
        if (pidl1)
           hmemcpy(pidlNew, pidl1, cb1);
        hmemcpy(((LPSTR)pidlNew) + cb1, pidl2, cb2);
    }
    return pidlNew;
}

LPITEMIDLIST CopyITEMID(LPMALLOC lpMalloc, LPITEMIDLIST lpi)
{
   LPITEMIDLIST lpiTemp;

   lpiTemp=(LPITEMIDLIST)lpMalloc->Alloc(lpi->mkid.cb+sizeof(lpi->mkid.cb));
   CopyMemory((PVOID)lpiTemp, (CONST VOID *)lpi, lpi->mkid.cb);
   *((short *)((char *)lpiTemp+lpi->mkid.cb))=0;

   return lpiTemp;
}

LPITEMIDLIST CopyITEMIDL(LPMALLOC lpMalloc, LPITEMIDLIST lpi)
{
   LPITEMIDLIST lpiTemp;
   UINT			cb;

   cb=Pidl_GetSize(lpi);
   lpiTemp=(LPITEMIDLIST)lpMalloc->Alloc(cb+sizeof(lpi->mkid.cb));
   CopyMemory((PVOID)lpiTemp, (CONST VOID *)lpi, cb+sizeof(lpi->mkid.cb));

   return lpiTemp;
}

UINT Pidl_GetIcon(LPITEMIDLIST lpi1,LPITEMIDLIST lpi2,UINT uFlags)
{
	LPITEMIDLIST	lpi12;
	SHFILEINFO		sfi;
	LPMALLOC		lpMalloc;
	HRESULT			hr;

	hr=SHGetMalloc(&lpMalloc);

	if (FAILED(hr)) return (UINT)-1;

	lpi12=ConcatPidls(lpi1,lpi2);
	SHGetFileInfo((LPCSTR)lpi12,0,&sfi,sizeof(SHFILEINFO),uFlags);
	lpMalloc->Free(lpi12);
	lpMalloc->Release();

	return sfi.iIcon;
}

BOOL Pidl_GetName(LPSHELLFOLDER lpsf,
             LPITEMIDLIST  lpi,
			 DWORD         dwFlags,
             LPSTR         lpFriendlyName)
{
   BOOL   bSuccess=TRUE;
   STRRET str;

   if (NOERROR==lpsf->GetDisplayNameOf(lpi,
									   dwFlags,
									   &str))
   {
      switch (str.uType)
      {
         case STRRET_WSTR:

            WideCharToMultiByte(CP_ACP,                 // CodePage
                                0,		               // dwFlags
                                str.pOleStr,            // lpWideCharStr
                                -1,                     // cchWideChar
                                lpFriendlyName,         // lpMultiByteStr
                                MAX_PATH,				// cchMultiByte,
                                NULL,                   // lpDefaultChar,
                                NULL);                  // lpUsedDefaultChar

             break;

         case STRRET_OFFSET:

             lstrcpy(lpFriendlyName, (LPSTR)lpi+str.uOffset);
             break;

         case STRRET_CSTR:
             
             lstrcpy(lpFriendlyName, (LPSTR)str.cStr);
             break;

         default:
             bSuccess = FALSE;
             break;
      }
   }
   else
      bSuccess = FALSE;

   return bSuccess;
}

BOOL GetTypeName(LPITEMIDLIST lpi1,LPITEMIDLIST lpi2,LPSTR lpType)
{
	LPITEMIDLIST	lpi12;
	SHFILEINFO		sfi;
	LPMALLOC		lpMalloc;
	HRESULT			hr;

	hr=SHGetMalloc(&lpMalloc);

	if (FAILED(hr)) return FALSE;

	lpi12=ConcatPidls(lpi1,lpi2);
	SHGetFileInfo((LPCSTR)lpi12,0,&sfi,sizeof(SHFILEINFO),SHGFI_PIDL | SHGFI_TYPENAME);
	lpMalloc->Free(lpi12);
	lpMalloc->Release();
	lstrcpy(lpType,sfi.szTypeName);

	return TRUE;
}

BOOL ExecuteIDL(HWND hWnd,LPITEMIDLIST lpi1,LPITEMIDLIST lpi2)
{
	LPMALLOC		lpMalloc;
	HRESULT			hr;
	SHELLEXECUTEINFO sei = {
							sizeof(SHELLEXECUTEINFO),
							SEE_MASK_INVOKEIDLIST,
							NULL,		//NULLɂ邱
							NULL,
							NULL,
							"",
							"",
							SW_SHOWNORMAL,
							NULL,
							(LPVOID)NULL,
							NULL,
							0,
							0,
							NULL
							};

	sei.hwnd=hWnd;
	sei.hInstApp=(HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);

	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return -1;

	sei.lpIDList=ConcatPidls(lpi1,lpi2);
	ShellExecuteEx(&sei);
	GetLastError();
	lpMalloc->Free(sei.lpIDList);
	lpMalloc->Release();

	return TRUE;
}

