#define STRICT
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include "explorer.h"
#include "exview.h"
#include "cntmenu.h"
#include "foldtree.h"
#include "pidl.h"

static BOOL InsertDesktop(HWND hWndFT, LPEVDATA lpEVData);

//VXeC[WXg̓o^

static BOOL InitFolderTreeImageLists(HWND hWndFT)
{
	HIMAGELIST himlSmall;
	SHFILEINFO sfi;
	LPEVDATA lpEVData;
	
	if(!(lpEVData = (LPEVDATA)GetProp(hWndFT , "EVData")))
		return FALSE;


	//̂悤ɂāAC[WXg̃nh𓾂
	himlSmall = (HIMAGELIST)SHGetFileInfo((LPCSTR)lpEVData->lpofne->SystemDriveString, 
										   0,
										   &sfi, 
										   sizeof(SHFILEINFO), 
										   SHGFI_SYSICONINDEX | SHGFI_SMALLICON);

	if (himlSmall)
	{
		//Xgr[ɃC[WXgo^
		TreeView_SetImageList(hWndFT, himlSmall, 0);
	}
	else{
		return	FALSE;
	}

	return TRUE;
}

//tH_c[pf[^̈̏

static void InitFolderTreeData(LPFTDATA lpFTData)
{
}

//tH_c[pf[^̈̃f[^̊J

static BOOL ReleaseFolderTreeData(LPFTDATA lpFTData)
{
	return	TRUE;
}

//tH_c[̍쐬

HWND CreateFolderTree(LPFTCREATE lpFTCreate, LPEVDATA lpEVData)
{
	HWND	hWndFT;

	hWndFT = CreateWindowEx(lpFTCreate->exstyle,
							WC_TREEVIEW, "",
							lpFTCreate->style,
							lpFTCreate->rc.left,lpFTCreate->rc.top,
							lpFTCreate->rc.right-lpFTCreate->rc.left, lpFTCreate->rc.bottom-lpFTCreate->rc.top,
							lpFTCreate->hParent,
							(HMENU)IDD_FOLDERTREE, 
							(HINSTANCE)GetWindowLong(lpFTCreate->hParent, GWL_HINSTANCE), 
							NULL);

	if(!hWndFT) return NULL;

	SetProp(hWndFT,"EVData",(HANDLE)lpEVData);

	//f[^̈̏
	InitFolderTreeData(&lpEVData->FTData);
	//VXeC[WXgg悤ɐݒ肷B
	InitFolderTreeImageLists(hWndFT);
	//fXNgbvtH_c[ɒǉB
	InsertDesktop(hWndFT,lpEVData);

	return hWndFT;
}

//tH_c[̔j

void DestroyFolderTree(HWND hWndFT,LPFTDATA lpFTData)
{
	DestroyWindow(hWndFT);
	ReleaseFolderTreeData(lpFTData);
}

//ACR̎擾

static void GetNormalAndSelectedIcons(LPITEMIDLIST lpItemAll,LPTV_ITEM lptvitem)
{
	SHFILEINFO	  sfi;

	SHGetFileInfo((LPCSTR)lpItemAll,0,&sfi, sizeof(SHFILEINFO), 
				 SHGFI_PIDL | SHGFI_SYSICONINDEX | SHGFI_SMALLICON);

	lptvitem->iImage=sfi.iIcon;

	SHGetFileInfo((LPCSTR)lpItemAll,0,&sfi, sizeof(SHFILEINFO), 
				 SHGFI_PIDL | SHGFI_SYSICONINDEX | SHGFI_SMALLICON | SHGFI_OPENICON);

	lptvitem->iSelectedImage=sfi.iIcon;

	return;
}

//c[r[ɃACehcXgǉ
static HTREEITEM InsertItemIDLToFolderTree(HWND hWndFT,LPEVDATA lpEVData,
						LPITEMIDLIST lpFolderIDL,LPITEMIDLIST lpItem,
						LPSHELLFOLDER lpShellFolder,HTREEITEM hParent,HTREEITEM hPrev,LPMALLOC lpMalloc)
{
	TV_ITEM 		tvi;
	TV_INSERTSTRUCT tvins;
	HRESULT 		hr;
	LPITEMIDLIST	lpItemAll;
	LPFTITEMDATA	lpFTItemData;
	ULONG			ulAttrs;
	char			szBuff[MAX_PATH];

	lpItemAll=NULL;
	lpFTItemData=NULL;

	ulAttrs = SFGAO_CAPABILITYMASK | SFGAO_HASSUBFOLDER | SFGAO_SHARE | SFGAO_FOLDER | SFGAO_FILESYSTEM;

	//t@C̎擾
	lpShellFolder->GetAttributesOf(1, (LPCITEMIDLIST *)&lpItem, (PULONG)&ulAttrs);

	//tH_H
	if(!(ulAttrs & SFGAO_FOLDER))
		return hPrev;

	tvi.mask=TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;
	
	//̒ɃtH_邩H
	if(ulAttrs & SFGAO_HASSUBFOLDER){
		 tvi.cChildren=1;
		 tvi.mask |= TVIF_CHILDREN;
	}

	//tH_i[邽߂̗̈̊m
	lpFTItemData = (LPFTITEMDATA)lpMalloc->Alloc(sizeof(FTITEMDATA));
	if (!lpFTItemData) goto Error;

	if (!Pidl_GetName(lpShellFolder, lpItem, SHGDN_NORMAL, szBuff))
		goto Error;

	lpFTItemData->ulAttribs=ulAttrs;

	tvi.pszText    = szBuff;
	tvi.cchTextMax = MAX_PATH;

	lpItemAll=ConcatPidls(lpFolderIDL, lpItem);

	lpFTItemData->lpItemIDL=CopyITEMID(lpMalloc, lpItem);

	GetNormalAndSelectedIcons(lpItemAll, &tvi);

	//Lt@C̏ꍇ͋LACRd˂
	if (ulAttrs & SFGAO_SHARE){
		tvi.mask |= LVIF_STATE;
		tvi.stateMask = LVIS_OVERLAYMASK;
		tvi.state = INDEXTOOVERLAYMASK(1);
	}

	if(lpFolderIDL==NULL){
		lpFTItemData->lpShellFolder=lpShellFolder;
		lpShellFolder->AddRef();
		hr=0;
	}else{
		hr=lpShellFolder->BindToObject(lpItem,
									   0,
									   IID_IShellFolder,
									   (LPVOID *)&lpFTItemData->lpShellFolder);
	}

	if(!SUCCEEDED(hr)) goto Error;

	lpFTItemData->lpItemAllIDL=lpItemAll;

	tvi.lParam=(LPARAM)lpFTItemData;

	tvins.item		   = tvi;
	tvins.hInsertAfter = hPrev;
	tvins.hParent	   = hParent;

	hPrev=TreeView_InsertItem(hWndFT, &tvins);

	lpFTItemData=NULL;

Error:

	if(lpFTItemData){
		lpMalloc->Free(lpFTItemData);
		lpFTItemData=NULL;
	}

	return hPrev;
}

//fXNgbvtH_c[ɒǉ

static BOOL InsertDesktop(HWND hWndFT, LPEVDATA lpEVData)
{
	LPMALLOC		lpMalloc;
	LPSHELLFOLDER	lpShellFolder;
	LPITEMIDLIST	lpDesktopIDL;
	HRESULT 		hr;

	//IMalloc擾
	//VFC^[tF[X̏ꍇ̃͂gBGlobalAlloc͎gȂB
	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return FALSE;

	SHGetDesktopFolder(&lpShellFolder);
	SHGetSpecialFolderLocation(lpEVData->lpofne->hWnd,CSIDL_DESKTOP,&lpDesktopIDL);

	InsertItemIDLToFolderTree(hWndFT,lpEVData,NULL,lpDesktopIDL,lpShellFolder,TVI_ROOT,TVI_LAST,lpMalloc);

	lpShellFolder->Release();
	lpMalloc->Free(lpDesktopIDL);
	lpMalloc->Release();

	return	TRUE;
}

//tH_tH_c[ɒǉ
//̊֐ĂяoAIShellFolderReleaseA
//lpFolderIDLB

static BOOL SetFolderIDLToFolderTree(HWND hWndFT,LPEVDATA lpEVData,
						LPITEMIDLIST lpFolderIDL,
						LPSHELLFOLDER lpShellFolder,HTREEITEM hParent)
{
	int 			iCtr;
	HTREEITEM		hPrev;
	HTREEITEM		hNext; 
	HRESULT 		hr;
	HWND			hWndParent;
	LPMALLOC		lpMalloc;
	LPITEMIDLIST	lpItem;
	LPENUMIDLIST	lpEnum;
	TV_ITEM			tvi;
	ULONG			ulFetched;
	BOOL			bHasFolder;

	hPrev = NULL;
	lpItem = NULL;
	lpEnum = NULL;

	//IMalloc擾
	//VFC^[tF[X̏ꍇ̃͂gBGlobalAlloc͎gȂB
	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return FALSE;

	if(!ReleaseFolderTreeData(&lpEVData->FTData)) return FALSE;
	
	hWndParent=lpEVData->lpofne->hWnd;

	//}EXJ[\v
	SetCapture(hWndParent);
	SetCursor(LoadCursor(NULL, IDC_WAIT));

	//t@C񋓂邽߂̃C^[tF[X擾
	hr=lpShellFolder->EnumObjects(hWndParent, 
								  SHCONTF_FOLDERS |
								  (lpEVData->lpofne->DisableArchiveShellFolder ? 0 :
								   SHCONTF_NONFOLDERS) | SHCONTF_INCLUDEHIDDEN,
								  &lpEnum);

	if (SUCCEEDED(hr)){
		iCtr = 0;

		bHasFolder=FALSE;
		//t@C̃ACehcXgit@C̃nh݂Ȃ́j擾
		while (S_OK==lpEnum->Next(1,&lpItem,&ulFetched)){
			hNext=InsertItemIDLToFolderTree(hWndFT,lpEVData,lpFolderIDL,lpItem,lpShellFolder,
											hParent,hPrev,lpMalloc);
			if(hNext!=hPrev){
				bHasFolder=TRUE;
				hPrev=hNext;
			}
			lpMalloc->Free(lpItem);
		}
		
		//tH_PȂꍇ@{
		if(!bHasFolder){
			tvi.hItem=hParent;
			tvi.mask=TVIF_CHILDREN;
			tvi.cChildren=0;
			TreeView_SetItem(hWndFT, &tvi);
		}
	}

	//}EXJ[\
	ReleaseCapture();
	SetCursor(LoadCursor(NULL, IDC_ARROW));

	//擾C^[tF[X͂ƉB
	if (lpEnum)  lpEnum->Release();
	if (lpMalloc) lpMalloc->Release();
 
	return TRUE;
}

//r֐

static int CALLBACK TreeViewCompareProc(LPARAM lparam1, 
								 LPARAM lparam2,
								 LPARAM lparamSort)
{
	#define lpFTItemData1	((LPFTITEMDATA)lparam1)
	#define lpFTItemData2	((LPFTITEMDATA)lparam2)

	HRESULT   hr;

	hr = ((LPSHELLFOLDER)lparamSort)->CompareIDs(0,
												 lpFTItemData1->lpItemIDL,
												 lpFTItemData2->lpItemIDL);
	
	if (FAILED(hr)){
		return 0;
	}

	return (short)SCODE_CODE(GetScode(hr));
}

//c[r[̃bZ[W

LRESULT FolderTreeNotify(HWND hWnd,WPARAM wParam,LPARAM lParam, LPEVDATA lpEVData, LPMALLOC lpMalloc)
{
	#define lpNMTV		((LPNMTREEVIEW)lParam)

	LPFTITEMDATA lpFTItemData;
	LPFTITEMDATA lpFTItemDataP;
	TV_SORTCB tvscb;
	POINT pt;
	TV_HITTESTINFO tvhti;
	TV_ITEM tvi;

	switch(lpNMTV->hdr.code){
		case NM_RCLICK:
			//J[\ʒuIꂽACeT
			GetCursorPos(&pt);
			tvhti.pt=pt;
			ScreenToClient(lpNMTV->hdr.hwndFrom, &tvhti.pt);

			if ((TreeView_HitTest(lpNMTV->hdr.hwndFrom, &tvhti))){
				//IACȅ𓾂
				tvi.mask=TVIF_PARAM;
				tvi.hItem=tvhti.hItem;

				if(!TreeView_GetItem(lpNMTV->hdr.hwndFrom, &tvi)) break;

				lpFTItemData=(LPFTITEMDATA)tvi.lParam;

				//̂P̃ACȅ𓾂
				//etH_IShellFolderKvɂȂ̂ł
				//ACe̒ɐetH_IShellFolderĂȂ
				tvi.hItem=TreeView_GetParent(lpNMTV->hdr.hwndFrom,tvi.hItem);
				if(tvi.hItem==NULL) break;

				if(!TreeView_GetItem(lpNMTV->hdr.hwndFrom, &tvi)) break;

				lpFTItemDataP=(LPFTITEMDATA)tvi.lParam;

				//j[̎s
				DoTheMenuThing(lpEVData->lpofne->hWnd,
								lpFTItemDataP->lpShellFolder,
								&lpFTItemData->lpItemIDL, 1,
								&pt, FALSE, lpEVData->lpofne->Japanese);
			}
			break;

		case TVN_SELCHANGED:
			lpFTItemData=(LPFTITEMDATA)lpNMTV->itemNew.lParam;
			ExplorerView_ChangeTreeItem(lpNMTV->hdr.hwndFrom,lpFTItemData,
														lpNMTV->itemNew.hItem);
			break;

		case TVN_DELETEITEM:

			lpFTItemData=(LPFTITEMDATA)lpNMTV->itemOld.lParam;

			//IShellFolder
			lpFTItemData->lpShellFolder->Release();
			lpMalloc->Free(lpFTItemData->lpItemIDL);  
			lpMalloc->Free(lpFTItemData->lpItemAllIDL);  
			lpMalloc->Free(lpFTItemData);  
			break;

		case TVN_ITEMEXPANDING:

			if ((lpNMTV->itemNew.state & TVIS_EXPANDEDONCE)) break;

			lpFTItemData=(LPFTITEMDATA)lpNMTV->itemNew.lParam;

			SetFolderIDLToFolderTree(lpNMTV->hdr.hwndFrom,lpEVData,lpFTItemData->lpItemAllIDL,
									lpFTItemData->lpShellFolder,lpNMTV->itemNew.hItem);

			tvscb.hParent     = lpNMTV->itemNew.hItem;
			tvscb.lpfnCompare = TreeViewCompareProc;
			tvscb.lParam      = (LPARAM)lpFTItemData->lpShellFolder;

			TreeView_SortChildrenCB(lpNMTV->hdr.hwndFrom, &tvscb, 0);

			break;

		default:
			break;
		
	}
	return FALSE;
}

//qACe񋓂āÂT

static HTREEITEM FindChild(HWND hWndFT,HTREEITEM hParent,LPITEMIDLIST lpItemIDL)
{
	HRESULT			hr;
	HTREEITEM		hItem;
	TVITEM			TVItem;
	LPFTITEMDATA	lpFTParentData,lpFTItemData;

	//TACẽtH_擾
	TVItem.mask=TVIF_PARAM;
	TVItem.hItem=hParent;
	if(!TreeView_GetItem(hWndFT,&TVItem)) return NULL;
	
	lpFTParentData=(LPFTITEMDATA)TVItem.lParam;

	//TACe̎qACe񋓂Ă
	TreeView_Expand(hWndFT,hParent,TVE_EXPAND);

	//Pڂ̎qACe擾
	hItem=TreeView_GetChild(hWndFT,hParent);
	while(hItem!=NULL){
		//qACẽtH_擾
		TVItem.mask=TVIF_PARAM;
		TVItem.hItem=hItem;
		if(TreeView_GetItem(hWndFT,&TVItem)){
			lpFTItemData=(LPFTITEMDATA)TVItem.lParam;
			//r
			hr=lpFTParentData->lpShellFolder->CompareIDs(0,
														 lpFTItemData->lpItemIDL,
														 lpItemIDL);
			if(FAILED(hr)) break;

			if(SCODE_CODE(GetScode(hr))==0) break;
		}
		//̎qACe擾
		hItem=TreeView_GetNextSibling(hWndFT,hItem);
	}

	return	hItem;
}


//w肳ꂽItemIDLT

HTREEITEM FindFolderIDL(HWND hWndFT,HTREEITEM hParent,LPITEMIDLIST lpItemIDL)
{
	LPMALLOC		lpMalloc;
	HRESULT			hr;
	LPITEMIDLIST	lpItemOneID;

	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return FALSE;

	if(hParent==TVI_ROOT){
		hParent=TreeView_GetRoot(hWndFT);
	}

	while(hParent){
		if(lpItemIDL->mkid.cb==0) break;
		//ACehcPoB
		lpItemOneID=CopyITEMID(lpMalloc,lpItemIDL);
		//ACe̒TA炻eƂĂɒTB
		hParent=FindChild(hWndFT,hParent,lpItemOneID);
		lpMalloc->Free(lpItemOneID);
		//̃ACehcɈړB
		lpItemIDL=GetNextIDL(lpItemIDL);
	}
	
	lpMalloc->Release();

	return	hParent;
}
