#define STRICT
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include "explorer.h"
#include "exview.h"
#include "cntmenu.h"
#include "fileview.h"
#include "pidl.h"
#include "common.h"

static BOOL ofne_Japanese;
static char TypeString[256];

//VXeC[WXg̓o^

static BOOL InitFileViewImageLists(HWND hWndFV)
{
	HIMAGELIST himlSmall;
	HIMAGELIST himlLarge;
	SHFILEINFO sfi;
	LPEVDATA lpEVData;
	
	if(!(lpEVData = (LPEVDATA)GetProp(hWndFV , "EVData")))
		return FALSE;

	//̂悤ɂāAC[WXg̃nh𓾂
	himlSmall = (HIMAGELIST)SHGetFileInfo((LPCSTR)lpEVData->lpofne->SystemDriveString,
										  0,
										  &sfi, 
										  sizeof(SHFILEINFO), 
										  SHGFI_SYSICONINDEX | SHGFI_SMALLICON);

	himlLarge = (HIMAGELIST)SHGetFileInfo((LPCSTR)lpEVData->lpofne->SystemDriveString,
										  0,
										  &sfi, 
										  sizeof(SHFILEINFO), 
										  SHGFI_SYSICONINDEX | SHGFI_LARGEICON);

	if (himlSmall && himlLarge)
		{
			//Xgr[ɃC[WXgo^
			ListView_SetImageList(hWndFV, himlSmall, LVSIL_SMALL);
			ListView_SetImageList(hWndFV, himlLarge, LVSIL_NORMAL);
		}
	else{
		return	FALSE;
	}

	return TRUE;
}

//t@Cr[pf[^̈̏

static void InitFileViewData(LPFVDATA lpFVData)
{
	//tH_̃ACehcXg̃AhX
	lpFVData->lpItemIDL=NULL;
	//tH_̃C^[tF[X̃AhX
	lpFVData->lpShellFolder=NULL;
	//\[g
	lpFVData->Sort=-1;
}

//t@Cr[pf[^̈̃f[^̊J

static BOOL ReleaseFileViewData(LPFVDATA lpFVData)
{
	LPMALLOC		lpMalloc;
	HRESULT 		hr;

	//IMalloc擾
	//VFC^[tF[X̏ꍇ̃͂gBGlobalAlloc͎gȂB
	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return FALSE;

	if(lpFVData){
		if(lpFVData->lpShellFolder){
			lpFVData->lpShellFolder->Release();
			lpFVData->lpShellFolder=NULL;
		}
		if(lpFVData->lpItemIDL){
			lpMalloc->Free(lpFVData->lpItemIDL);
			lpFVData->lpItemIDL=NULL;
		}
	}
	lpMalloc->Release();
	
	return	TRUE;
}

static BOOL FileExtensionFilter(LPFVITEMDATA lpFVItemData, HWND hFileView)
{
	static char path_buffer[1025];
	static char drive[_MAX_DRIVE + 1];
	static char dir[_MAX_DIR + 1];
	static char fname[_MAX_FNAME + 1];
	static char ext[_MAX_EXT + 1];
	LPEVDATA lpEVData;
	LPCSTR *filterstring;
	
	if(!(lpEVData = (LPEVDATA)GetProp(hFileView , "EVData")))
		return FALSE;

	if(!Pidl_GetName(lpFVItemData->lpFVData->lpShellFolder,lpFVItemData->lpItemIDL,SHGDN_FORPARSING, path_buffer)) {
		return FALSE;
	}

	_splitpath(path_buffer, drive, dir, fname, ext);

	for(filterstring = lpEVData->lpofne->FilterStrings; *filterstring; filterstring++) {
		if(!lstrcmpi(ext, *filterstring))
			return TRUE;
	}

	return FALSE;
}

//t@Cr[̍쐬

HWND CreateFileView(LPFVCREATE lpFVCreate, LPEVDATA lpEVData)
{
	HWND		hWndFV;
    LV_COLUMN	lvcol;
	int			width;

	ofne_Japanese = lpEVData->lpofne->Japanese;
	lstrcpy(TypeString, lpEVData->lpofne->Japanese ? "" : "Types");
	if(lpEVData->lpofne->FilterOn) {
		lstrcat(TypeString, " (");
		lstrcat(TypeString, lpEVData->lpofne->FilterTitle);
		lstrcat(TypeString, ")");
	}
	else {
		lstrcat(TypeString, lpEVData->lpofne->Japanese ? " (SẴt@C)" : " (All Files)");
	}

	//Xgr[
	//LVS_SHAREIMAGELISTSX^CȊO͕
	hWndFV = CreateWindowEx(lpFVCreate->exstyle,
							WC_LISTVIEW, "",
							lpFVCreate->style,
							lpFVCreate->rc.left,lpFVCreate->rc.top,
							lpFVCreate->rc.right-lpFVCreate->rc.left, lpFVCreate->rc.bottom-lpFVCreate->rc.top,
							lpFVCreate->hParent,
							(HMENU)IDD_FILEVIEW, 
							(HINSTANCE)GetWindowLong(lpFVCreate->hParent, GWL_HINSTANCE), 
							NULL);

	if(!hWndFV) return NULL;

	SetProp(hWndFV,"EVData",(HANDLE)lpEVData);

	width=lpFVCreate->rc.right-lpFVCreate->rc.left;

	//Xgr[ɁAOATCYAށAXV̍ڂǉ
	lvcol.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	lvcol.fmt = LVCFMT_LEFT;
	lvcol.cx = lpFVCreate->width_name;
	lvcol.pszText = (CHAR *)(ofne_Japanese ? "O" : "Name");
	lvcol.iSubItem = 0;
	ListView_InsertColumn(hWndFV, 0, &lvcol);

	lvcol.fmt = LVCFMT_RIGHT;
	lvcol.cx = lpFVCreate->width_size;
	lvcol.pszText = (CHAR *)(ofne_Japanese ? "TCY" : "Size");
	lvcol.iSubItem = 1;
	ListView_InsertColumn(hWndFV, 1, &lvcol);

	lvcol.fmt = LVCFMT_LEFT;
	lvcol.cx = lpFVCreate->width_type;
	lvcol.pszText = (LPTSTR)TypeString;
	lvcol.iSubItem = 2;
	ListView_InsertColumn(hWndFV, 2, &lvcol);

	lvcol.fmt = LVCFMT_LEFT;
	lvcol.cx = lpFVCreate->width_time;
	lvcol.pszText = (CHAR *)(ofne_Japanese ? "XV" : "File Time");
	lvcol.iSubItem = 3;
	ListView_InsertColumn(hWndFV, 3, &lvcol);

	//f[^̈̏
	InitFileViewData(&lpEVData->FVData);
	//VXeC[WXgg悤ɐݒ肷B
	InitFileViewImageLists(hWndFV);

	return hWndFV;
}

//t@Cr[̔j

void DestroyFileView(HWND hWndFV,LPFVDATA lpFVData)
{
	DestroyWindow(hWndFV);
	ReleaseFileViewData(lpFVData);
}

//ACehcXgWIN32_FIND_DATA𓾂

static BOOL GetWFDFromIDList(LPSHELLFOLDER lpShellFolder,LPITEMIDLIST lpItemIDL,
							 ULONG ulAttribs,WIN32_FIND_DATA *wfd)
{
	HANDLE	hFind;
	char	path[MAX_PATH];

	if((ulAttribs & (SFGAO_FILESYSTEM | SFGAO_CAPABILITYMASK))!=(SFGAO_FILESYSTEM | SFGAO_CAPABILITYMASK))
		return FALSE;
	Pidl_GetName(lpShellFolder,lpItemIDL,SHGDN_FORPARSING,path);
	hFind=FindFirstFile(path,wfd);
	if(hFind==INVALID_HANDLE_VALUE)
		return FALSE;
	FindClose(hFind);

	return TRUE;
}

//t@C̎ޖ𓾂
static BOOL GetFVTypeName(LPFVITEMDATA lpFVItemData,LPSTR TypeName)

{
	if(lpFVItemData->ulAttribs & SFGAO_FILESYSTEM){
		return	GetTypeName(lpFVItemData->lpFVData->lpItemIDL,lpFVItemData->lpItemIDL,TypeName);
	}else{
		lstrcpy(TypeName, ofne_Japanese ? "VXetH_" : "System Folder");
		return	TRUE;
	}
	return	TRUE;
}

//\[gpr֐

static int CALLBACK ListViewCompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort)
{
#define	lpFVItemData1	((LPFVITEMDATA)lParam1)
#define	lpFVItemData2	((LPFVITEMDATA)lParam2)
#define	NORMFILEFLG	(SFGAO_CANCOPY|SFGAO_CANMOVE|SFGAO_CANLINK|			\
					 SFGAO_CANRENAME|SFGAO_CANDELETE|SFGAO_HASPROPSHEET)
#define	DRIVEFLG	(SFGAO_CANLINK|				\
					 SFGAO_HASPROPSHEET)

	LPSHELLFOLDER	lpShellFolder;
	HRESULT			hr;
	WIN32_FIND_DATA	wfd1,wfd2;
	char			TypeName1[MAX_PATH],TypeName2[MAX_PATH];
	int				Size1,Size2;
	int				Ret;

	if(lParamSort==SN_NONE) return -1;

	Ret=0;
	if(lpFVItemData1->ulAttribs & SFGAO_FOLDER) Ret-=10;
	switch(lpFVItemData1->ulAttribs & NORMFILEFLG){
	case NORMFILEFLG:	//ʂ̃t@C	D揇ʁ@Rij
		break;
	case DRIVEFLG:		//hCu			D揇ʁ@Pij
		Ret-=30;
		break;
	default:			//̑			D揇ʁ@Qij
		Ret-=20;
		break;
	}
	if(lpFVItemData2->ulAttribs & SFGAO_FOLDER) Ret+=10;
	switch(lpFVItemData2->ulAttribs & NORMFILEFLG){
	case NORMFILEFLG:	//ʂ̃t@C	D揇ʁ@Rij
		break;
	case DRIVEFLG:		//hCu			D揇ʁ@Pij
		Ret+=30;
		break;
	default:			//̑			D揇ʁ@Qij
		Ret+=20;
		break;
	}

	lpShellFolder=lpFVItemData1->lpFVData->lpShellFolder;
	if(Ret==0){
		switch(lParamSort & ~SF_REVERSE){
		case SN_NAME:
			Ret=0;
			break;
		case SN_SIZE:
			if(GetWFDFromIDList(lpShellFolder,lpFVItemData1->lpItemIDL,
								lpFVItemData1->ulAttribs,&wfd1)==FALSE) break;
			if(GetWFDFromIDList(lpShellFolder,lpFVItemData2->lpItemIDL,
								lpFVItemData2->ulAttribs,&wfd2)==FALSE) break;
			Size1=(wfd1.nFileSizeHigh << 16)+wfd1.nFileSizeLow;
			Size2=(wfd2.nFileSizeHigh << 16)+wfd2.nFileSizeLow;
			if(Size1<Size2) Ret=-1;
			else if(Size1>Size2) Ret= 1;
			else Ret=0;
			break;
		case SN_TYPE:
			GetFVTypeName(lpFVItemData1,TypeName1);
			GetFVTypeName(lpFVItemData2,TypeName2);

			Ret=lstrcmp(TypeName1,TypeName2);
			break;
		case SN_TIME:
			if(GetWFDFromIDList(lpShellFolder,lpFVItemData1->lpItemIDL,
								lpFVItemData1->ulAttribs,&wfd1)==FALSE) break;
			if(GetWFDFromIDList(lpShellFolder,lpFVItemData2->lpItemIDL,
								lpFVItemData2->ulAttribs,&wfd2)==FALSE) break;
			Ret=CompareFileTime(&wfd2.ftLastWriteTime,&wfd1.ftLastWriteTime);
			break;
		}
		if(Ret==0){
			hr = lpShellFolder->CompareIDs(0,
										   lpFVItemData1->lpItemIDL,
										   lpFVItemData2->lpItemIDL);

			if (SUCCEEDED(hr)){
				Ret=(short)SCODE_CODE(GetScode(hr));
			}
		}
		if(!(lParamSort & SF_REVERSE)) Ret=-Ret;
	}

	return	Ret;
}

//t@C̃\[g

static void FileView_SortItem(HWND hWndFV,LPFVDATA lpFVData,int Sort)
{
	ListView_SortItems(hWndFV,&ListViewCompareFunc,Sort);
	lpFVData->Sort=Sort;
}

//t@Ct@Cr[ɒǉ
//̊֐ĂяoAIShellFolderReleaseA
//lpFolderIDLidlύXj

BOOL SetFolderIDLToFileView(HWND hWndFV,LPEVDATA lpEVData,
							LPITEMIDLIST lpFolderIDL,
							LPSHELLFOLDER lpShellFolder)
{
	int 			iCtr;
	LV_ITEM 		LVItem;
	HRESULT 		hr;
	HWND			hWndParent;
	LPMALLOC		lpMalloc;
	LPITEMIDLIST	lpItem=NULL;
	LPENUMIDLIST	lpEnum=NULL;
	LPFVITEMDATA	lpFVItemData;
	ULONG			ulFetched, ulAttrs;
	BOOL			Error;

	LVItem.mask = LVIF_TEXT | LVIF_IMAGE | LVIF_PARAM;

	//IMalloc擾
	//VFC^[tF[X̏ꍇ̃͂gBGlobalAlloc͎gȂB
	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return FALSE;

	ShowWindow(hWndFV, SW_HIDE);
	
	ListView_DeleteAllItems(hWndFV);
	if(!ReleaseFileViewData(&lpEVData->FVData)) {
		ShowWindow(hWndFV, SW_SHOW);
		return FALSE;
	}

	hWndParent=lpEVData->lpofne->hWnd;

	//}EXJ[\v
	SetCapture(hWndParent);
	SetCursor(LoadCursor(NULL, IDC_WAIT));

	Error=TRUE;

	//Xgr[̃f[^̈ɕ\tH_IShellFolder̃AhXۑĂ
	lpEVData->FVData.lpShellFolder=lpShellFolder;
	lpShellFolder->AddRef();
	//Xgr[̃f[^̈ɕ\tH_̃ACehcXgۑĂ
	if(lpFolderIDL)
		lpEVData->FVData.lpItemIDL=CopyITEMIDL(lpMalloc,lpFolderIDL);


	//t@C񋓂邽߂̃C^[tF[X擾
	hr=lpShellFolder->EnumObjects(hWndParent, 
								  SHCONTF_FOLDERS | SHCONTF_NONFOLDERS | SHCONTF_INCLUDEHIDDEN,
								  &lpEnum);

	if (SUCCEEDED(hr)){
		iCtr = 0;

		//t@C̃ACehcXgit@C̃nh݂Ȃ́j擾
		while (S_OK==lpEnum->Next(1,&lpItem,&ulFetched)){

			//t@Ci[邽߂̗̈̊m
			lpFVItemData = (LPFVITEMDATA)lpMalloc->Alloc(sizeof(FVITEMDATA));
			if (!lpFVItemData) goto Done;

			ulAttrs=SFGAO_CAPABILITYMASK | SFGAO_GHOSTED | SFGAO_LINK |
				SFGAO_SHARE | SFGAO_FOLDER | SFGAO_FILESYSTEM | SFGAO_HASSUBFOLDER;
			//ulAttrs=0xffffffff;

			lpFVItemData->lpFVData=&lpEVData->FVData;
			//t@C̎擾
			lpShellFolder->GetAttributesOf(1, (LPCITEMIDLIST *)&lpItem, &ulAttrs);
			lpFVItemData->ulAttribs=ulAttrs;
			//t@C̃ACehcXgRs[
			lpFVItemData->lpItemIDL=CopyITEMID(lpMalloc, lpItem);

			//VFtH_[C^[tF[X̎gpJEg𑝂₷
			lpShellFolder->AddRef();

			//gqtB^[
			if(lpEVData->lpofne->FilterOn &&
			   lpEVData->lpofne->FilterStrings &&
			   !(lpFVItemData->ulAttribs & SFGAO_FOLDER) &&
			   !FileExtensionFilter(lpFVItemData, hWndFV)) {
				//ACehcXg
				//̌nAYȂ悤ɂ
				lpMalloc->Free(lpItem);
				lpItem=NULL;
				continue;
			}

			//Xgr[փACȇ}
			//ACeƃACR͂ł͐ݒ肵Ȃ
			//ƕKvɂȂ܂ŁA𒲂ׂKvȂȂ̂ŁA\ȂB
			LVItem.iItem	   = iCtr++;
			LVItem.iSubItem    = 0;
			LVItem.pszText	   = LPSTR_TEXTCALLBACK;
			LVItem.cchTextMax  = MAX_PATH;
			LVItem.iImage	   = I_IMAGECALLBACK;
			LVItem.lParam	   = (LPARAM)lpFVItemData;

			hr=ListView_InsertItem(hWndFV, &LVItem);

			//ACehcXg
			//̌nAYȂ悤ɂ
			lpMalloc->Free(lpItem);
			lpItem=NULL;

			if(hr==-1) goto Done;
		}
	}
	Error=FALSE;


 Done:

	//\[g
	FileView_SortItem(hWndFV,&lpEVData->FVData,lpEVData->FVData.Sort);

	//}EXJ[\
	ReleaseCapture();
	SetCursor(LoadCursor(NULL, IDC_ARROW));

	//擾C^[tF[X͂ƉB
	if (lpItem)  lpMalloc->Free(lpItem);
	if (lpEnum)  lpEnum->Release();
	if (lpMalloc) lpMalloc->Release();
 
	if(ListView_GetItemCount(hWndFV))
		ListView_SetItemState(hWndFV, 0, LVIS_FOCUSED, LVIS_FOCUSED);
	ShowWindow(hWndFV, SW_SHOW);
	return !Error;
}

/* t@Cr[̍XV */
static BOOL RefreshFileView(LPEVDATA lpEVData)
{
	return SetFolderIDLToFileView(lpEVData->hFileView, lpEVData, NULL, lpEVData->FVData.lpShellFolder);
}

//VXep̓𕶎ɂ

static void TimeToString(FILETIME *FileTime,char *buf)
{
	FILETIME ft;
	SYSTEMTIME stWrite;

	FileTimeToLocalFileTime(FileTime, &ft);
	FileTimeToSystemTime(&ft, &stWrite);

	wsprintf(buf,"%04d/%02d/%02d %02d:%02d",
			 stWrite.wYear, stWrite.wMonth, stWrite.wDay,
			 stWrite.wHour, stWrite.wMinute);
}

//TCY𕶎ɂ

static void SizeToString(DWORD High,DWORD Low,char *buf)
{
	wsprintf(buf,"%dKB",((High << 6) +((Low +1023) >>10)));
}

#if 0
//r[X^C̕ύX
static void FileView_ChangeView(HWND hWndFV, DWORD dwView)
{
    DWORD dwStyle;

	dwStyle=GetWindowLong(hWndFV, GWL_STYLE);

    if ((dwStyle & LVS_TYPEMASK) != dwView){
		SetWindowLong(hWndFV, GWL_STYLE, (dwStyle & ~LVS_TYPEMASK) | dwView);
	}
}
#endif

#if 0
//r[X^C̕ύXiACR->ACR->Xg->ڍׁj
static void FileView_ToggleView(HWND hWndFV)
{
    DWORD dwStyle,dwView;

	dwStyle=GetWindowLong(hWndFV, GWL_STYLE);

	switch(dwStyle & LVS_TYPEMASK){
	case LVS_ICON:
		dwView=LVS_SMALLICON;
		break;
	case LVS_SMALLICON:
		dwView=LVS_LIST;
		break;
	case LVS_LIST:
		dwView=LVS_REPORT;
		break;
	case LVS_REPORT:
		dwView=LVS_ICON;
		break;

	default:
		dwView=LVS_ICON;
		break;
	}

	SetWindowLong(hWndFV, GWL_STYLE, (dwStyle & ~LVS_TYPEMASK) | dwView);
}
#endif

BOOL FileView_GetFilename(LPFVITEMDATA lpFVItemData, HWND hFileView)
{
	char path_buffer[1025];
	char drive[_MAX_DRIVE + 1];
	char dir[_MAX_DIR + 1];
	char fname[_MAX_FNAME + 1];
	char ext[_MAX_EXT + 1];
	BOOL retresult;
	LPEVDATA lpEVData;
	
	if(!(lpEVData = (LPEVDATA)GetProp(hFileView , "EVData")))
		return FALSE;

	//VFŃA[JCut@CtH_邩H
	if(!lpEVData->lpofne->DisableArchiveShellFolder && (lpFVItemData->ulAttribs & SFGAO_FOLDER))
		return FALSE;

	retresult = Pidl_GetName(lpFVItemData->lpFVData->lpShellFolder,lpFVItemData->lpItemIDL,SHGDN_FORPARSING, path_buffer);
	if(!retresult || lstrlen(path_buffer) >= (int)(lpEVData->lpofne->nMaxFile) || (GetFileAttributes(path_buffer) & FILE_ATTRIBUTE_DIRECTORY)) {
		retresult = FALSE;
	}
	else if(lpEVData->lpofne->lpstrFile) {
		lstrcpy(lpEVData->lpofne->lpstrFile, path_buffer);
		_splitpath( path_buffer, drive, dir, fname, ext );
		if(lpEVData->lpofne->lpstrFileTitle && (lstrlen(fname) + lstrlen(ext)) < (int)(lpEVData->lpofne->nMaxFileTitle)) {
			lstrcpy(lpEVData->lpofne->lpstrFileTitle, fname);
			lstrcat(lpEVData->lpofne->lpstrFileTitle, ext);
		}
	}
	return retresult;
}

static BOOL FileView_IsFile(LPFVITEMDATA lpFVItemData, HWND hFileView)
{
	char path_buffer[1025];
	LPEVDATA lpEVData;
	
	if(!(lpEVData = (LPEVDATA)GetProp(hFileView , "EVData")))
		return FALSE;

	//VFŃA[JCut@CtH_邩H
	if(!lpEVData->lpofne->DisableArchiveShellFolder && (lpFVItemData->ulAttribs & SFGAO_FOLDER))
		return FALSE;

	if(!Pidl_GetName(lpFVItemData->lpFVData->lpShellFolder,lpFVItemData->lpItemIDL,SHGDN_FORPARSING, path_buffer) ||
	   (GetFileAttributes(path_buffer) & FILE_ATTRIBUTE_DIRECTORY))
		return FALSE;
	return TRUE;
}

//Xgr[̃bZ[W
LRESULT FileViewNotify(HWND hWnd,WPARAM wParam,LPARAM lParam, LPEVDATA lpEVData,LPMALLOC lpMalloc)
{
#define lpNMLV		((LPNM_LISTVIEW)lParam)
#define lpNMLVDISP	((NMLVDISPINFO*)lParam)

	HTREEITEM hTreeItem;
	HWND hTreeView;
	LV_ITEM LVItem;
	LPFVITEMDATA lpFVItemData;
	WIN32_FIND_DATA wfd;
	LV_HITTESTINFO lvhti;
	POINT pt;
	int Sort;
	int num;
	LPITEMIDLIST *lpIDLArray, *p;
	BOOL NeedSelectMenu;
	LV_COLUMN lvcol;

	switch(lpNMLV->hdr.code){
	case NM_DBLCLK:
		//J[\ʒuIꂽACeT
		GetCursorPos((LPPOINT)&pt);
		lvhti.pt=pt;
		ScreenToClient(lpNMLV->hdr.hwndFrom, &lvhti.pt);
		ListView_HitTest(lpNMLV->hdr.hwndFrom, &lvhti);
		if (lvhti.flags & LVHT_ONITEM){
			LVItem.mask = LVIF_PARAM;
			LVItem.iItem = lvhti.iItem;
			LVItem.iSubItem = 0;

			if (!ListView_GetItem(lpNMLV->hdr.hwndFrom, &LVItem)) break;
			PostMessage(lpEVData->lpofne->hWnd, WM_COMMAND, IDOK, 0);
		}
		break;

	case NM_RCLICK:
		//IĂt@C擾
		num=ListView_GetSelectedCount(lpNMLV->hdr.hwndFrom);
		//PłIĂ
		if(num){
			//ACehcXgzp̃m
			lpIDLArray=(LPITEMIDLIST*)lpMalloc->Alloc(sizeof(LPITEMIDLIST)*num);
			if(lpIDLArray){
				p=lpIDLArray;
				LVItem.mask = LVIF_PARAM;
				LVItem.iSubItem = 0;
				LVItem.iItem=-1;
				lpFVItemData=NULL;
				NeedSelectMenu = FALSE;
				//IACe񋓂ăACehcXg̔z
				while((LVItem.iItem=ListView_GetNextItem(lpNMLV->hdr.hwndFrom,
														 LVItem.iItem, LVNI_ALL | LVNI_SELECTED))!=-1){
					if(ListView_GetItem(lpNMLV->hdr.hwndFrom, &LVItem)){
						lpFVItemData=(LPFVITEMDATA)LVItem.lParam;
						if(ListView_GetItemState(lpNMLV->hdr.hwndFrom, LVItem.iItem, LVIS_FOCUSED) &&
						   FileView_IsFile(lpFVItemData, lpNMLV->hdr.hwndFrom))
							NeedSelectMenu = TRUE;
						*p++=lpFVItemData->lpItemIDL;
					}
				}
				if(lpFVItemData){
					GetCursorPos((LPPOINT)&pt);
					//j[̎s
					DoTheMenuThing(lpEVData->lpofne->hWnd,
								   lpFVItemData->lpFVData->lpShellFolder,
								   lpIDLArray, num,
								   &pt, NeedSelectMenu, lpEVData->lpofne->Japanese);
				}
				lpMalloc->Free(lpIDLArray);
			}
		}
		break;

	case LVN_COLUMNCLICK:
		if(lpNMLV->iSubItem == 2) {
			lpEVData->lpofne->FilterOn = !lpEVData->lpofne->FilterOn;
			lstrcpy(TypeString, lpEVData->lpofne->Japanese ? "" : "Types");
			if(lpEVData->lpofne->FilterOn) {
				lstrcat(TypeString, " (");
				lstrcat(TypeString, lpEVData->lpofne->FilterTitle);
				lstrcat(TypeString, ")");
			}
			else {
				lstrcat(TypeString, lpEVData->lpofne->Japanese ? " (S)" : " (All Files)");
			}
			lvcol.mask = LVCF_TEXT;
			lvcol.pszText = TypeString;
			ListView_SetColumn(lpNMLV->hdr.hwndFrom, 2, &lvcol);
			/* t@Cr[XV */
			RefreshFileView(lpEVData);
		}
		else {
			Sort=lpNMLV->iSubItem;
			if(lpEVData->FVData.Sort==Sort) Sort^=SF_REVERSE;	//^~ւ
			FileView_SortItem(lpNMLV->hdr.hwndFrom,&lpEVData->FVData,Sort);
		}
		break;

	case LVN_KEYDOWN:
		if((((LV_KEYDOWN *)lParam)->wVKey) == VK_BACK) {
			hTreeView = GetDlgItem(hWnd, IDD_FOLDERTREE);
			hTreeItem = TreeView_GetSelection(hTreeView);
			if(hTreeItem && (hTreeItem = TreeView_GetParent(hTreeView, hTreeItem))) {
				TreeView_SelectItem(hTreeView, hTreeItem);
			}
		}
		break;


	case LVN_DELETEITEM:

		LVItem.mask = LVIF_PARAM;
		LVItem.iItem = lpNMLV->iItem;
		LVItem.iSubItem = 0;

		if (!ListView_GetItem(lpNMLV->hdr.hwndFrom, &LVItem)) break;
		lpFVItemData=(LPFVITEMDATA)LVItem.lParam;

		//IShellFolder
		lpEVData->FVData.lpShellFolder->Release();
		lpMalloc->Free(lpFVItemData->lpItemIDL);  
		lpMalloc->Free(lpFVItemData);
		break;

	case LVN_GETDISPINFO:


		lpFVItemData = (LPFVITEMDATA)lpNMLVDISP->item.lParam;

		if (lpNMLVDISP->item.mask & LVIF_IMAGE){
			lpNMLVDISP->item.iImage=Pidl_GetIcon(lpFVItemData->lpFVData->lpItemIDL, lpFVItemData->lpItemIDL,
												 SHGFI_PIDL | 
												 SHGFI_SYSICONINDEX | 
												 SHGFI_SMALLICON);

			lpNMLVDISP->item.stateMask = 0;
			lpNMLVDISP->item.state = 0;

			//V[gJbgt@C̏ꍇ̓V[gJbgACRd˂
			if (lpFVItemData->ulAttribs & SFGAO_LINK){
				lpNMLVDISP->item.mask |= LVIF_STATE;
				lpNMLVDISP->item.stateMask = LVIS_OVERLAYMASK;
				lpNMLVDISP->item.state = INDEXTOOVERLAYMASK(2);
			}

			//Lt@C̏ꍇ͋LACRd˂
			if (lpFVItemData->ulAttribs & SFGAO_SHARE){
				lpNMLVDISP->item.mask |= LVIF_STATE;
				lpNMLVDISP->item.stateMask = LVIS_OVERLAYMASK;
				lpNMLVDISP->item.state = INDEXTOOVERLAYMASK(1);
			}

			//Bt@C̏ꍇ͔
			if (lpFVItemData->ulAttribs & SFGAO_GHOSTED){
				lpNMLVDISP->item.mask |= LVIF_STATE;
				lpNMLVDISP->item.stateMask |= LVIS_CUT;
				lpNMLVDISP->item.state |= LVIS_CUT;
			}

		}

		if (lpNMLVDISP->item.mask & LVIF_TEXT){
			switch(lpNMLVDISP->item.iSubItem){
			case 0:
				Pidl_GetName(lpFVItemData->lpFVData->lpShellFolder,lpFVItemData->lpItemIDL, SHGDN_NORMAL,
							 lpNMLVDISP->item.pszText);
				break;
			case 1:
				if(lpFVItemData->ulAttribs & SFGAO_FOLDER) break;
				if(GetWFDFromIDList(lpFVItemData->lpFVData->lpShellFolder,lpFVItemData->lpItemIDL,
									lpFVItemData->ulAttribs,&wfd)==FALSE) break;
				SizeToString(wfd.nFileSizeHigh,wfd.nFileSizeLow,lpNMLVDISP->item.pszText);
				//						wsprintf(lpNMLVDISP->item.pszText,"%x",lpFVItemData->ulAttribs);
				break;
			case 2:
				GetFVTypeName(lpFVItemData,lpNMLVDISP->item.pszText);
				break;
			case 3:
				if(GetWFDFromIDList(lpFVItemData->lpFVData->lpShellFolder,lpFVItemData->lpItemIDL,
									lpFVItemData->ulAttribs,&wfd)==FALSE) break;
				TimeToString(&(wfd.ftLastWriteTime),lpNMLVDISP->item.pszText);
				break;
					
			default:
				break;
			}
		}
		break;

	default:
		break;
	}

	return FALSE;
}
