#ifndef _EXVIEW_H
#define _EXVIEW_H

//ExplorerView쐬Ɏgp\

typedef struct tagFVC
{
	HWND	hParent;
	RECT	rc;
	DWORD	style;
	DWORD	exstyle;
	int		width_name;
	int		width_size;
	int		width_type;
	int		width_time;
} FVCREATE, *LPFVCREATE;

typedef struct tagFTC
{
	HWND	hParent;
	RECT	rc;
	DWORD	style;
	DWORD	exstyle;
} FTCREATE, *LPFTCREATE;

typedef struct tagEVC
{
	FVCREATE	FileView;
	FTCREATE	FolderTree;
} EVCREATE, *LPEVCREATE;

typedef struct tagEVI
{
	HWND	hFileView;
	HWND	hFolderTree;
} EVINFO, *LPEVINFO;

//FileViewp̍\

typedef struct tagFVD
{
	LPSHELLFOLDER	lpShellFolder;
	LPITEMIDLIST	lpItemIDL;
	int				Sort;
} FVDATA, *LPFVDATA;

typedef struct tagFVID
{
	LPFVDATA		lpFVData;
	LPITEMIDLIST	lpItemIDL;
	ULONG			ulAttribs;
} FVITEMDATA, *LPFVITEMDATA;

//FolderTreep̍\

typedef struct tagFTD
{
	int	Dummy;
} FTDATA, *LPFTDATA;

typedef struct tagFTID
{
	LPSHELLFOLDER	lpShellFolder;
	LPITEMIDLIST	lpItemIDL;
	LPITEMIDLIST	lpItemAllIDL;
	ULONG			ulAttribs;
} FTITEMDATA, *LPFTITEMDATA;

//ExplorerViewp̍\

typedef struct tagEXD
{
	HWND		hFileView;
	HWND		hFolderTree;
	FVDATA		FVData;
	FTDATA		FTData;
	HTREEITEM	hSelect;
	LPOPENFILENAMEEXPLORER	lpofne;
} EVDATA, *LPEVDATA;


#define	IDD_FILEVIEW	100
#define	IDD_FOLDERTREE	101

BOOL CreateExplorerView(LPEVCREATE lpEVCreate,LPEVINFO lpEVInfo, LPOPENFILENAMEEXPLORER lpofne);
void DestroyExplorerView(LPEVINFO lpEVInfo);
BOOL ExplorerView_SetFolder(LPEVINFO lpEVInfo,LPITEMIDLIST lpFolderIDL);
BOOL ExplorerView_SetFile(LPEVINFO lpEVInfo,LPITEMIDLIST lpFileIDL);
BOOL ExplorerView_ToChildFolder(HWND hWnd,LPITEMIDLIST lpFolderIDL,BOOL bRoot);
BOOL ExplorerView_ChangeTreeItem(HWND hWnd,LPFTITEMDATA lpFTItemData,HTREEITEM hItem);
LRESULT ExplorerView_Notify(HWND hWnd,WPARAM wParam,LPARAM lParam);
BOOL FileView_GetFilename(LPFVITEMDATA lpFVItemData, HWND hFileView);

#endif

