#define STRICT
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include "explorer.h"
#include "exview.h"
#include "fileview.h"
#include "foldtree.h"
#include "pidl.h"

//t@Cr[pf[^̈̊mۂƏ

static LPEVDATA InitExViewData(void)
{
	LPMALLOC	lpMalloc;
	LPEVDATA	lpEVData;

	if(FAILED(SHGetMalloc(&lpMalloc))) return FALSE;

	lpEVData=(LPEVDATA)lpMalloc->Alloc(sizeof(EVDATA));
	lpMalloc->Release();
	ZeroMemory(lpEVData,sizeof(EVDATA));
	
	return	lpEVData;
}

//t@Cr[pf[^̈̊J

static void ReleaseExViewData(LPEVDATA lpEVData)
{
	LPMALLOC		lpMalloc;

	if(FAILED(SHGetMalloc(&lpMalloc))) return;

	if(lpEVData){
		lpMalloc->Free(lpEVData);
	}
	lpMalloc->Release();
}

BOOL CreateExplorerView(LPEVCREATE lpEVCreate,LPEVINFO lpEVInfo, LPOPENFILENAMEEXPLORER lpofne)
{
	LPEVDATA	lpEVData;

	lpEVData=InitExViewData();
	if(lpEVData==NULL) return FALSE;
	
	lpEVData->lpofne = lpofne;

	lpEVData->hFileView=CreateFileView(&lpEVCreate->FileView,lpEVData);
	if(lpEVData->hFileView==NULL){
		ReleaseExViewData(lpEVData);
		return FALSE;
	}
	lpEVInfo->hFileView=lpEVData->hFileView;

	lpEVData->hFolderTree=CreateFolderTree(&lpEVCreate->FolderTree,lpEVData);
	if(lpEVData->hFolderTree==NULL){
		DestroyFileView(lpEVInfo->hFileView,&lpEVData->FVData);
		RemoveProp(lpEVInfo->hFileView,"EVData");
		ReleaseExViewData(lpEVData);
		return FALSE;
	}
	lpEVInfo->hFolderTree=lpEVData->hFolderTree;

	return TRUE;
}

void DestroyExplorerView(LPEVINFO lpEVInfo)
{
	LPEVDATA	lpEVData;

	lpEVData=(LPEVDATA)GetProp(lpEVInfo->hFileView,"EVData");
	RemoveProp(lpEVInfo->hFileView,"EVData");
	DestroyFileView(lpEVInfo->hFileView,&lpEVData->FVData);
	RemoveProp(lpEVInfo->hFolderTree,"EVData");
	DestroyFolderTree(lpEVInfo->hFolderTree,&lpEVData->FTData);
	ReleaseExViewData(lpEVData);
}

//tH_\
//̊֐ĂяoAIShellFolderReleaseAlpFolderIDL

BOOL ExplorerView_ToChildFolder(HWND hWnd,LPITEMIDLIST lpFolderIDL,BOOL bRoot)
{
	LPEVDATA	lpEVData;
	HTREEITEM	hItem;

	lpEVData=(LPEVDATA)GetProp(hWnd,"EVData");
	if(lpEVData==NULL) return FALSE;

	if(bRoot) lpEVData->hSelect=TVI_ROOT;

	hItem=FindFolderIDL(lpEVData->hFolderTree,lpEVData->hSelect,lpFolderIDL);

	if(hItem==NULL) return FALSE;

	TreeView_Select(lpEVData->hFolderTree,hItem,TVGN_CARET);
	return	TRUE;
}

//tH_\
//̊֐ĂяoAIShellFolderReleaseAlpFolderIDL

BOOL ExplorerView_SetFolder(LPEVINFO lpEVInfo,LPITEMIDLIST lpFolderIDL)
{
	return	ExplorerView_ToChildFolder(lpEVInfo->hFileView,lpFolderIDL,TRUE);
}

//t@CIԂɂ
BOOL ExplorerView_SetFile(LPEVINFO lpEVInfo,LPITEMIDLIST lpFileIDL)
{
	HRESULT hr;
	LV_ITEM LVItem;
	int i, ItemCount;
	int iSelect = -1;

	if(!(ItemCount = ListView_GetItemCount(lpEVInfo->hFileView)))
		return FALSE;

	//tpXACehcXg̖[it@C킷j؂o
	LPITEMIDLIST lpFileIDL0 = lpFileIDL;
	USHORT cbs;
	for(cbs = lpFileIDL0->mkid.cb;
		cbs;
		lpFileIDL0 = (LPITEMIDLIST)((LPBYTE)lpFileIDL0 + cbs),
		cbs = lpFileIDL0->mkid.cb) {
		
		lpFileIDL = lpFileIDL0;
	}

	LVItem.mask = LVIF_PARAM;
	LVItem.iSubItem = 0;
	LVItem.iItem=-1;

	for(i = 0; i < ItemCount; i++) {
		LVItem.iItem = i;
		ListView_GetItem(lpEVInfo->hFileView, &LVItem);
		if(LVItem.lParam) {
			//r
			hr=((LPFVITEMDATA)LVItem.lParam)->lpFVData->lpShellFolder->CompareIDs(0,
																				  ((LPFVITEMDATA)LVItem.lParam)->lpItemIDL,
																				  lpFileIDL);
			if(FAILED(hr)) {
				break;
			}
			if(SCODE_CODE(GetScode(hr))==0) {
				iSelect = i;
				break;
			}
		}
	}

	if(iSelect == -1) {
		return FALSE;
	}

	ListView_SetItemState(lpEVInfo->hFileView, iSelect, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);

	//Iʒu܂ŃXN[
	ListView_EnsureVisible(lpEVInfo->hFileView, iSelect, FALSE);

	return	TRUE;
}

BOOL ExplorerView_ChangeTreeItem(HWND hWnd,LPFTITEMDATA lpFTItemData,HTREEITEM hItem)
{
	LPEVDATA	lpEVData;

	lpEVData=(LPEVDATA)GetProp(hWnd,"EVData");
	if(lpEVData==NULL) return FALSE;

	SetFolderIDLToFileView(lpEVData->hFileView,lpEVData,
		lpFTItemData->lpItemAllIDL,lpFTItemData->lpShellFolder);
	lpEVData->hSelect=hItem;

	return	TRUE;
}

LRESULT ExplorerView_Notify(HWND hWnd,WPARAM wParam,LPARAM lParam)
{
	#define lpNM		((LPNMHDR)lParam)
	#define lpNMLV		((LPNM_LISTVIEW)lParam)
	#define lpNMTV		((LPNMTREEVIEW)lParam)

	LPMALLOC		lpMalloc;
	HRESULT			hr;
	LPEVDATA		lpEVData;

	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr))
		return FALSE;

	if(!(lpEVData=(LPEVDATA)GetProp(lpNM->hwndFrom,"EVData"))) {
		lpMalloc->Release();
		return FALSE;
	}

	switch(lpNM->idFrom){

		case IDD_FILEVIEW:
			switch(lpNMLV->hdr.code){
				default:
					hr = FileViewNotify(hWnd,wParam,lParam,lpEVData,lpMalloc);
				break;
			}
			break;

		case IDD_FOLDERTREE:
			switch(lpNMTV->hdr.code){
				default:
					hr = FolderTreeNotify(hWnd,wParam,lParam,lpEVData,lpMalloc);
					break;
			}
			break;

		default:
			hr = FALSE;
			break;
	}

	lpMalloc->Release();

	return	hr;
}
