#define STRICT
#include <windows.h>
#include <shlobj.h>
#include "explorer.h"
#include "exview.h"
#include "cntmenu.h"
#include "split.h"
#include "ddlgtmpl.h"
#include "common.h"

//#define EXPMINWIDTH 500
//#define EXPMINHEIGHT 375
#define EXPMINWIDTH 500
#define EXPMINHEIGHT 375

/*****************
  ϐ
*****************/
static EVINFO g_EVInfo;
static OPENFILENAMEEXPLORERPOS ofnepos = {
	/* RECT WindowRect */
	{-1, -1, -1, -1},
	/* Maximize */
	FALSE,
	/* Minimize */
	FALSE,
	/* VSplitBarPos0 */
	-1
	/* ColumnWidth0 */
	-1,
	/* ColumnWidth1 */
	-1,
	/* ColumnWidth2 */
	-1,
	/* ColumnWidth3 */
	-1
};

static HWND barwnd;
static LPOPENFILENAMEEXPLORER lpofne;

static LONG LeftSpace;
static LONG RightSpace;
static LONG TopSpace;
static LONG BottomSpace;

/******************
  GȊ֐A   
******************/

static void WindowSizeAddjust(HWND hWnd)
{
	RECT rc;
	LONG ofnew, ofneh;
	DWORD dwStyle;
	HWND hTop, hTop0;
	hTop0 = hWnd;
	do {
		hTop = hTop0;
		hTop0 = GetParent(hTop);
	} while (hTop0);
	dwStyle = GetWindowLong(hTop, GWL_EXSTYLE);
	if(dwStyle & WS_EX_TOPMOST) {
		rc.left = 0;
		rc.top = 0;
		rc.right = GetSystemMetrics(SM_CXSCREEN);
		rc.bottom = GetSystemMetrics(SM_CYSCREEN);
	}
	else {
		SystemParametersInfo(SPI_GETWORKAREA, 0, &rc, 0);
	}
	
	//EChETCYʒuݒǂݍ݂ĂȂꍇA܂͓ǂݍ񂾃EChETCYݒ肪sȏꍇ
	if((ofnepos.WindowRect.left == -1 && ofnepos.WindowRect.right == -1 && ofnepos.WindowRect.top == -1 && ofnepos.WindowRect.bottom == -1)
/*
		|| (ofnepos.WindowRect.right - ofnepos.WindowRect.left) < lpofne->MinWidth
		|| (ofnepos.WindowRect.bottom - ofnepos.WindowRect.top) < lpofne->MinHeight)
*/
		|| ofnepos.WindowRect.right < ofnepos.WindowRect.left || ofnepos.WindowRect.bottom < ofnepos.WindowRect.top)
	{
		GetWindowRect(hWnd, &ofnepos.WindowRect);
		MoveWindow(hWnd, ofnepos.WindowRect.left, ofnepos.WindowRect.top, lpofne->MinWidth, lpofne->MinHeight, TRUE);
	}
	//ǂݍ񂾃EChEʒuݒ肪Ɨ̈̈ʒuTCYƔrĖꍇ
	else if((rc.right - 50) < ofnepos.WindowRect.left || (rc.bottom - 50) < ofnepos.WindowRect.top
			|| rc.top > ofnepos.WindowRect.top || ofnepos.WindowRect.right < 50)
	{
		ofnew = ofnepos.WindowRect.right - ofnepos.WindowRect.left;
		ofneh = ofnepos.WindowRect.bottom - ofnepos.WindowRect.top;
		GetWindowRect(hWnd, &ofnepos.WindowRect);
		MoveWindow(hWnd, ofnepos.WindowRect.left, ofnepos.WindowRect.top, ofnew, ofneh, TRUE);
	}
	//ǂݍ񂾃EChETCYʒuݒŃEChE
	else {
		MoveWindow(hWnd, ofnepos.WindowRect.left, ofnepos.WindowRect.top,
		ofnepos.WindowRect.right - ofnepos.WindowRect.left, ofnepos.WindowRect.bottom - ofnepos.WindowRect.top, TRUE);
	}
	if(ofnepos.Maximize)
		SendMessage (hWnd, WM_SYSCOMMAND, SC_MAXIMIZE, 0);
	return;
}

static void SaveWindowSize(HWND hWnd)
{
	ofnepos.Maximize = IsZoomed(hWnd);
	ofnepos.Minimize = IsIconic(hWnd);

	/* EChEŏԂő剻ԂׂĂ̏ꍇ̓EChETCYݒۑȂ */
	if(ofnepos.Maximize || ofnepos.Minimize)
		return;
	GetWindowRect(hWnd, &ofnepos.WindowRect);
	return;
}

static void SaveSplitBarPos(HWND hWnd, int splitpos, int *target)
{
	*target = splitpos;
	return;
}

static LRESULT DoNotify(HWND hWnd,WPARAM wParam,LPARAM lParam)
{
	return ExplorerView_Notify(hWnd,wParam,lParam);
}

static void SetDesktopToExplorerView(LPEVINFO lpEVInfo)
{
	LPITEMIDLIST	lpDesktopIDL;
	LPMALLOC		lpMalloc;
	HRESULT			hr;

	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return;

	SHGetSpecialFolderLocation(GetParent(lpEVInfo->hFileView),CSIDL_DESKTOP,&lpDesktopIDL);

	ExplorerView_SetFolder(lpEVInfo,lpDesktopIDL);

	lpMalloc->Free(lpDesktopIDL);
	lpMalloc->Release();
}


static LPITEMIDLIST GetItemIDList(LPSHELLFOLDER lpShellFolder, CHAR *lpFileStr)
{
	HRESULT      hr;
	ULONG        chEaten;	//̃TCY󂯎܂B
	ULONG        dwAttributes;	//󂯎܂B
	OLECHAR      ochPath[MAX_PATH + 1];	//ChoCgłB
	LPITEMIDLIST pIDL;	//tH_ACehcłB

	//@ȂƃC^[tFCX̓_Ȃ̂łB
	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, lpFileStr, -1, ochPath, MAX_PATH);
	ochPath[MAX_PATH] = 0;

	//@ۂITEMIDLIST擾܂B
	hr = lpShellFolder->ParseDisplayName(NULL, NULL, ochPath, &chEaten, &pIDL, &dwAttributes);
    
	if(!SUCCEEDED(hr)) pIDL = NULL;

	return pIDL;	//擾ACehcԂ܂B
}
	

static void SetFolderToExplorerView(LPEVINFO lpEVInfo,CHAR *lpFileStr)
{
	LPSHELLFOLDER	lpShellFolder;
	LPITEMIDLIST	lpIDL;
	LPMALLOC		lpMalloc;
	HRESULT			hr;

	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) return;

	SHGetDesktopFolder(&lpShellFolder);
	lpIDL=GetItemIDList(lpShellFolder,lpFileStr);
	if(lpIDL){
		ExplorerView_SetFolder(lpEVInfo,lpIDL);
		lpMalloc->Free(lpIDL);
	}
	lpShellFolder->Release();
	lpMalloc->Release();
}

static void SetFileToExplorerView(LPEVINFO lpEVInfo,CHAR *lpFileStr)
{
	LPSHELLFOLDER	lpShellFolder;
	LPITEMIDLIST	lpIDL;
	LPMALLOC		lpMalloc;
	HRESULT			hr;

	hr=SHGetMalloc(&lpMalloc);
	if (FAILED(hr)) {
		return;
	}
	SHGetDesktopFolder(&lpShellFolder);
	lpIDL=GetItemIDList(lpShellFolder,lpFileStr);
	if(lpIDL){
		ExplorerView_SetFile(lpEVInfo,lpIDL);
		lpMalloc->Free(lpIDL);
	}
	lpShellFolder->Release();
	lpMalloc->Release();
}

static BOOL GetClientRectExp(HWND hWnd, LPRECT lprc)
{
	if(!hWnd || !lprc)
		return FALSE;

	GetClientRect(hWnd, lprc);
	if((LeftSpace + RightSpace) < (lprc->right - lprc->left)) {
		lprc->left += LeftSpace;
		lprc->right -= RightSpace;
	}
	if((TopSpace + BottomSpace) < (lprc->bottom - lprc->top)) {
		lprc->top += TopSpace;
		lprc->bottom -= BottomSpace;
	}
	return TRUE;
}

static LPDLGTEMPLATE MakeDlgTemplate(const char *fontface, const char *captionstr, UINT fontsize)
{
	WCHAR wfontface[256] = {0};
	WCHAR wcaptionstr[256] = {0};
	DWORD dwWords = 0;
	WORD *pwData = (WORD*)NULL; 
	RECT rcDlg = {0, 0, 0, 0};	// in dialog units

	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, (LPCSTR)fontface, -1, (LPWSTR)wfontface, 255);
	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, (LPCSTR)captionstr, -1, (LPWSTR)wcaptionstr, 255);

	// fill out the dialog template header
	dwWords += FillDlgTemplate(pwData ? pwData : NULL, 
							   DS_MODALFRAME | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_POPUP |
							   WS_CAPTION | WS_SYSMENU | WS_CLIPCHILDREN |
							   WS_THICKFRAME,
							   0,						// extended style flags 
							   0,		// number of controls
							   rcDlg,				// position/size
							   fontsize,		
							   wfontface,			// font to use
							   wcaptionstr);

	// allocate memory
	pwData = (WORD*)GlobalAlloc(GPTR, dwWords * sizeof(WORD));
	
	// fill out the dialog template header
	FillDlgTemplate(pwData ? pwData : NULL,
					DS_MODALFRAME | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_POPUP |
					WS_CAPTION | WS_SYSMENU | WS_CLIPCHILDREN |
					WS_THICKFRAME,
					0,						// extended style flags 
					0,		// number of controls
					rcDlg,				// position/size
					fontsize,		
					wfontface,			// font to use
					wcaptionstr);

	return (LPDLGTEMPLATE)pwData;
}

/****************************
  CvV[W
****************************/

static void GetOpenFileNameExplorerInit(HWND hWnd, UINT uMsg)
{
	EVCREATE EVCreate;
	RECT rc, clientrect;
	int framex;

	lpofne->hWnd = hWnd;

	if(lpofne->lpTemplateName && lpofne->lpstrTitle)
		SetWindowText(hWnd, lpofne->lpstrTitle);

	if(lpofne->hIconSm)
		SendMessage(hWnd, WM_SETICON, FALSE, (LPARAM)lpofne->hIconSm);
	else if(lpofne->hIcon)
		SendMessage(hWnd, WM_SETICON, FALSE, (LPARAM)lpofne->hIcon);

	/* EChE\ԏ󂯎 */
	if(lpofne->lpOfnePos)
		MoveMemory((PVOID)&ofnepos, (CONST VOID *)lpofne->lpOfnePos, sizeof(ofnepos));
	WindowSizeAddjust(hWnd);

	GetClientRectExp(hWnd,&EVCreate.FileView.rc);

	EVCreate.FolderTree.rc=EVCreate.FileView.rc;

	EVCreate.FileView.hParent	=	hWnd;
	EVCreate.FileView.rc.left	+=	200;
	EVCreate.FileView.exstyle	=	WS_EX_CLIENTEDGE;
	EVCreate.FileView.style		=	WS_VISIBLE | WS_CHILD | WS_TABSTOP/* | LVS_EDITLABELS */| WS_CLIPSIBLINGS |
									LVS_REPORT | LVS_AUTOARRANGE | LVS_SHAREIMAGELISTS;

	EVCreate.FileView.width_name=	ofnepos.ColumnWidth0 == -1 ? 150 : ofnepos.ColumnWidth0;
	EVCreate.FileView.width_size=	 ofnepos.ColumnWidth1 == -1 ? 50 : ofnepos.ColumnWidth1;
	EVCreate.FileView.width_type=	ofnepos.ColumnWidth2 == -1 ? 150 : ofnepos.ColumnWidth2;
	EVCreate.FileView.width_time=	ofnepos.ColumnWidth3 == -1 ? 120 : ofnepos.ColumnWidth3;

	EVCreate.FolderTree.hParent	=	hWnd;
	EVCreate.FolderTree.rc.right=	EVCreate.FolderTree.rc.left+200;
	EVCreate.FolderTree.exstyle	=	WS_EX_CLIENTEDGE;
	EVCreate.FolderTree.style	=	WS_VISIBLE | WS_CHILD | WS_TABSTOP | TVS_HASLINES | WS_CLIPSIBLINGS |
									TVS_HASBUTTONS | TVS_HASLINES/*| TVS_EDITLABELS*/;
	
	CreateExplorerView(&EVCreate,&g_EVInfo, lpofne);
	
	/* o[ */
	barwnd = NULL;
	if(g_EVInfo.hFolderTree &&
	   g_EVInfo.hFileView &&
	   RegisterSplitBar((HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE), GetClientRectExp)) {
		GetWindowRect(g_EVInfo.hFolderTree, &rc);
		if(ofnepos.VSplitBarPos0 == -1) {
			barwnd = CreateSplitBar(hWnd, SPT_VERTICAL, (rc.right - rc.left), TRUE);
		}
		else {
			barwnd = CreateSplitBar(hWnd, SPT_VERTICAL, ofnepos.VSplitBarPos0, TRUE);
		}
		if(barwnd) {
			if(ofnepos.VSplitBarPos0 == -1) {
				SetSplitWindowPos(barwnd, g_EVInfo.hFolderTree, g_EVInfo.hFileView, (int)(rc.right - rc.left));
			}
			else {
				framex = GetSystemMetrics(SM_CXSIZEFRAME);
				GetClientRectExp(hWnd, &clientrect);
				if(clientrect.right - (framex * 2 - 1) < ofnepos.VSplitBarPos0)
					SetSplitWindowPos(barwnd,
									  g_EVInfo.hFolderTree,
									  g_EVInfo.hFileView,
									  (int)(clientrect.right - (framex * 2 - 1)));
				else
					SetSplitWindowPos(barwnd,
									  g_EVInfo.hFolderTree,
									  g_EVInfo.hFileView,
									  (int)ofnepos.VSplitBarPos0);
			}
		}
	}
	
	SetDesktopToExplorerView(&g_EVInfo);

	char filename [_MAX_PATH + 1];
	char drive[_MAX_DRIVE + 1];
	char dir[_MAX_DIR + 1];
	char fname[_MAX_FNAME + 1];
	char ext[_MAX_EXT + 1];

	if(lpofne->lpstrInitialDir && lpofne->lpstrInitialDir[0]) {
        _splitpath((const char *)lpofne->lpstrInitialDir,
						   drive,
						   dir,
						   fname,
						   ext);
		_makepath(filename, drive, dir, fname, ext);
		if(dir[0] == 0 || fname[0]) {
			lstrcat(filename, "\\");
		}
	}
	
	if(GetFileAttributes(filename) != 0xffffffff) {
		SetFolderToExplorerView(&g_EVInfo, (CHAR *)filename);
		if(lpofne->lpstrFileTitle && lpofne->lpstrFileTitle[0] && 
			lstrlen(filename) + lstrlen(lpofne->lpstrFileTitle) <= _MAX_PATH) {
			lstrcat(filename, lpofne->lpstrFileTitle);
			if(GetFileAttributes(filename) != 0xffffffff) {
				SetFileToExplorerView(&g_EVInfo, (CHAR *)filename);
			}
		}
	}
	else {
		GetCurrentDirectory(_MAX_PATH, filename);
		if(GetFileAttributes(filename) != 0xffffffff)
			SetFolderToExplorerView(&g_EVInfo, filename);
	}
	
	if(ListView_GetItemCount(g_EVInfo.hFileView))
		SetFocus(g_EVInfo.hFileView);
	else
		SetFocus(g_EVInfo.hFolderTree);
}

static LRESULT CALLBACK GetOpenFileNameExplorerProc(HWND hWnd, UINT uMsg,
				  WPARAM wParam, LPARAM lParam)
{
	static unsigned char screstore = FALSE;
	RECT splitrect, clientrect;
	int lvitemcount;
	LV_ITEM LVItem;
	LV_COLUMN lvcol;
	LPFVITEMDATA lpFVItemData;
	LRESULT hr;
	HWND htmp;
	POINT pt;

	if((lpofne->Flags & OFNE_ENABLEHOOK) && lpofne->lpfnHook &&
		lpofne->lpfnHook(hWnd, uMsg, wParam, lParam))
		return TRUE;

	switch (uMsg)
	{
		case WM_INITDIALOG:
			GetOpenFileNameExplorerInit(hWnd, uMsg);
			break;

		case WM_COMMAND:
			switch (LOWORD(wParam)) {
				case IDOK:
/*
					if(TreeView_GetEditControl(g_EVInfo.hFolderTree)) {
						TreeView_EndEditLabelNow(g_EVInfo.hFolderTree, FALSE);
						break;
					}
*/
					if(GetFocus() == g_EVInfo.hFileView || ((htmp = GetDlgItem(hWnd, IDOK)) && GetFocus() == htmp)) {
						if(!(lvitemcount = ListView_GetItemCount(g_EVInfo.hFileView)))
							break;
						
						LVItem.mask = LVIF_PARAM;
						LVItem.iSubItem = 0;
						
						for(LVItem.iItem = 0; LVItem.iItem < lvitemcount; LVItem.iItem++) {
							if(((ListView_GetItemState(g_EVInfo.hFileView,
													   LVItem.iItem,
													   LVIS_FOCUSED | LVIS_SELECTED)) & (LVIS_FOCUSED | LVIS_SELECTED)) ==
							   (LVIS_FOCUSED | LVIS_SELECTED))
								break;
						}
						
						if(LVItem.iItem == lvitemcount)
							break;
						
						if (!ListView_GetItem(g_EVInfo.hFileView, &LVItem))
							break;
						
						lpFVItemData=(LPFVITEMDATA)LVItem.lParam;
						
						if((lpofne->ReturnValue = FileView_GetFilename(lpFVItemData, g_EVInfo.hFileView))) {
							PostMessage(hWnd, WM_COMMAND, IDCANCEL, 0);
						}
						else if(lpFVItemData->ulAttribs & SFGAO_FOLDER) {
							ExplorerView_ToChildFolder(g_EVInfo.hFileView,lpFVItemData->lpItemIDL,FALSE);
						}
					}
					break;

				case IDCANCEL:
					if(TreeView_GetEditControl(g_EVInfo.hFolderTree)) {
						TreeView_EndEditLabelNow(g_EVInfo.hFolderTree, TRUE);
						break;
					}
					SaveWindowSize(hWnd);
					lvcol.mask = LVCF_WIDTH;
					if(ListView_GetColumn(g_EVInfo.hFileView, 0, &lvcol))
						ofnepos.ColumnWidth0 = lvcol.cx;
					if(ListView_GetColumn(g_EVInfo.hFileView, 1, &lvcol))
						ofnepos.ColumnWidth1 = lvcol.cx;
					if(ListView_GetColumn(g_EVInfo.hFileView, 2, &lvcol))
						ofnepos.ColumnWidth2 = lvcol.cx;
					if(ListView_GetColumn(g_EVInfo.hFileView, 3, &lvcol))
						ofnepos.ColumnWidth3 = lvcol.cx;
					
					/* EChE\ԏn */
					if(lpofne->lpOfnePos)
						MoveMemory((PVOID)lpofne->lpOfnePos, (CONST VOID *)&ofnepos, sizeof(ofnepos));
					
					DestroyExplorerView(&g_EVInfo);
					EndDialog(hWnd, IDCANCEL);
					break;

				default:
					break;
			}
			break;

		case WM_SIZE:
			switch (wParam) {
				case SIZE_RESTORED:
					if(barwnd && screstore) {
						GetClientRectExp(hWnd, &clientrect);
						GetWindowRect(barwnd, &splitrect);
						pt.x = pt.y = 0;
						ClientToScreen(hWnd, &pt);
						if(pt.x + (clientrect.right - clientrect.left) <= splitrect.right) {
							SendMessage(barwnd, SPL_SETPOS, (clientrect.right - (splitrect.right - splitrect.left)) - 1, 0);
						}
						screstore = FALSE;
					}
					break;
				
				default:
					break;
			}
			if(barwnd) {
				SetSplitWindowPos(barwnd,
								  g_EVInfo.hFolderTree,
								  g_EVInfo.hFileView,
								  (int)SendMessage(barwnd, SPL_GETPOS, 0, 0));
			}
			break;

		case WM_SIZING:
			hr = FALSE;
/*
			if((((LPRECT)lParam)->right - ((LPRECT)lParam)->left) < lpofne->MinWidth) {
				if(wParam == WMSZ_LEFT || wParam == WMSZ_TOPLEFT || wParam == WMSZ_BOTTOMLEFT )
					((LPRECT)lParam)->left = ((LPRECT)lParam)->right - lpofne->MinWidth;
				else
					((LPRECT)lParam)->right = ((LPRECT)lParam)->left + lpofne->MinWidth;
				hr = TRUE;
			}
			if((((LPRECT)lParam)->bottom - ((LPRECT)lParam)->top) < lpofne->MinHeight) {
				if(wParam == WMSZ_TOP || wParam == WMSZ_TOPLEFT || wParam == WMSZ_TOPRIGHT)
					((LPRECT)lParam)->top = ((LPRECT)lParam)->bottom - lpofne->MinHeight;
				else
					((LPRECT)lParam)->bottom = ((LPRECT)lParam)->top + lpofne->MinHeight;
				hr = TRUE;
			}
*/
			return hr;

		case SPL_MOVE:
			if(barwnd) {
				SetSplitWindowPos(barwnd, g_EVInfo.hFolderTree, g_EVInfo.hFileView, (int)wParam);
				SaveSplitBarPos(hWnd, (int)wParam, &ofnepos.VSplitBarPos0);
			}
			break;

		case EXP_SETCLIENTSPACE:
			LeftSpace = (LONG)HIWORD(wParam);
			RightSpace = (LONG)LOWORD(wParam);
			TopSpace = (LONG)HIWORD(lParam);
			BottomSpace = (LONG)LOWORD(lParam);
			break;

		case WM_EXITSIZEMOVE:
			break;

		case WM_PAINT:
			break;

		/* _CAOwiFύX */
		case WM_CTLCOLORDLG:
//			return (long)GetStockObject(WHITE_BRUSH);
			break;

		case WM_NOTIFY:
			return DoNotify(hWnd,wParam,lParam);

		case WM_INITMENUPOPUP:
			DoHandleMenuMsg(uMsg, wParam, lParam);
			return TRUE;

		case WM_DRAWITEM:
		case WM_MEASUREITEM:
			DoHandleMenuMsg(uMsg, wParam, lParam);
			return TRUE;

		case WM_SYSCOMMAND:
			switch(wParam) {
				case SC_MAXIMIZE:
					SaveWindowSize(hWnd);
					break;

				case SC_MINIMIZE:
					SaveWindowSize(hWnd);
					break;

				case SC_RESTORE:
					screstore = TRUE;
					break;

				default:
					break;
			}
			break;

		default:
			break;

	}
	return FALSE;
}


/**********************************
  OĂяoĎgp
***********************************/

BOOL GetOpenFileNameExplorer(LPOPENFILENAMEEXPLORER ofne)
{
	static unsigned char OleInitialized = FALSE;
	static unsigned char InitializedCommonControls = FALSE;
	LPDLGTEMPLATE dtmpl;
	
	if(!ofne)
		return FALSE;
	
	lpofne = ofne;
	lpofne->ReturnValue = FALSE;
	
	/* OLȄs܂B */
	if(!OleInitialized && OleInitialize(NULL) != S_OK){
		MessageBox(NULL,"Failed! OleInitialize()","Error",MB_OK | MB_ICONERROR);
		return FALSE;
	}
	
	OleInitialized = TRUE;
	LeftSpace = RightSpace = TopSpace = BottomSpace = 0;
	
	if(!InitializedCommonControls) {
		InitCommonControls();
		InitializedCommonControls = TRUE;
	}
	
	if(!lpofne->SystemDriveString[0] && GetWindowsDirectory((LPTSTR)lpofne->SystemDriveString, MAX_PATH + 1)) {
		if(lpofne->SystemDriveString[1] == ':' && lpofne->SystemDriveString[2] == '\\')
			lpofne->SystemDriveString[3] = 0;
		else
			lstrcpy(lpofne->SystemDriveString, "C:\\");
	}
	
	if(ofne->MinWidth == 0)
		ofne->MinWidth = EXPMINWIDTH;
	if(ofne->MinHeight == 0)
		ofne->MinHeight = EXPMINHEIGHT;
	
	if(ofne->lpTemplateName) {
		DialogBoxParam(ofne->hInstance,
					   ofne->lpTemplateName,
					   ofne->hwndOwner,
					   (DLGPROC)GetOpenFileNameExplorerProc,
					   (LPARAM)ofne);
	}
	else {
		if(ofne->Japanese) {
			dtmpl = MakeDlgTemplate("lr oSVbN",
									ofne->lpstrTitle ? (const char *)(ofne->lpstrTitle) : (""), 9);
		}
		else {
			dtmpl = MakeDlgTemplate("MS Sans Serif",
									ofne->lpstrTitle ? (const char *)(ofne->lpstrTitle) : (""), 8);
		}

		if(dtmpl) {
			DialogBoxIndirectParam(ofne->hInstance,
								   (LPDLGTEMPLATE)dtmpl,
								   ofne->hwndOwner,
								   (DLGPROC)GetOpenFileNameExplorerProc,
								   (LPARAM)ofne);
			GlobalFree((HGLOBAL)dtmpl);
		}
	}

	ofne->hWnd = NULL;

	return lpofne->ReturnValue;
}
