////////////////////////////////////////////////////////////////////////////////
//
//	CODE SAMPLES [Gregory Toprover, (C) 1992-2001]
//
//------------------------------------------------------------------------------
//
//	DYNAMIC DIALOG SAMPLE TEST APPLICATION
//
//------------------------------------------------------------------------------
//
//	DDLGTMPL.CPP: Dynamic dialog template contruction
//
//==============================================================================


////////////////////////////////////////////////////////////////////////////////
//
//	DEFINITIONS
//
//------------------------------------------------------------------------------
//
#define STRICT
#include <windows.h>
//
//------------------------------------------------------------------------------
//
#include "ddlgtmpl.h"
//
//==============================================================================


////////////////////////////////////////////////////////////////////////////////
//
DWORD FillDlgTemplate(WORD*		pwBuffer,
											DWORD		dwStyle, 
											DWORD		dwExStyle, 
											UINT		nControls,
											RECT		rcRect, 
											UINT		nFontSize, 
											WCHAR*	wszFontFace, 
											WCHAR*	wszCaption)
{
	DWORD dwCounter = 0;

	// fill out the header
	if (pwBuffer)
	{
		LPDLGTEMPLATE dlgtemplate = (LPDLGTEMPLATE)pwBuffer;
		dlgtemplate->style =	(wcslen(wszCaption) ? WS_CAPTION : 0) | 
													(wcslen(wszFontFace) ? DS_SETFONT : 0) | 
													dwStyle;
		dlgtemplate->dwExtendedStyle = dwExStyle; 
		dlgtemplate->cdit = nControls;
		dlgtemplate->x = (short)rcRect.left;
		dlgtemplate->y = (short)rcRect.top;
		dlgtemplate->cx = (short)rcRect.right;
		dlgtemplate->cy = (short)rcRect.bottom; 
	}
	dwCounter += sizeof(DLGTEMPLATE) / sizeof(WORD);

	// menu ordinal
	if (pwBuffer) pwBuffer[dwCounter] = 0;
	dwCounter++;

	// class ordinal
	if (pwBuffer) pwBuffer[dwCounter] = 0;
	dwCounter++;

	// caption
	if (pwBuffer) wcscpy((wchar_t *)&(pwBuffer[dwCounter]), wszCaption);
	dwCounter += wcslen(wszCaption);
	if (pwBuffer) pwBuffer[dwCounter] = 0;
	dwCounter++;

	// font size
	if (pwBuffer) pwBuffer[dwCounter] = nFontSize;
	dwCounter++;

	// font face
	if (pwBuffer) wcscpy((wchar_t *)&(pwBuffer[dwCounter]), wszFontFace);
	dwCounter += wcslen(wszFontFace);
	if (pwBuffer) pwBuffer[dwCounter] = 0;
	dwCounter++;

	// DWORD alignment
	if (dwCounter % 2) { if (pwBuffer) pwBuffer[dwCounter] = 0; dwCounter++; }

	return dwCounter;
}
//
//------------------------------------------------------------------------------
//
DWORD FillDlgItemTemplate(WORD*		pwBuffer,
													WCHAR*	wszClass, 
													DWORD		dwStyle, 
													DWORD		dwExStyle, 
													RECT		rcRect, 
													UINT		nCtlID, 
													WCHAR*	wszTitle)
{
	DWORD dwCounter = 0;

	// fill in the DLGITEMTEMPLATE structure
	if (pwBuffer)
	{	
		LPDLGITEMTEMPLATE dlgitem = (LPDLGITEMTEMPLATE)&(pwBuffer[dwCounter]);
		dlgitem->style = dwStyle;
		dlgitem->dwExtendedStyle = dwExStyle; 
		dlgitem->x = (short)rcRect.left; 
		dlgitem->y = (short)rcRect.top; 
		dlgitem->cx = (short)rcRect.right; 
		dlgitem->cy = (short)rcRect.bottom; 
		dlgitem->id = nCtlID; 
	}
	dwCounter += sizeof(DLGITEMTEMPLATE) / sizeof(WORD);
	
	// set the class
	if (wszClass[0] == 0xFFFF)	// set by ordinal
	{
		if (pwBuffer) pwBuffer[dwCounter]	= wszClass[0];
		if (pwBuffer) pwBuffer[dwCounter+1]	= wszClass[1];
		dwCounter += 2;
	}		
	else	// set by class name
	{	
		if (pwBuffer) wcscpy((wchar_t *)&(pwBuffer[dwCounter]), wszClass);
		dwCounter += wcslen(wszClass);
		if (pwBuffer) pwBuffer[dwCounter] = 0;
		dwCounter++;
	}

	// set the title
	if (pwBuffer) wcscpy((wchar_t *)&(pwBuffer[dwCounter]), wszTitle);
	dwCounter += wcslen(wszTitle);
	if (pwBuffer) pwBuffer[dwCounter] = 0;
	dwCounter++;

	// set creation data (always zero)
	if (pwBuffer) pwBuffer[dwCounter] = 0;
	dwCounter++;

	// DWORD alignment
	if (dwCounter % 2) { if (pwBuffer) pwBuffer[dwCounter] = 0; dwCounter++; }

	return dwCounter;
}
//
//==============================================================================
