
SECTION .text ALIGN = 4

GLOBAL _IsMMXEnabled

;Check MMX CPU
_IsMMXEnabled:
	push	ebx
	push	ebp
	push	esi
	push	edi
	call is_cpuid_supported
	test eax, 1
	jz nommx
	mov edx, 0
	mov eax, 1
	cpuid
	test edx, 0x00800000
	jz nommx
	mov eax, 1
	jmp immee

nommx:
	mov eax, 0

immee:
	pop	edi
	pop	esi
	pop	ebp
	pop	ebx
	ret

;Check CPUID support
is_cpuid_supported:
	pushfd                     ; get extended flags
	pop eax
	mov edx, eax               ; save current flags
	xor eax, 0x200000          ; toggle bit 21
	push eax                   ; put new flags on stack
	popfd                      ; flags updated now in flags
	pushfd                     ; get extended flags
	pop eax
	xor eax, edx               ; if bit 21 r/w then supports cpuid
	jz cpuid_not_found
	mov eax, 1
	jmp cpuid_done

cpuid_not_found:
	mov eax, 0

cpuid_done:
	ret
