#include "printstr.h"
#include "h6x12.h"
#include "z12x12.h"

static inline void PrintCharacter6x12(void(*putfontpixelproc)(int x, int y),
									  void(*putblankpixelproc)(int x, int y),
                                      int x, int y, u8 *pfontdata)
{
	int fx, fy;
	
	for(fy = 0; fy < 12; fy++) {
		for(fx = 0; fx < 6; fx++) {
			if (*(pfontdata + fy) & (0x80 >> fx)) {
				putfontpixelproc(x + fx, y + fy);
				if(fx == 0)
					putblankpixelproc(x + fx - 1, y + fy);
				if(fy == 0)
					putblankpixelproc(x + fx, y + fy - 1);
				if(fx == 5)
					putblankpixelproc(x + fx + 1, y + fy);
				if(fy == 11)
					putblankpixelproc(x + fx, y + fy + 1);
			}
			else if((fx < 5 && (*(pfontdata + fy) & (0x80 >> (fx + 1)))) ||
					(fy < 11 && (*(pfontdata + fy + 1) & (0x80 >> fx))) ||
					
					(fx > 0 && (*(pfontdata + fy) & (0x80 >> (fx - 1)))) ||
					(fy > 0 && (*(pfontdata + fy - 1) & (0x80 >> fx)))
					) {
				putblankpixelproc(x + fx, y + fy);
			}
		}
	}
	return;
}

static inline void PrintCharacter12x12(void(*putfontpixelproc)(int x, int y),
									   void(*putblankpixelproc)(int x, int y),
                                       int x, int y, u8 *pfontdata)
{
	int fx, fy;
	
	for(fy = 0; fy < 12; fy++) {
		for(fx = 0; fx < 8; fx++) {
			if (*(pfontdata + fy * 2) & (0x80 >> fx)) {
				putfontpixelproc(x + fx, y + fy);
				if(fx == 0)
					putblankpixelproc(x + fx - 1, y + fy);
				if(fy == 0)
					putblankpixelproc(x + fx, y + fy - 1);
				if(fy == 11)
					putblankpixelproc(x + fx, y + fy + 1);
			}
			else if((fx < 7 && (*(pfontdata + fy * 2) & (0x80 >> (fx + 1)))) ||
					(fx == 7 && (*(pfontdata + fy * 2 + 1) & 0x80)) ||
					(fy < 11 && (*(pfontdata + (fy + 1) * 2) & (0x80 >> fx))) || 
					
					(fx > 0 && (*(pfontdata + fy * 2) & (0x80 >> (fx - 1)))) ||
					(fy > 0 && (*(pfontdata + (fy - 1) * 2) & (0x80 >> fx)))
					){
				putblankpixelproc(x + fx, y + fy);
			}
		}
		for(fx = 0; fx < 4; fx++) {
			if (*(pfontdata + fy * 2 + 1) & (0x80 >> fx)) {
				putfontpixelproc(x + fx + 8, y + fy);
				if(fy == 0)
					putblankpixelproc(x + fx + 8, y + fy - 1);
				if(fx == 3)
					putblankpixelproc(x + fx + 8 + 1, y + fy);
				if(fy == 11)
					putblankpixelproc(x + fx + 8, y + fy + 1);
			}
			else if((fx < 3 && (*(pfontdata + fy * 2 + 1) & (0x80 >> (fx + 1)))) ||
					(fy < 11 && (*(pfontdata + (fy + 1) * 2 + 1) & (0x80 >> fx))) || 
					
					(fx > 0 && (*(pfontdata + fy * 2 + 1) & (0x80 >> (fx - 1)))) ||
					(fx == 0 && (*(pfontdata + fy * 2) & (0x80 >> 7))) ||
					(fy > 0 && (*(pfontdata + (fy - 1) * 2 + 1) & (0x80 >> fx)))
					) {
				putblankpixelproc(x + fx + 8, y + fy);
			}
		}
	}
	return;
}

u8 PrintString(void(*putfontpixelproc)(int x, int y),
				  void(*putblankpixelproc)(int x, int y),
				  int sx, int sy, int x, int y, const char *string)
{
	u8 *pfontdata;
	
	if(x < 0 || y < 0 || !putfontpixelproc || !putblankpixelproc || !string)
		return 0;
	
	++x;
	++y;
	
	for(pfontdata = 0; *string; string++, pfontdata = 0) {
		/* SJIS 12x12 */
		if(((*(u8 *)(string) >= 0x81 && *(u8 *)(string) <= 0x9f) ||
			(*(u8 *)(string) >= 0xe0 && *(u8 *)(string) <= 0xfc)) &&
		   ((*(u8 *)(string + 1) >= 0x40 && *(u8 *)(string + 1) <= 0x7e) ||
			(*(u8 *)(string + 1) >= 0x80 && *(u8 *)(string + 1) <= 0xfc))) {
			
			if((u16)(((*(u8 *)(string)) << 8) | (*(u8 *)(string + 1))) >= 0x8140 &&
			   (u16)(((*(u8 *)(string)) << 8) | (*(u8 *)(string + 1))) <= 0x9ffc)
				pfontdata = (u8 *)&z12x12_0x8140[(u32)((u16)(((*(u8 *)(string)) << 8) |
																	  (*(u8 *)(string + 1))) - 0x8140) * 24];
			
			else if((u16)(((*(u8 *)(string)) << 8) | (*(u8 *)(string + 1))) >= 0xe040 &&
					(u16)(((*(u8 *)(string)) << 8) | (*(u8 *)(string + 1))) <= 0xfcfc)
				pfontdata = (u8 *)&z12x12_0xe040[(u32)((u16)(((*(u8 *)(string)) << 8) |
																	  (*(u8 *)(string + 1))) - 0xe040) * 24];
			
			if(pfontdata) {
				if(sx < (x + 13)) {
					x = 1;
					y += 13;
				}
				if((sx < (x + 13)) || (sy < (y + 13))) {
					break;
				}
				PrintCharacter12x12(putfontpixelproc,
									putblankpixelproc, x, y, pfontdata);
				x += 13;
			}
			++string;
		}
		/*       6x12 */
		else {
			pfontdata = (u8 *)&h6x12[(u32)(*(u8 *)(string)) * 12];
			if(sx < (x + 7)) {
				x = 1;
				y += 13;
			}
			if((sx < (x + 7)) || (sy < (y + 13))) {
				break;
			}
			PrintCharacter6x12(putfontpixelproc,
							   putblankpixelproc, x, y, pfontdata);
			x += 7;
		}
	}
	return 1;
}

