#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "lhaccess.h"
#include "urarlib.h"

#ifndef __WIN32__
typedef int int32;
#else
typedef long int32;
#endif

#undef TRUE
#undef FALSE
#define TRUE 1
#define FALSE 0

//#define MAXFILESIZE 0x600200
#define MAXFILESIZE 0x800200

unsigned char LoadLha(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                      int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader);
unsigned char LoadRar(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                      int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader);
unsigned char LoadCab(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                      int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader);

unsigned char LoadArch(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                       int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader)
{
	//Check ext
	static char extstr[1024];
	char *extptr = strrchr((const char *)archname, '.');
	if(extptr && strlen(extptr) < 1024)
		strcpy(extstr, extptr);
	else
		return FALSE;

	*TotalFileSize = 0;
	*headers = 0;

	//Select output format
	if(!strcasecmp(extstr, ".lzh"))
		return LoadLha(databuf, archname, TotalFileSize, headers, ForceNoHeader, ForceHeader);
	else if(!strcasecmp(extstr, ".rar"))
		return LoadRar(databuf, archname, TotalFileSize, headers, ForceNoHeader, ForceHeader);
	else if(!strcasecmp(extstr, ".cab"))
		return LoadCab(databuf, archname, TotalFileSize, headers, ForceNoHeader, ForceHeader);
	else
		return FALSE;
}

unsigned char LoadLha(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                      int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader)
{
	ROOT root;
	int errret;
	if(islzh((char *)archname))
		return FALSE;
	errret = open_root((char *)archname, &root);
	if(errret) {
		if(errret == 2)
			close_root( &root );
		return FALSE;
	}
	if(get_all_header(&root)) {
		close_root( &root );
		return FALSE;
	}
	int filenum;
	for(filenum = 1; filenum <= root.number; filenum++) {
		if(lzh_fopen(&root , filenum)) {
			close_root( &root );
			return FALSE;
		}
		if(((root.now->filesize % 0x2000) != 512 && (root.now->filesize % 0x2000) != 0) ||
			((root.now->filesize % 0x2000) == 512 && root.now->filesize < 0x8200) ||
			((root.now->filesize % 0x2000) == 0 && root.now->filesize < 0x8000))
			continue;
		else
			break;
	}
	if(filenum > root.number || root.now->filesize > MAXFILESIZE) {
		close_root( &root );
		return FALSE;
	}
	long readbyte = lzh_fread(databuf , (long)(root.now->filesize));
	if(readbyte != (long)(root.now->filesize)) {
		close_root( &root );
		return FALSE;
	}
	long calc_size = readbyte / 0x2000;
	calc_size *= 0x2000;
	if ((readbyte - calc_size == 512 && !ForceNoHeader) || ForceHeader)
	{
		memmove (databuf, databuf + 512, calc_size);
		(*headers)++;
		readbyte -= 512;
	}
	(*TotalFileSize) += (int32)readbyte;
	close_root( &root );
	return TRUE;
}

unsigned char LoadRar(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                      int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader)
{
	ArchiveList_struct *List = NULL;
	MemoryFile *rarfile = rarfile_open((char *)archname);
	if(!rarfile)
		return FALSE;
	int filecounter = urarlib_list(rarfile, &List);
	if(!filecounter || !List) {
		urarlib_list_close((MemoryFile *)rarfile, List);
		return FALSE;
	}
	ArchiveList_struct *nextList = List;
	while(nextList)
	{
		if(((nextList->item.UnpSize % 0x2000) == 512 && nextList->item.UnpSize >= 0x8200 && nextList->item.UnpSize <= MAXFILESIZE) ||
			((nextList->item.UnpSize % 0x2000) == 0 && nextList->item.UnpSize >= 0x8000 && nextList->item.UnpSize <= (MAXFILESIZE - 0x200)))
			break;
		nextList = nextList->next;
	}
	unsigned long unrardatasize = 0;
	char *unrardata = NULL;
	if(!nextList || !urarlib_get(&unrardata, &unrardatasize, nextList->item.Name, rarfile, NULL)) {
		urarlib_list_close((MemoryFile *)rarfile, List);
		return FALSE;
	}
	memmove(databuf, unrardata, (size_t)unrardatasize);
	free(unrardata);
	urarlib_list_close((MemoryFile *)rarfile, List);
	long calc_size = unrardatasize / 0x2000;
	calc_size *= 0x2000;

	if ((unrardatasize - calc_size == 512 && !ForceNoHeader) || ForceHeader)
	{
		memmove (databuf, databuf + 512, calc_size);
		(*headers)++;
		unrardatasize -= 512;
	}

	(*TotalFileSize) += (int32)unrardatasize;
	return TRUE;
}

#if 0
extern "C" unsigned char IncludedBinaryData;
extern "C" unsigned long IncludedBinaryDataSize;

unsigned char *GetIncludedBinaryData(char *filename, unsigned long *datasize)
{
	MemoryFile rarfile;
	ArchiveList_struct *List = NULL;
	rarfile.data = (void *)&IncludedBinaryData;
	rarfile.size = IncludedBinaryDataSize;
	rarfile.offset = 0;
	int filecounter = urarlib_list(&rarfile, &List);
	if(!filecounter || !List) {
		rarfile.data = NULL;
		urarlib_list_close(&rarfile, List);
		return NULL;
	}
	ArchiveList_struct *nextList = List;
	while(nextList)
	{
		if(!stricmp(nextList->item.Name, filename))
			break;
		nextList = nextList->next;
	}
	char *unrardata = NULL;
	if(!nextList || !urarlib_get(&unrardata, datasize, nextList->item.Name, &rarfile, NULL)) {
		rarfile.data = NULL;
		urarlib_list_close(&rarfile, List);
		return NULL;
	}
	rarfile.data = NULL;
	urarlib_list_close(&rarfile, List);
	return (unsigned char *)unrardata;
}
#endif

#include <sys/types.h>
#include "cabexlib.h"

unsigned char LoadCab(unsigned char *databuf, const char *archname, int32 *TotalFileSize,
                      int32 *headers, unsigned char ForceNoHeader, unsigned char ForceHeader)
{
	struct cabinet *basecab, *cab;
	struct file *filelist, *fi;
	char *fullname, *tail;
	ULONG calc_size;
	unsigned char loadcabresult = FALSE;
	basecab = load_cab((char *)archname);
	if (!basecab)
		return FALSE;
	if (basecab->flags & cfheadPREV_CABINET) {
		unload_cab(basecab);
		return FALSE;
	}

	tail = rindex(archname, SLASH_CHAR);

	for (cab = basecab; cab; cab = cab->nextcab) {
		if (cab->flags & cfheadNEXT_CABINET) {

			/* try to extend cabinet name to include full path of cabinet */
			if (tail) {
				fullname = (char *)cMemoryAllocation((tail-archname) + strlen((const char *)cab->nextname) + 2);
				if (fullname) {
					strcpy(fullname, archname);
					strcpy(fullname + (tail-archname) + 1, cab->nextname);
					if(cab->nextname)
						free(cab->nextname);
					cab->nextname = fullname;
				}
			}
			//printf("%s: next cabinet in sequence = %s\n", cabname, cab->nextname);
			cab->nextcab = load_cab(cab->nextname);
			if (!cab->nextcab) {
				//printf("%s: can't read next cabinet %s\n", cabname, cab->nextname);
				unload_cab(basecab);
				return FALSE;
			}
			cab->nextcab->prevcab = cab;
		}
	}
	filelist = process_files(basecab);
	CAB(current) = NULL;
	for (fi = filelist; fi; fi = fi->next) {
		//check size
		if(((fi->length % 0x2000) == 512 && fi->length >= 0x8200 && fi->length <= MAXFILESIZE) ||
			((fi->length % 0x2000) == 0 && fi->length >= 0x8000 && fi->length <= (MAXFILESIZE - 0x200))) {
			loadcabresult = cab_extract_file_to_mem(fi, databuf);
			calc_size = fi->length / 0x2000;
			calc_size *= 0x2000;
			if ((fi->length - calc_size == 512 && !ForceNoHeader) || ForceHeader)
			{
				memmove (databuf, databuf + 512, calc_size);
				(*headers)++;
				fi->length -= 512;
			}
			(*TotalFileSize) += (int32)fi->length;
			break;
		}
	}
	unload_cab(basecab);
	return loadcabresult;
}
