
static ushort decode_c_lzs(void)
{
	if (getbits(1)) {
		return getbits(8);
	} else {
		matchpos = getbits(11);
		return getbits(4) + 0x100;
	}
}

static ushort decode_p_lzs(int loc)
{
	return (loc - matchpos - MAGIC0) & 0x7ff;
}

static void decode_start_lzs(void)
{
	init_getbits();
}

static ushort decode_c_lz5(void)
{
	int c;

	if (flagcnt == 0) {
		flagcnt = 8;
		larc_flag = getc(infile);
	}
	flagcnt--;
	c = getc(infile);
	if ((larc_flag & 1) == 0) {
		matchpos = c;
		c = getc(infile);
		matchpos += (c & 0xf0) << 4;
		c &= 0x0f;
		c += 0x100;
	}
	larc_flag >>= 1;
	return c;
}

static ushort decode_p_lz5(int loc)
{
	return (loc - matchpos - MAGIC5) & 0xfff;
}

static void decode_start_lz5(void)
{
	int i;

	flagcnt = 0;
	for (i = 0; i < 256; i++) memset(&text[i * 13 + 18], i, 13);
	for (i = 0; i < 256; i++) text[256 * 13 + 18 + i] = i;
	for (i = 0; i < 256; i++) text[256 * 13 + 256 + 18 + i] = 255 - i;
	memset(&text[256 * 13 + 512 + 18], 0, 128);
	memset(&text[256 * 13 + 512 + 128 + 18], ' ', 128 - 18);
}
