/***** decoding *****/

static void read_pt_len(short nn, short nbit, short i_special)
{
	short i, c, n;

	n = getbits((unsigned char)nbit);
	if (n == 0) {
		c = getbits((unsigned char)nbit);
		for (i = 0; i < nn; i++) pt_len[i] = 0;
		for (i = 0; i < 256; i++) pt_table[i] = c;
	} else {
		i = 0;
		while (i < n) {
			c = bitbuf >> (16 - 3);
			if (c == 7) {
				ushort mask = 1U << (16 - 4);
				while (mask & bitbuf) {  mask >>= 1;  c++;  }
			}
			fillbuf((unsigned char)((c < 7) ? 3 : c - 3));
			pt_len[i++] = (unsigned char)c;
			if (i == i_special) {
				c = getbits(2);
				while (--c >= 0) pt_len[i++] = 0;
			}
		}
		while (i < nn) pt_len[i++] = 0;
		make_table(nn, pt_len, 8, pt_table);
	}
}

static void read_c_len(void)
{
	short i, c, n;

	n = getbits(CBIT);
	if (n == 0) {
		c = getbits(CBIT);
		for (i = 0; i < NC; i++) c_len[i] = 0;
		for (i = 0; i < 4096; i++) c_table[i] = c;
	} else {
		i = 0;
		while (i < n) {
			c = pt_table[bitbuf >> (16 - 8)];
			if (c >= NT) {
				ushort mask = 1U << (16 - 9);
				do {
					if (bitbuf & mask) c = right[c];
					else               c = left [c];
					mask >>= 1;
				} while (c >= NT);
			}
			fillbuf(pt_len[c]);
			if (c <= 2) {
				if      (c == 0) c = 1;
				else if (c == 1) c = getbits(4) + 3;
				else             c = getbits(CBIT) + 20;
				while (--c >= 0) c_len[i++] = 0;
			} else c_len[i++] = c - 2;
		}
		while (i < NC) c_len[i++] = 0;
		make_table(NC, c_len, 12, c_table);
	}
}

unsigned short
decode_c_st1( /*void*/ )
{
	unsigned short  j, mask;

	if (blocksize == 0) {
		blocksize = getbits(16);
		read_pt_len(NT, TBIT, 3);
		read_c_len();
		read_pt_len((short)np, (short)pbit, -1);
	}
	blocksize--;
	j = c_table[bitbuf >> 4];
	if (j < NC)
		fillbuf(c_len[j]);
	else {
		fillbuf(12);
		mask = 1 << (16 - 1);
		do {
			if (bitbuf & mask)
				j = right[j];
			else
				j = left[j];
			mask >>= 1;
		} while (j >= NC);
		fillbuf((unsigned char)(c_len[j] - 12));
	}
	return j;
}

static ushort decode_p_st1(void)
{
	ushort j, mask;

	j = pt_table[bitbuf >> (16 - 8)];
	if (j < np)
		fillbuf(pt_len[j]);
	else {
		fillbuf(8);
		mask = 1U << (16 - 1);
		do {
			if (bitbuf & mask)
				j = right[j];
			else
				j = left [j];
			mask >>= 1;
		} while (j >= np);
		fillbuf((unsigned char)(pt_len[j] - 8));
	}
	if (j != 0)
		j = (1U << (j - 1)) + getbits((unsigned char)(j - 1));
	return j;
}

static void decode_start_st1(void)
{
	if (dicbit <= 13)  {
		np = 14;
		pbit = 4;
	} else {
		if (dicbit == 16) {
			np = 17; /* for -lh7- */
		} else {
			np = 16;
		}
		pbit = 5;
	}

	init_getbits();
	blocksize = 0;
}
