/*
		||		WJ@uPDOP{R

		Sliding Dictionary(8k) + static huffman

				Original Program	H.Yoshizaki
				Modified Program	cV	
				Arranged for LIB	Shinki.
*/

/*  wb_t@C̎荞  */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <time.h>
#include <ctype.h>
#include <sys/stat.h>
#include "lhaccess.h"
#include "decode2.h"		/*  vg^Cv錾  */
#include "decode1.h"		/*  ϐ錾  */

/*  CũC荞  */

#include	"header.c"
#include	"crcio.c"
#include	"dhuf.c"
#include	"shuf.c"
#include	"huf.c"
#include	"maketbl.c"
#include	"extract.c"
#include	"larc.c"


/*		for debug

void lzh_display_status( void )
{
	printf( "\nmax:%ld  now:%ld text:%x  ",last_root->now->filesize,read_count,text );
	printf( "loc:%d  pointer:%p  (text+loc):%x\n",loc,pointer,text+loc );
}
*/

void set_malloc( void *(*malloc_function)() , void (*free_function)() )
{
	MALLOC	= malloc_function;
	FREE	= free_function;
}

int decode_initilizing( ROOT *root )
{
	last_root = root;

	memcpy(methods[12], root->now->method, 5);
	for (method = 0; memcmp(root->now->method, methods[method], 5); method++);
	if (method == 12) {
		return (2);
	}

	dicbit = 13; /* method + 8; */
	infile = root->fp;
	origsize = root->now->filesize;
/*	compsize = root->now->coresize;
*/
	if( fseek( infile,root->now->pointer,SEEK_SET )!=0 )
		return (1);

	switch (method) {
	case 0:
	case 10:
		break;
	case 8:
		dicbit = 11;
		break;
	case 1:
	case 4:
	case 9:
		dicbit = 12;
		break;
	case 6:
	case 7:
		dicbit = (method - 6) + 15;
	}

	decode_set = decode_define[ method - 1];
	dicsiz = 1U << dicbit;
	memset(text, ' ', dicsiz);
	EOF_FLAG = 0;
	if( method!=0 && method !=10 )

#ifndef POWERC
		decode_set.decode_start();
#else
	{	voi_func = decode_set.decode_start;
		voi_func();
	}
#endif

	dicsiz1 = dicsiz - 1;
	pointer = NULL;	read_count = 0;		/*  ǉ   93/06/26  */
	offset = (method == 8) ? 0x100 - 2 : 0x100 - 3;
	count = 0;  loc = 0;
	flag = 0;
	return 0;
}

/*
		Adecode_initilizing Ŏw肵t@CA
		PoCg󂯎֐i݂Ȃj
						==EOF ..... t@C̏I or G[
						!=EOF ..... 󂯎f[^
*/
int lzh_fgetc( void )
{
top:;
	if( loc == 0 )
	{	if( EOF_FLAG )
			return (EOF);

		decode();
		pointer = text;
		goto top;				/*  Ôߍă`FbN  */
	}
	loc--;
	read_count++;
	return (*(pointer++));
}

/*
	ftell ݂ȂB

	߂l͍܂œǂݎoCg
*/
unsigned long lzh_ftell( void )
{
	return (read_count);
}

/*
	fread ݂ȂB@buffer`ɁAbyteoCgǂݍށB
	߂ĺAǂݏooCg
	iG[ , EOFóA߂l byte ƂŒmj
*/
unsigned long lzh_fread( void *buffer , unsigned long byte )
{								/*  long  unsigned longɕύX  93/07/22  */
	unsigned long	ret = 0;
	int		flag = 0;

	do
	{	if( loc == 0 )
		{	if( EOF_FLAG )
				break;
			decode();
			pointer = text;
			if( loc == 0 )
				continue;
		}

		if( byte < loc )
		{	memcpy(buffer, pointer ,(size_t)byte );
//			loc -= (unsigned short)byte;
			loc -= byte;
			pointer += byte;		/*  ǉ   93/06/26  */
			ret += byte;
			byte = 0;
			flag = 1;
		}
		else
		{	memcpy( buffer , pointer , (size_t)loc );
			buffer = (void *)((char *)buffer + loc);	/*  buffer += loc  */
			pointer += byte;		/*  ǉ   93/06/26  */
			byte -= loc;
			ret += loc;
			loc = 0;
		}
	} while( flag == 0 );

	read_count += ret;
	return (ret);
}


/*
	fseek݂ȂB			 ɈoO   1993.06.27
		߂luOȊOvŃV[NG[
*/
int lzh_fseek( unsigned long offset , int origin )
{
	unsigned long	top;		/*  decode obt@̐擪l  */

	switch( origin )
	{	case	SEEK_CUR:
			offset += read_count;
			break;
		case	SEEK_END:
			offset = last_root->now->filesize + offset;
			break;
		case	SEEK_SET:
		default:
			break;
	}

	if( last_root->now->filesize < offset )
		return (-1);

	top = (read_count & dicsiz);

	if( pointer == NULL )
		return (0);

	if( (top <= offset) && (offset<(top+dicsiz)) )
	{
		pointer = text + (offset % dicsiz);
		read_count = offset;
		loc = (short)(dicsiz - (offset % dicsiz));
		if( loc == 0 )
			loc = dicsiz;
	}
	else
	{	 if( read_count>offset )
			decode_initilizing( last_root );		/*  ŏ蒼  */
		while( read_count<offset )
			if( lzh_fgetc()==EOF )
				return (-1);
	}

	EOF_FLAG = 0;
	return (0);
}

/*
	islzh : w肷t@C ɂ܂񂾃t@Cǂ

	߂l       0.......  ȏɃt@C
				 1.......  Ƀt@C݂Ȃ
				 2.......  wt@C͏Ƀt@CłȂ
*/

int islzh( char *filename )
{
	ROOT	root;
	int		ret;
	if( (ret=open_root( filename , &root ))!=0 )
		;
	else if( get_all_header( &root )!=0 )
		ret = 2;
	else if( root.number==0 )
		ret = 2;
	if(ret != 1)
		close_root( &root );
	return (ret);
}
