/*
  Copyright (C) 2004 sanmaiwashi
*/

#ifndef _COMMON_H_
#define _COMMON_H_

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef signed char s8;
typedef short s16;
typedef long s32;

#ifndef START_EXTERN_C
#if defined(__cplusplus) || defined(c_plusplus)
#define EXTERN_C extern "C"
#define START_EXTERN_C extern "C" {
#define END_EXTERN_C }
#else
#define EXTERN_C extern
#define START_EXTERN_C
#define END_EXTERN_C
#endif
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#if defined(__i386__) || defined(__i486__) || defined(__i586__) || \
    defined(__WIN32__) || defined(__alpha__)

// little endian
#define READ_16(s) (*(u16 *) (s))
#define READ_32(s) (*(u32 *) (s))
#define WRITE_16(s, d) (*(u16 *) (s)) = (d)
#define WRITE_32(s, d) (*(u32 *) (s)) = (d)
#else

// big endian
#define READ_16(s) ( *(u8 *) (s) |\
					 (*((u8 *) (s) + 1) << 8))
#define READ_32(s) ( *(u8 *) (s) |\
					 (*((u8 *) (s) + 1) << 8) |	\
					 (*((u8 *) (s) + 2) << 16) |	\
					 (*((u8 *) (s) + 3) << 24))
#define WRITE_16(s, d) *(u8 *) (s) = (d), \
		*((u8 *) (s) + 1) = (d) >> 8
#define WRITE_32(s, d) *(u8 *) (s) = (u8) (d), \
		*((u8 *) (s) + 1) = (u8) ((d) >> 8),						\
		*((u8 *) (s) + 2) = (u8) ((d) >> 16),						\
		*((u8 *) (s) + 3) = (u8) ((d) >> 24)
#endif

#endif /* _COMMON_H_ */

