#ifndef _BMPFUTIL_H_
#define _BMPFUTIL_H_

#include "common.h"
#include <stdio.h>

//BITMAP header offset
#define BF_TYPE             0
#define BF_SIZE             2
#define BF_RESERVED1        6
#define BF_RESERVED2        8
#define BF_OFFBITS         10
#define BI_SIZE            14
#define BI_WIDTH           18
#define BI_HEIGHT          22
#define BI_PLANES          26
#define BI_BITCOUNT        28
#define BI_COMPRESSION     30
#define BI_SIZEIMAGE       34
#define BI_XPELSPERMETER   38
#define BI_YPELSPERMETER   42
#define BI_CLRUSED         46
#define BI_CLRIMPORTANT    50

#define BITMAP_FILE_HEADER_SIZE 14
#define BITMAP_INFO_SIZE        40
#define BITMAP_HEADER_SIZE      54
#define BITMAP_DATA_OFFSET      54

START_EXTERN_C
u8 ConvertBitmapImage24To8(u8 *dst, u8 *src);
u8 ConvertBitmapImage24To8IfWithin(u8 *dst, u8 *src);
u8 x2wBitmapImage(u8 *dst, u8 *src);
u8 x2hBitmapImage(u8 *dst, u8 *src);
u8 bmp_compress_dib_rle(u8 *dst, u8 *src);
u8 *bmp2pcx(u8 *pBitmapImage, u8 *pcxpalette, u32 *ImageDataSize,
void *(*memallocfunc)(u32 bytecount), void(*memfreefunc)(void *memptr));
u8 *bmp2gif(u8 *pBitmapImage, u32 *ImageDataSize, char *gifcomment,
void *(*memallocfunc)(u32 bytecount), void(*memfreefunc)(void *memptr));
u8 bmp2png(u8 *pBitmapImage, FILE *fp, char *png_comment_key_str, char *png_comment_text_str);
END_EXTERN_C

static inline u8 CheckBitmapHeader(u8 *pBitmapImage)
{
	/* Check bitmap file header. */
	if(!pBitmapImage ||
		READ_16(pBitmapImage + BF_TYPE) != 0x4D42 ||
		READ_16(pBitmapImage + BF_RESERVED1) != 0 ||
		READ_16(pBitmapImage + BF_RESERVED2) != 0 ||
		READ_32(pBitmapImage + BI_SIZE) != BITMAP_INFO_SIZE ||
		READ_16(pBitmapImage + BI_PLANES) != 1 ||
		READ_32(pBitmapImage + BI_COMPRESSION) != 0 ||
		READ_32(pBitmapImage + BI_XPELSPERMETER) != 0 ||
		READ_32(pBitmapImage + BI_YPELSPERMETER) != 0 ||
		!((READ_32(pBitmapImage + BF_OFFBITS) == BITMAP_HEADER_SIZE && READ_16(pBitmapImage + BI_BITCOUNT) == 24 &&
		READ_32(pBitmapImage + BI_CLRUSED) == 0 && READ_32(pBitmapImage + BI_CLRIMPORTANT) == 0) ||
		(READ_32(pBitmapImage + BF_OFFBITS) == (BITMAP_HEADER_SIZE + 1024) && READ_16(pBitmapImage + BI_BITCOUNT) == 8 &&
		READ_32(pBitmapImage + BI_CLRUSED) == 256 && READ_32(pBitmapImage + BI_CLRIMPORTANT) == 256)))
		return FALSE;
	return TRUE;
}

#endif

