#include "png.h"
#include "bmpfutil.h"
#include <stdlib.h>

//low 0 - 9 high
static int complevel = 9;

static int interlace = 0;
static int filters   = 0;
static int bpHYs = FALSE;
static png_text pngtxt;

u8 bmp2png(u8 *pBitmapImage,
		   FILE *fp,
		   char *png_comment_key_str,
		   char *png_comment_text_str)
{
	int bit_depth;
	int color_type;
	u32 ClrUsed, dibheight, dibPitch, diblinenum, i;
	u8 *pdibdata;
	png_color pngpal[256];
	png_structp ppng;
	png_infop pipng;
	png_bytepp pimgline;
	
	if(!CheckBitmapHeader(pBitmapImage) || !fp)
		return FALSE;
	
	ppng = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	
	if(!ppng)
		return FALSE;
	
	pipng = png_create_info_struct(ppng);
	
	if(!pipng) {
		png_destroy_write_struct(&ppng, NULL);
		return FALSE;
	}
	
	if(setjmp(ppng->jmpbuf)){
		png_destroy_write_struct(&ppng, &pipng);
		return FALSE;
	}
	
	png_init_io(ppng, fp);
	png_set_compression_level(ppng, complevel);
	
	if(filters != 0)
		png_set_filter(ppng, PNG_FILTER_TYPE_BASE, filters);
	
	if(READ_16(pBitmapImage + BI_BITCOUNT) == 24){
		bit_depth  = 8;
		color_type = PNG_COLOR_TYPE_RGB;
		png_set_compression_mem_level(ppng, MAX_MEM_LEVEL);
	}
	else {
		bit_depth  = (int)READ_16(pBitmapImage + BI_BITCOUNT);
		color_type = PNG_COLOR_TYPE_PALETTE;
		ClrUsed = READ_32(pBitmapImage + BI_CLRUSED);
		for(i = 0; i < ClrUsed; i++)
		{
			pngpal[i].blue =  *(pBitmapImage + BITMAP_DATA_OFFSET + i * 4 + 0);
			pngpal[i].green = *(pBitmapImage + BITMAP_DATA_OFFSET + i * 4 + 1);
			pngpal[i].red =   *(pBitmapImage + BITMAP_DATA_OFFSET + i * 4 + 2);
		}
		png_set_PLTE(ppng, pipng, pngpal, (int)ClrUsed);
	}
	png_set_IHDR(ppng, pipng, READ_32(pBitmapImage + BI_WIDTH), READ_32(pBitmapImage + BI_HEIGHT), bit_depth,
	              color_type, interlace ? PNG_INTERLACE_ADAM7 : PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT,
	              PNG_FILTER_TYPE_DEFAULT);

	if(bpHYs && READ_32(pBitmapImage + BI_XPELSPERMETER) && READ_32(pBitmapImage + BI_YPELSPERMETER))
	{
		png_set_pHYs(ppng, pipng, (png_int_32)READ_32(pBitmapImage + BI_XPELSPERMETER),
			(png_int_32)READ_32(pBitmapImage + BI_YPELSPERMETER),
			PNG_RESOLUTION_METER);
	}
	
	/* png comment. */
	pngtxt.compression = PNG_TEXT_COMPRESSION_NONE;
	pngtxt.key = png_comment_key_str;
	pngtxt.text = png_comment_text_str;
	png_set_text(ppng, pipng, &pngtxt, 1);
	
	png_write_info(ppng, pipng);
	if(READ_16(pBitmapImage + BI_BITCOUNT) == 24)
		png_set_bgr(ppng);
	
	dibheight = READ_32(pBitmapImage + BI_HEIGHT);
	pdibdata = pBitmapImage + READ_32(pBitmapImage + BF_OFFBITS);
	
	/* set ptr of DIB line. */
	pimgline = (png_bytepp)malloc((size_t)(sizeof(png_bytep) * dibheight));
	if(!pimgline) {
		png_destroy_write_struct(&ppng, &pipng);
		return FALSE;
	}
	
	dibPitch = READ_32(pBitmapImage + BI_SIZEIMAGE) / dibheight;
	
	for(diblinenum = 0; diblinenum < dibheight; diblinenum++)
	{
		pimgline[diblinenum] = (png_bytep)(pdibdata + (dibheight - diblinenum - 1) * dibPitch);
	}
	
	png_write_image(ppng, pimgline);
	png_write_end(ppng, pipng);
	png_destroy_write_struct(&ppng, &pipng);
	free(pimgline);
	return TRUE;
}

