#include <string.h>
#include "bmpfutil.h"

static void *(*MemAllocFunc)(u32 bytecount);
static void (*MemFreeFunc)(void *memptr);

static u32 realsize = 0;

static u8 *galloc(u8 *mptr, u32 cursize, u32 gsize)
{
	u8 *mmptr;
	
	if(!mptr)
		return NULL;
	
	if((cursize + gsize) <= realsize)
		return mptr;
	
	if(gsize <= 0x1000) {
		mmptr = (u8 *)MemAllocFunc(realsize + 0x1000);
		realsize += 0x1000;
	}
	else {
		mmptr = (u8 *)MemAllocFunc(realsize + gsize);
		realsize += gsize;
	}
	
	if(!mmptr) {
		MemFreeFunc(mptr);
		return NULL;
	}
	
	memcpy(mmptr, mptr, cursize);
	MemFreeFunc(mptr);
	return mmptr;
}

static void realsizeinit(u32 initsize)
{
	realsize = initsize;
}

/* lookup table for scaling 6 bit colors up to 8 bits */
static u8 RgbScale6[64] =
{
	0,   4,   8,   12,  16,  20,  24,  28,
	32,  36,  40,  44,  48,  52,  56,  60,
	64,  68,  72,  76,  80,  85,  89,  93,
	97,  101, 105, 109, 113, 117, 121, 125,
	129, 133, 137, 141, 145, 149, 153, 157,
	161, 165, 170, 174, 178, 182, 186, 190,
	194, 198, 202, 206, 210, 214, 218, 222,
	226, 230, 234, 238, 242, 246, 250, 255
};

u8 *bmp2pcx(u8 *pBitmapImage, u8 *pcxpalette, u32 *ImageDataSize,
	void *(*memallocfunc)(u32 bytecount), void(*memfreefunc)(void *memptr))
{
	int i , x, y, runcount;
	u16 pcxWidth, pcxHeight;
	u32 iputc;
	u8 runchar, ch, putc, planes;
	u8 *pPCXImage;
	
	/* Check bitmap file header. */
	if(!pBitmapImage || !pcxpalette || !ImageDataSize || !memallocfunc || !memfreefunc || !CheckBitmapHeader(pBitmapImage)) {
		return NULL;
	}
	
	MemAllocFunc = memallocfunc;
	MemFreeFunc = memfreefunc;
	
	planes = (READ_16(pBitmapImage + BI_BITCOUNT) == 24) ? 3 : 1;
	pPCXImage = (u8 *)MemAllocFunc(16 + 48 + 10 + 54);
	
	if(!pPCXImage)
		return NULL;
	
	pcxWidth = (u16)READ_32(pBitmapImage + BI_WIDTH);
	pcxHeight = (u16)READ_32(pBitmapImage + BI_HEIGHT);
	
	/* PCX info header (16 byte) */
	*(pPCXImage + 0) = 10;/* pcxiManufacturer */
	*(pPCXImage + 1) = 5;/* pcxiVersion */
	*(pPCXImage + 2) = 1;/* pcxiRunLengthEncoding */
	*(pPCXImage + 3) = 8;/* pcxi8BitsPerPixel */
	WRITE_16(pPCXImage + 4, 0);/* pcxiXmin */
	WRITE_16(pPCXImage + 6, 0);/* pcxiYmin */
	WRITE_16(pPCXImage + 8, pcxWidth - 1);/* pcxiXmax */
	WRITE_16(pPCXImage + 10, pcxHeight - 1);/* pcxiYmax */
	WRITE_16(pPCXImage + 12, 320);/* pcxiHDpi */
	WRITE_16(pPCXImage + 14, 200);/* pcxiVDpi */

	for (i = 0; i < 16; i++) {
		*(pPCXImage + 16 + i * 3 + 0) = RgbScale6[*(pcxpalette + i * 4)];
		*(pPCXImage + 16 + i * 3 + 1) = RgbScale6[*(pcxpalette + i * 4 + 1)];
		*(pPCXImage + 16 + i * 3 + 2) = RgbScale6[*(pcxpalette + i * 4 + 2)];
	}

	/* PCX info header (10 byte) */
	*(pPCXImage + 64) = 0;/* pcxiReserved */
	*(pPCXImage + 65) = planes;/* planes */
	WRITE_16(pPCXImage + 66, pcxWidth);/* pcxiWidth */
	WRITE_16(pPCXImage + 68, 1);/* pcxiColorPalette */
	WRITE_16(pPCXImage + 70, pcxWidth);/* pcxiHscreen */
	WRITE_16(pPCXImage + 72, pcxHeight);/* pcxiVscreen */
	memset(pPCXImage + 74, 0, 54);

	iputc = 128;
	realsizeinit(128);

	for (y = 0; y < pcxHeight; y++) {
		runcount = 0;
		runchar = 0;
		for (x = 0; x < (pcxWidth * planes); x++) {
			if (READ_16(pBitmapImage + BI_BITCOUNT) == 8)
				ch = *(pBitmapImage + BITMAP_DATA_OFFSET + 1024 + (pcxHeight - 1 - y) * pcxWidth + x);
			else {
				if (x < pcxWidth)
					ch = *(pBitmapImage + BITMAP_DATA_OFFSET + (pcxHeight - 1 - y) * pcxWidth * 3 + x * 3 + 2);
				else if (x < (pcxWidth * 2))
					ch = *(pBitmapImage + BITMAP_DATA_OFFSET + (pcxHeight - 1 - y) * pcxWidth * 3 + (x - pcxWidth) * 3 + 1);
				else
					ch = *(pBitmapImage + BITMAP_DATA_OFFSET + (pcxHeight - 1 - y) * pcxWidth * 3 + (x - pcxWidth * 2) * 3);
			}
			if (runcount == 0) {
				runcount = 1;
				runchar = ch;
			}
			else {
				if ((ch != runchar) || (runcount >= 0x3f)) {
					if ((runcount > 1) || ((runchar & 0xC0) == 0xC0)) {
						putc = 0xC0 | runcount;
						if(!(pPCXImage = galloc(pPCXImage, iputc, 1)))
							return NULL;
						*(pPCXImage + iputc) = putc;
						++iputc;
					}
					putc = runchar;
					if(!(pPCXImage = galloc(pPCXImage, iputc, 1)))
						return NULL;
					*(pPCXImage + iputc) = putc;
					++iputc;
					runcount = 1;
					runchar = ch;
				}
				else
					runcount++;
			}
		}
		if ((runcount > 1) || ((runchar & 0xC0) == 0xC0)) {
			putc = 0xC0 | runcount;
			if(!(pPCXImage = galloc(pPCXImage, iputc, 1)))
				return NULL;
			*(pPCXImage + iputc) = putc;
			++iputc;
		}
		putc = runchar;
		if(!(pPCXImage = galloc(pPCXImage, iputc, 1)))
			return NULL;
		*(pPCXImage + iputc) = putc;
		++iputc;
	}

	if (READ_16(pBitmapImage + BI_BITCOUNT) == 8) {
		putc = 12;
		if(!(pPCXImage = galloc(pPCXImage, iputc, 1)))
			return NULL;
		*(pPCXImage + iputc) = putc;
		++iputc;
		if(!(pPCXImage = galloc(pPCXImage, iputc, 768)))
			return NULL;
		for (i = 0; i < 256; i++) {
			*(pPCXImage + iputc + i * 3 + 0) = RgbScale6[*(pcxpalette + i * 4 + 0)];
			*(pPCXImage + iputc + i * 3 + 1) = RgbScale6[*(pcxpalette + i * 4 + 1)];
			*(pPCXImage + iputc + i * 3 + 2) = RgbScale6[*(pcxpalette + i * 4 + 2)];
		}
		iputc += 768;
	}
	*ImageDataSize = iputc;
	return pPCXImage;
}

