/*
  2xSaI is Copyright (c) 1999-2001 by Derek Liauw Kie Fa.

  rewrite
  Copyright (C) 2004 sanmaiwashi
*/

#include "common.h"
#include <stdlib.h>
#include <string.h>

static u32 colorMask = 0xF7DEF7DE;
static u32 lowPixelMask = 0x08210821;
static u32 qcolorMask = 0xE79CE79C;
static u32 qlowpixelMask = 0x18631863;
static u32 redblueMask = 0xF81F;
static u32 greenMask = 0x7E0;

int Init_2xSaI (u32 BitFormat)
{
	if (BitFormat == 565) {
		colorMask = 0xF7DEF7DE;
		lowPixelMask = 0x08210821;
		qcolorMask = 0xE79CE79C;
		qlowpixelMask = 0x18631863;
		redblueMask = 0xF81F;
		greenMask = 0x7E0;
    }
    else if (BitFormat == 555) {
		colorMask = 0x7BDE7BDE;
		lowPixelMask = 0x04210421;
		qcolorMask = 0x739C739C;
		qlowpixelMask = 0x0C630C63;
		redblueMask = 0x7C1F;
		greenMask = 0x3E0;
    }
    else {
		return 0;
	}
	return 1;
}

static inline u16 Get_xy(u16 *srcPtr, u16 *deltaPtr, int i, u8 *skip)
{
	u16 v = READ_16(srcPtr + i);
	if(*skip == 1 && v != READ_16(deltaPtr + i))
		*skip = 0;
	return v;
}

static inline u8 GetPixels(int x, int y, int width, int height, u16 *srcPtr, u32 srcPitch,
							 u16 *deltaPtr, u32 *Pixels)
{
	u8 skip = 1;
	int i = srcPitch * y + x - srcPitch;

#define GET_XY(i)\
	Get_xy(srcPtr, deltaPtr, (i), &skip)

	if(y == 0) {
		if(x == 0) {
			Pixels[0] =  0;               Pixels[1] =  0;           Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  0;               Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  0;               Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = GET_XY(i + 2);
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = GET_XY(i); Pixels[14] = GET_XY(i + 1); Pixels[15] = GET_XY(i + 2);
		}
		else if(x == (width - 2)) {
			Pixels[0] =  0;               Pixels[1] =  0;           Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = GET_XY(i - 1); Pixels[13] = GET_XY(i); Pixels[14] = GET_XY(i + 1); Pixels[15] = 0;
		}
		else if(x == (width - 1)) {
			Pixels[0] =  0;               Pixels[1] =  0;           Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  0;               Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = GET_XY(i - 1); Pixels[13] = GET_XY(i); Pixels[14] = 0;               Pixels[15] = 0;
		}
		else {
			Pixels[0] =  0;               Pixels[1] =  0;           Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = GET_XY(i + 2);
			i += srcPitch;
			Pixels[12] = GET_XY(i - 1); Pixels[13] = GET_XY(i); Pixels[14] = GET_XY(i + 1); Pixels[15] = GET_XY(i + 2);
		}
	}
	else if(y == (height - 2)) {
		if(x == 0) {
			Pixels[0] =  0;               Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[4] =  0;               Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  0;               Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = GET_XY(i + 2);
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
		else if(x == (width - 2)) {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
		else if(x == (width - 1)) {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  0;               Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
		else {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = GET_XY(i + 2);
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
	}
	else if(y == (height - 1)) {
		if(x == 0) {
			Pixels[0] =  0;        Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[4] =  0;        Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  0;        Pixels[9] =  0;           Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = 0;        Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
		else if(x == (width - 2)) {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  0;               Pixels[9] =  0;           Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
		else if(x == (width - 1)) {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  0;               Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  0;               Pixels[9] =  0;           Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
		else {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  0;               Pixels[9] =  0;           Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = 0;           Pixels[14] = 0;               Pixels[15] = 0;
		}
	}
	else {
		if(x == 0) {
			Pixels[0] =  0;               Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[4] =  0;               Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  0;               Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = GET_XY(i + 2);
			i += srcPitch;
			Pixels[12] = 0;               Pixels[13] = GET_XY(i); Pixels[14] = GET_XY(i + 1); Pixels[15] = GET_XY(i + 2);
		}
		else if(x == (width - 2)) {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = GET_XY(i - 1); Pixels[13] = GET_XY(i); Pixels[14] = GET_XY(i + 1); Pixels[15] = 0;
		}
		else if(x == (width - 1)) {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  0;               Pixels[3] =  0;
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  0;               Pixels[7] =  0;
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = 0;               Pixels[11] = 0;
			i += srcPitch;
			Pixels[12] = GET_XY(i - 1); Pixels[13] = GET_XY(i); Pixels[14] = 0;               Pixels[15] = 0;
		}
		else {
			Pixels[0] =  GET_XY(i - 1);  Pixels[1] =  GET_XY(i);  Pixels[2] =  GET_XY(i + 1);  Pixels[3] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[4] =  GET_XY(i - 1);  Pixels[5] =  GET_XY(i);  Pixels[6] =  GET_XY(i + 1);  Pixels[7] =  GET_XY(i + 2);
			i += srcPitch;
			Pixels[8] =  GET_XY(i - 1);  Pixels[9] =  GET_XY(i);  Pixels[10] = GET_XY(i + 1);  Pixels[11] = GET_XY(i + 2);
			i += srcPitch;
			Pixels[12] = GET_XY(i - 1); Pixels[13] = GET_XY(i); Pixels[14] = GET_XY(i + 1); Pixels[15] = GET_XY(i + 2);
		}
	}
	return skip;
}

static inline int GetResult1 (u32 A, u32 B, u32 C, u32 D,
			      u32 /* E */)
{
	int x = 0;
	int y = 0;
	int r = 0;

	if (A == C)
		x += 1;
	else if (B == C)
		y += 1;

	if (A == D)
		x += 1;
	else if (B == D)
		y += 1;

	if (x <= 1)
		r += 1;

	if (y <= 1)
		r -= 1;

	return r;
}

static inline int GetResult2 (u32 A, u32 B, u32 C, u32 D,
			      u32 /* E */)
{
	int x = 0;
	int y = 0;
	int r = 0;

	if (A == C)
		x += 1;
	else if (B == C)
		y += 1;

	if (A == D)
		x += 1;
	else if (B == D)
		y += 1;

	if (x <= 1)
		r -= 1;

	if (y <= 1)
		r += 1;

	return r;
}

static inline int GetResult (u32 A, u32 B, u32 C, u32 D)
{
	int x = 0;
	int y = 0;
	int r = 0;

	if (A == C)
		x += 1;
	else if (B == C)
		y += 1;

	if (A == D)
		x += 1;
	else if (B == D)
		y += 1;

	if (x <= 1)
		r += 1;

	if (y <= 1)
		r -= 1;

	return r;
}

static inline u32 INTERPOLATE (u32 A, u32 B)
{
	if (A != B) {
		return (((A & colorMask) >> 1) + ((B & colorMask) >> 1) +
				(A & B & lowPixelMask));
	}
	else
		return A;
}

static inline u32 Q_INTERPOLATE (u32 A, u32 B, u32 C, u32 D)
{
	register u32 x = ((A & qcolorMask) >> 2) +
		((B & qcolorMask) >> 2) +
		((C & qcolorMask) >> 2) + ((D & qcolorMask) >> 2);
	register u32 y = (A & qlowpixelMask) +
		(B & qlowpixelMask) + (C & qlowpixelMask) + (D & qlowpixelMask);

	y = (y >> 2) & qlowpixelMask;
	return x + y;
}

static u32 Bilinear (u32 A, u32 B, u32 x)
{
	unsigned long areaA, areaB;
	unsigned long result;

	if (A == B)
		return A;

	areaB = (x >> 11) & 0x1f;	// reduce 16 bit fraction to 5 bits
	areaA = 0x20 - areaB;

	A = (A & redblueMask) | ((A & greenMask) << 16);
	B = (B & redblueMask) | ((B & greenMask) << 16);

	result = ((areaA * A) + (areaB * B)) >> 5;

	return (result & redblueMask) | ((result >> 16) & greenMask);
}

static u32 Bilinear4 (u32 A, u32 B, u32 C, u32 D, u32 x,
			 u32 y)
{
	unsigned long areaA, areaB, areaC, areaD;
	unsigned long result, xy;

	x = (x >> 11) & 0x1f;
	y = (y >> 11) & 0x1f;
	xy = (x * y) >> 5;

	A = (A & redblueMask) | ((A & greenMask) << 16);
	B = (B & redblueMask) | ((B & greenMask) << 16);
	C = (C & redblueMask) | ((C & greenMask) << 16);
	D = (D & redblueMask) | ((D & greenMask) << 16);

	areaA = 0x20 + xy - x - y;
	areaB = x - xy;
	areaC = y - xy;
	areaD = xy;

	result = ((areaA * A) + (areaB * B) + (areaC * C) + (areaD * D)) >> 5;

	return (result & redblueMask) | ((result >> 16) & greenMask);
}

#define BLUE_MASK565 0x001F001F
#define RED_MASK565 0xF800F800
#define GREEN_MASK565 0x07E007E0

#define BLUE_MASK555 0x001F001F
#define RED_MASK555 0x7C007C00
#define GREEN_MASK555 0x03E003E0


static inline void CopyDelta(u8 *srcPtr, u32 srcPitch,
							 u8 *deltaPtr, u32 deltaPitch,
							 int width, int height)
{
	width *= sizeof(u16);
	for(int h = 0; h < height; h++, deltaPtr += deltaPitch, srcPtr += srcPitch)
		memcpy(deltaPtr, srcPtr, (size_t)width);
}

void Super2xSaI (u8 *srcPtr, u32 srcPitch,
				 u8 *deltaPtr, u8 *dstPtr, u32 dstPitch,
				 int width, int height)
{
	u32 srcPitch2 = srcPitch >> 1;

    for (int y = 0; y < height; y++) {
		u8 *dP = (u8 *) dstPtr;

	    for (int x = 0; x < width; x++, dP += sizeof (u32)) {
			u32 Pixels[16];
			u32 product1a, product1b, product2a, product2b;

			if(GetPixels(x, y, width, height, (u16 *)srcPtr, srcPitch2, (u16 *)deltaPtr, Pixels))
				continue;

			if (Pixels[9] == Pixels[6] && Pixels[5] != Pixels[10]) {
				product2b = product1b = Pixels[9];
			}
			else if (Pixels[5] == Pixels[10] && Pixels[9] != Pixels[6]) {
				product2b = product1b = Pixels[5];
			}
			else if (Pixels[5] == Pixels[10] && Pixels[9] == Pixels[6]) {
				register int r = 0;

				r += GetResult (Pixels[6], Pixels[5], Pixels[8], Pixels[13]);
				r += GetResult (Pixels[6], Pixels[5], Pixels[4], Pixels[1]);
				r += GetResult (Pixels[6], Pixels[5], Pixels[14], Pixels[11]);
				r += GetResult (Pixels[6], Pixels[5], Pixels[2], Pixels[7]);

				if (r > 0)
					product2b = product1b = Pixels[6];
				else if (r < 0)
					product2b = product1b = Pixels[5];
				else {
					product2b = product1b = INTERPOLATE (Pixels[5], Pixels[6]);
				}
			}
			else {
				if (Pixels[6] == Pixels[10] && Pixels[10] == Pixels[13]
					&& Pixels[9] != Pixels[14] && Pixels[10] != Pixels[12])
					product2b =
						Q_INTERPOLATE (Pixels[10], Pixels[10], Pixels[10], Pixels[9]);
				else if (Pixels[5] == Pixels[9] && Pixels[9] == Pixels[14]
						 && Pixels[13] != Pixels[10] && Pixels[9] != Pixels[15])
					product2b =
						Q_INTERPOLATE (Pixels[9], Pixels[9], Pixels[9], Pixels[10]);
				else
					product2b = INTERPOLATE (Pixels[9], Pixels[10]);

				if (Pixels[6] == Pixels[10] && Pixels[6] == Pixels[1]
					&& Pixels[5] != Pixels[2] && Pixels[6] != Pixels[0])
					product1b =
						Q_INTERPOLATE (Pixels[6], Pixels[6], Pixels[6], Pixels[5]);
				else if (Pixels[5] == Pixels[9] && Pixels[5] == Pixels[2]
						 && Pixels[1] != Pixels[6] && Pixels[5] != Pixels[3])
					product1b =
						Q_INTERPOLATE (Pixels[6], Pixels[5], Pixels[5], Pixels[5]);
				else
					product1b = INTERPOLATE (Pixels[5], Pixels[6]);
			}

			if (Pixels[5] == Pixels[10] && Pixels[9] != Pixels[6] && Pixels[4] == Pixels[5]
				&& Pixels[5] != Pixels[14])
				product2a = INTERPOLATE (Pixels[9], Pixels[5]);
			else if (Pixels[5] == Pixels[8] && Pixels[6] == Pixels[5]
					 && Pixels[4] != Pixels[9] && Pixels[5] != Pixels[12])
				product2a = INTERPOLATE (Pixels[9], Pixels[5]);
			else
				product2a = Pixels[9];

			if (Pixels[9] == Pixels[6] && Pixels[5] != Pixels[10] && Pixels[8] == Pixels[9]
				&& Pixels[9] != Pixels[2])
				product1a = INTERPOLATE (Pixels[9], Pixels[5]);
			else if (Pixels[4] == Pixels[9] && Pixels[10] == Pixels[9]
					 && Pixels[8] != Pixels[5] && Pixels[9] != Pixels[0])
				product1a = INTERPOLATE (Pixels[9], Pixels[5]);
			else
				product1a = Pixels[5];

			product1a = product1a | (product1b << 16);
			product2a = product2a | (product2b << 16);

			WRITE_32(dP, product1a);
			WRITE_32(dP + dstPitch, product2a);
		}// end of for ( x == width etc..)
	    dstPtr   += dstPitch * 2;
	}// end of for ( y == height etc..)
	CopyDelta(srcPtr, srcPitch, deltaPtr, srcPitch, width, height);
}

void SuperEagle (u8 *srcPtr, u32 srcPitch, u8 *deltaPtr, 
		 u8 *dstPtr, u32 dstPitch, int width, int height)
{
	u32 srcPitch2 = srcPitch >> 1;

    for (int y = 0; y < height; y++) {
		u8 *dP = (u8 *) dstPtr;

	    for (int x = 0; x < width; x++, dP += sizeof (u32)) {
			u32 Pixels[16];
			u32 product1a, product1b, product2a, product2b;

			if(GetPixels(x, y, width, height, (u16 *)srcPtr, srcPitch2, (u16 *)deltaPtr, Pixels))
				continue;

			if (Pixels[9] == Pixels[6] && Pixels[5] != Pixels[10]) {
				product1b = product2a = Pixels[9];

				if ((Pixels[8] == Pixels[9]) || (Pixels[6] == Pixels[2])) {
					product1a = INTERPOLATE (Pixels[9], Pixels[5]);
					product1a = INTERPOLATE (Pixels[9], product1a);
				}
				else {
					product1a = INTERPOLATE (Pixels[5], Pixels[6]);
				}

				if ((Pixels[6] == Pixels[7]) || (Pixels[9] == Pixels[13])) {
					product2b = INTERPOLATE (Pixels[9], Pixels[10]);
					product2b = INTERPOLATE (Pixels[9], product2b);
				}
				else {
					product2b = INTERPOLATE (Pixels[9], Pixels[10]);
				}
			}
			else if (Pixels[5] == Pixels[10] && Pixels[9] != Pixels[6]) {
				product2b = product1a = Pixels[5];

				if ((Pixels[1] == Pixels[5]) || (Pixels[10] == Pixels[11])) {
					product1b = INTERPOLATE (Pixels[5], Pixels[6]);
					product1b = INTERPOLATE (Pixels[5], product1b);
				}
				else {
					product1b = INTERPOLATE (Pixels[5], Pixels[6]);
				}

				if ((Pixels[10] == Pixels[14]) || (Pixels[4] == Pixels[5])) {
					product2a = INTERPOLATE (Pixels[5], Pixels[9]);
					product2a = INTERPOLATE (Pixels[5], product2a);
				}
				else {
					product2a = INTERPOLATE (Pixels[9], Pixels[10]);
				}
			}
			else if (Pixels[5] == Pixels[10] && Pixels[9] == Pixels[6]) {
				register int r = 0;

				r += GetResult (Pixels[6], Pixels[5], Pixels[8], Pixels[13]);
				r += GetResult (Pixels[6], Pixels[5], Pixels[4], Pixels[1]);
				r += GetResult (Pixels[6], Pixels[5], Pixels[14], Pixels[11]);
				r += GetResult (Pixels[6], Pixels[5], Pixels[2], Pixels[7]);

				if (r > 0) {
					product1b = product2a = Pixels[9];
					product1a = product2b = INTERPOLATE (Pixels[5], Pixels[6]);
				}
				else if (r < 0) {
					product2b = product1a = Pixels[5];
					product1b = product2a = INTERPOLATE (Pixels[5], Pixels[6]);
				}
				else {
					product2b = product1a = Pixels[5];
					product1b = product2a = Pixels[9];
				}
			}
			else {
				product2b = product1a = INTERPOLATE (Pixels[9], Pixels[6]);
				product2b =	Q_INTERPOLATE (Pixels[10], Pixels[10], Pixels[10], product2b);
				product1a =	Q_INTERPOLATE (Pixels[5], Pixels[5], Pixels[5], product1a);
				product2a = product1b = INTERPOLATE (Pixels[5], Pixels[10]);
				product2a =	Q_INTERPOLATE (Pixels[9], Pixels[9], Pixels[9], product2a);
				product1b =	Q_INTERPOLATE (Pixels[6], Pixels[6], Pixels[6], product1b);
			}
			product1a = product1a | (product1b << 16);
			product2a = product2a | (product2b << 16);

			WRITE_32(dP, product1a);
			WRITE_32(dP + dstPitch, product2a);
		}// end of for ( x == width etc..)
	    dstPtr   += dstPitch * 2;
	}// end of for ( y == height etc..)
	CopyDelta(srcPtr, srcPitch, deltaPtr, srcPitch, width, height);
}

void _2xSaI (u8 *srcPtr, u32 srcPitch, u8 *deltaPtr,
	     u8 *dstPtr, u32 dstPitch, int width, int height)
{
	u32 srcPitch2 = srcPitch >> 1;

    for (int y = 0; y < height; y++) {
		u8 *dP = (u8 *) dstPtr;

	    for (int x = 0; x < width; x++, dP += sizeof (u32)) {
			u32 Pixels[16];
			u32 product1a/*, product1b*/, product2a, product2b;

			if(GetPixels(x, y, width, height, (u16 *)srcPtr, srcPitch2, (u16 *)deltaPtr, Pixels))
				continue;

			if ((Pixels[5] == Pixels[10]) && (Pixels[6] != Pixels[9])) {
				if (((Pixels[5] == Pixels[1]) && (Pixels[6] == Pixels[11])) ||
					((Pixels[5] == Pixels[9]) && (Pixels[5] == Pixels[2])
					 && (Pixels[6] != Pixels[1]) && (Pixels[6] == Pixels[3]))) {
					product1a = Pixels[5];
				}
				else {
					product1a = INTERPOLATE (Pixels[5], Pixels[6]);
				}

				if (((Pixels[5] == Pixels[4]) && (Pixels[9] == Pixels[14])) ||
					((Pixels[5] == Pixels[6]) && (Pixels[5] == Pixels[8])
					 && (Pixels[4] != Pixels[9]) && (Pixels[9] == Pixels[12]))) {
					product2a = Pixels[5];
				}
				else {
					product2a = INTERPOLATE (Pixels[5], Pixels[9]);
				}
				product2b = Pixels[5];
			}
			else if ((Pixels[6] == Pixels[9]) && (Pixels[5] != Pixels[10])) {
				if (((Pixels[6] == Pixels[2]) && (Pixels[5] == Pixels[8])) ||
					((Pixels[6] == Pixels[1]) && (Pixels[6] == Pixels[10])
					 && (Pixels[5] != Pixels[2]) && (Pixels[5] == Pixels[0]))) {
					product1a = Pixels[6];
				}
				else {
					product1a = INTERPOLATE (Pixels[5], Pixels[6]);
				}

				if (((Pixels[9] == Pixels[8]) && (Pixels[5] == Pixels[2])) ||
					((Pixels[9] == Pixels[4]) && (Pixels[9] == Pixels[10])
					 && (Pixels[5] != Pixels[8]) && (Pixels[5] == Pixels[0]))) {
					product2a = Pixels[9];
				}
				else {
					product2a = INTERPOLATE (Pixels[5], Pixels[9]);
				}
				product2b = Pixels[6];
			}
			else if ((Pixels[5] == Pixels[10]) && (Pixels[6] == Pixels[9])) {
				if (Pixels[5] == Pixels[6]) {
					product1a = Pixels[5];
					product2a = Pixels[5];
					product2b = Pixels[5];
				}
				else {
					register int r = 0;

					product2a = INTERPOLATE (Pixels[5], Pixels[9]);
					product1a = INTERPOLATE (Pixels[5], Pixels[6]);

					r += GetResult1 (Pixels[5], Pixels[6], Pixels[4], Pixels[1], Pixels[0]);
					r += GetResult2 (Pixels[6], Pixels[5], Pixels[7], Pixels[2], Pixels[3]);
					r += GetResult2 (Pixels[6], Pixels[5], Pixels[8], Pixels[13], Pixels[12]);
					r += GetResult1 (Pixels[5], Pixels[6], Pixels[11], Pixels[14], Pixels[15]);

					if (r > 0)
						product2b = Pixels[5];
					else if (r < 0)
						product2b = Pixels[6];
					else {
						product2b =	Q_INTERPOLATE (Pixels[5], Pixels[6], Pixels[9], Pixels[10]);
					}
				}
			}
			else {
				product2b = Q_INTERPOLATE (Pixels[5], Pixels[6], Pixels[9], Pixels[10]);

				if ((Pixels[5] == Pixels[9]) && (Pixels[5] == Pixels[2])
					&& (Pixels[6] != Pixels[1]) && (Pixels[6] == Pixels[3])) {
					product1a = Pixels[5];
				}
				else if ((Pixels[6] == Pixels[1]) && (Pixels[6] == Pixels[10])
						 && (Pixels[5] != Pixels[2]) && (Pixels[5] == Pixels[0])) {
					product1a = Pixels[6];
				}
				else {
					product1a = INTERPOLATE (Pixels[5], Pixels[6]);
				}

				if ((Pixels[5] == Pixels[6]) && (Pixels[5] == Pixels[8])
					&& (Pixels[4] != Pixels[9]) && (Pixels[9] == Pixels[12])) {
					product2a = Pixels[5];
				}
				else if ((Pixels[9] == Pixels[4]) && (Pixels[9] == Pixels[10])
						 && (Pixels[5] != Pixels[8]) && (Pixels[5] == Pixels[0])) {
					product2a = Pixels[9];
				}
				else {
					product2a = INTERPOLATE (Pixels[5], Pixels[9]);
				}
			}
			product1a = Pixels[5] | (product1a << 16);
			product2a = product2a | (product2b << 16);
			WRITE_32(dP, product1a);
			WRITE_32(dP + dstPitch, product2a);
	    }			// end of for ( finish= width etc..)
	    dstPtr += dstPitch * 2;
	}			// endof: while (h--)
	CopyDelta(srcPtr, srcPitch, deltaPtr, srcPitch, width, height);
}

void Scale_2xSaI (u8 *srcPtr, u32 srcPitch, u8 *deltaPtr,
		  u8 *dstPtr, u32 dstPitch, 
		  u32 dstWidth, u32 dstHeight, int width, int height)
{
	u32 w;
	u32 h;
	u32 dw;
	u32 dh;
	u32 hfinish;
	u32 wfinish;
	u32 srcPitch2 = srcPitch >> 1;

	wfinish = (width - 1) << 16;	// convert to fixed point
	dw = wfinish / (dstWidth - 1);
	hfinish = (height - 1) << 16;	// convert to fixed point
	dh = hfinish / (dstHeight - 1);

    for (h = 0; h < hfinish; h += dh) {
		u32 y1, y2;
		u8 *dP = dstPtr;

		y1 = h & 0xffff;	// fraction part of fixed point
		y2 = 0x10000 - y1;

		w = 0;

		for (; w < wfinish;) {
			u32 Pixels[16];
			u32 x1, x2, a1, f1, f2;
			u32 position, product1;

			position = w >> 16;

			GetPixels(position, h >> 16, width, height, (u16 *)srcPtr, srcPitch2, (u16 *)deltaPtr, Pixels);

			x1 = w & 0xffff;	// fraction part of fixed point
			x2 = 0x10000 - x1;

			/*0*/ 
			if (Pixels[5] == Pixels[6] && Pixels[9] == Pixels[10] && Pixels[5] == Pixels[9])
				product1 = Pixels[5];
			/*1*/ 
			else if (Pixels[5] == Pixels[10] && Pixels[6] != Pixels[9]) {
				f1 = (x1 >> 1) + (0x10000 >> 2);
				f2 = (y1 >> 1) + (0x10000 >> 2);
				if (y1 <= f1 && Pixels[5] == Pixels[11] && Pixels[5] != Pixels[1]) {// close to B
					a1 = f1 - y1;
					product1 = Bilinear (Pixels[5], Pixels[6], a1);
				}
				else if (y1 >= f1 && Pixels[5] == Pixels[4] && Pixels[5] != Pixels[14]) {// close to C
					a1 = y1 - f1;
					product1 = Bilinear (Pixels[5], Pixels[9], a1);
				}
				else if (x1 >= f2 && Pixels[5] == Pixels[1] && Pixels[5] != Pixels[11]) {// close to B
					a1 = x1 - f2;
					product1 = Bilinear (Pixels[5], Pixels[6], a1);
				}
				else if (x1 <= f2 && Pixels[5] == Pixels[14] && Pixels[5] != Pixels[4]) {// close to C
					a1 = f2 - x1;
					product1 = Bilinear (Pixels[5], Pixels[9], a1);
				}
				else if (y1 >= x1) {// close to C
					a1 = y1 - x1;
					product1 = Bilinear (Pixels[5], Pixels[9], a1);
				}
				else if (y1 <= x1) {// close to B
					a1 = x1 - y1;
					product1 = Bilinear (Pixels[5], Pixels[6], a1);
				}
			}
			/*2*/ 
			else if (Pixels[6] == Pixels[9] && Pixels[5] != Pixels[10]) {
				f1 = (x1 >> 1) + (0x10000 >> 2);
				f2 = (y1 >> 1) + (0x10000 >> 2);
				if (y2 >= f1 && Pixels[6] == Pixels[8] && Pixels[6] != Pixels[2]) {// close to A
					a1 = y2 - f1;
					product1 = Bilinear (Pixels[6], Pixels[5], a1);
				}
				else if (y2 <= f1 && Pixels[6] == Pixels[7] && Pixels[6] != Pixels[13]) {// close to D
					a1 = f1 - y2;
					product1 = Bilinear (Pixels[6], Pixels[10], a1);
				}
				else if (x2 >= f2 && Pixels[6] == Pixels[2] && Pixels[6] != Pixels[8]) {// close to A
					a1 = x2 - f2;
					product1 = Bilinear (Pixels[6], Pixels[5], a1);
				}
				else if (x2 <= f2 && Pixels[6] == Pixels[13] && Pixels[6] != Pixels[7]) {// close to D
					a1 = f2 - x2;
					product1 = Bilinear (Pixels[6], Pixels[10], a1);
				}
				else if (y2 >= x1) {// close to A
					a1 = y2 - x1;
					product1 = Bilinear (Pixels[6], Pixels[5], a1);
				}
				else if (y2 <= x1) {// close to D
					a1 = x1 - y2;
					product1 = Bilinear (Pixels[6], Pixels[10], a1);
				}
			}
			/*3*/
			else {
				product1 = Bilinear4 (Pixels[5], Pixels[6], Pixels[9], Pixels[10], x1, y1);
			}
			//end Pixels[2]irst Pixel
			WRITE_32(dP, product1);
			dP += 2;
			w += dw;
		}
		dstPtr += dstPitch;
    }
	//CopyDelta(srcPtr, srcPitch, deltaPtr, srcPitch, width, height);
}

