/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#include <string.h>
#include <stdlib.h>
//#include "NES_APU_wrapper.h"
#include <stdio.h>
#include "../../../src/types.h"
#include "nes_apu.h"
#include "vrcvisnd.h"
//#include "../NES.h"
#include "../../../src/debug/debug.h"
#include "../../../src/settings.h"
#include "../../../src/nes/cpu/nes6502.h"
#include "../../../src/arm7_shared.h"
#include "ds_sound_mgr.h"

//c-ified to reduce code bloating
void APU_FakeConstructor();
void APU_DoFrame();
void APU_hasExt_VRC6();
static void reset();
/*
static void freeze();
static void thaw();
*/
static void update_local_params();
static void Init();
static void ShutDown();
static void AssertParams();

//static NES *parent_NES NESTER_ARM7EWRAM_BSS;
//static sound_mgr* snd_mgr NESTER_ARM7EWRAM_BSS;
static int _local_sample_rate NESTER_ARM7EWRAM_BSS;
static int _local_sample_size NESTER_ARM7EWRAM_BSS;
static apu_t *apu NESTER_ARM7EWRAM_BSS;
//static uint8 regs[0x16] NESTER_ARM7EWRAM_BSS;
static sound_buf_pos currently_playing_half;

/*
NES_APU::NES_APU(NES* parent)
{
  snd_mgr->clear_buffer();

  apu = 0;
  Init();
  AssertParams();
  reset();
}

NES_APU::~NES_APU()
{
  ShutDown();
}
*/
void APU_FakeConstructor()
{
	DSSM_clear_buffer();
	//regs = (uint8 *)armmalloc(0x16);
	apu = 0;
	Init();
	AssertParams();
	reset();
}

static void update_local_params()
{
  if(DSSM_IsNull())
  {
    // kinda filthy.
    _local_sample_rate = 11025;
    _local_sample_size = 8;
  }
  else
  {
    _local_sample_rate = DSSM_get_sample_rate();
    _local_sample_size = DSSM_get_sample_size();
  }
}

static void Init()
{
  if(apu)
  {
    ShutDown();
  }
  update_local_params();
  apu = apu_create(_local_sample_rate, 60, 0, _local_sample_size);
  //if(!apu) throw "Error creating NES APU";
}

static void ShutDown()
{
  if(apu)
  {
    apu_destroy(&apu);
    apu = 0;
  }
}

void APU_hasExt_VRC6()
{
  if(apu)
  {
    apu_setext(apu, &vrcvi_ext);
    apu_reset();
  }
}

static void AssertParams()
{
  if(apu)
  {
    apu_setchan(0, GBAOPTION_SND_RECT1_ENABLED);
    apu_setchan(1, GBAOPTION_SND_RECT2_ENABLED);
    apu_setchan(2, GBAOPTION_SND_TRIANGLE_ENABLED);
    apu_setchan(3, GBAOPTION_SND_NOISE_ENABLED);
    apu_setchan(4, GBAOPTION_SND_DPCM_ENABLED);
    apu_setchan(5, GBAOPTION_SND_EXTERNAL_ENABLED);
    switch(GBAOPTION_SND_FILTERTYPE)
    {
      case FILTER_NONE:
        apu_setfilter(APU_FILTER_NONE);
        break;
      case FILTER_LOWPASS:
        apu_setfilter(APU_FILTER_LOWPASS);
        break;
      case FILTER_LOWPASS_WEIGHTED:
        apu_setfilter(APU_FILTER_WEIGHTED);
        break;
    }
  }
}

static void reset()
{
  if(apu)
  {
    apu_setext(apu, 0);
    apu_reset();
  }
  //memset(regs, 0x00, sizeof(regs));
}

void APU_DoFrame()
{
  sound_buf_pos cur_ph;  // cur playing half
  sound_buf_pos cur_nph; // cur not-playing half

  uint8* buf;
  uint32 buf_len;

  if(apu)
  {
    if(DSSM_IsNull() || !g_sharedPData->soundEnabled)
    {
      apu_process(0, 0);
    }
    else
    {
      cur_ph = DSSM_get_currently_playing_half();

      if(cur_ph == currently_playing_half) return;

      cur_nph = currently_playing_half;
      currently_playing_half = cur_ph;

	  buf = DSSM_lock(cur_nph, &buf_len);
      if(!buf)
      {
        LOG("couldn't lock sound buffer" << endl);
        return;
      }

      apu_process(buf, buf_len/(_local_sample_size/8));

      DSSM_unlock();
    }
  }
}

/*
static void freeze()
{
  DSSM_clear_buffer();
}

static void thaw()
{
  currently_playing_half = DSSM_get_currently_playing_half();
}
*/
