#include <NDS.h>
//#include "nes/apu/nes_apu_wrapper.h"
#include <stdio.h>
#include <string.h> //DSPIP3
#include <stdlib.h> //DSPIP3
#include "../src/types.h"
#include "../src/sound_mgr.h"
#include "../../src/nes/cpu/nes6502.h"
#include "../../src/arm7_shared.h"
#include "nes/apu/ds_sound_mgr.h"

//nesterds arm7 core module
//based on demo code from chris double (which is based on demo code from ndslib)

uint32 g_lastFifo = 0; //DSPIP5

#define TOUCH_CAL_X1 (*(vs16*)0x027FFCD8)
#define TOUCH_CAL_Y1 (*(vs16*)0x027FFCDA)
#define TOUCH_CAL_X2 (*(vs16*)0x027FFCDE)
#define TOUCH_CAL_Y2 (*(vs16*)0x027FFCE0)
#define SCREEN_WIDTH    256
#define SCREEN_HEIGHT   192
#if 0
s32 TOUCH_WIDTH  = TOUCH_CAL_X2 - TOUCH_CAL_X1;
s32 TOUCH_HEIGHT = TOUCH_CAL_Y2 - TOUCH_CAL_Y1;
s32 TOUCH_OFFSET_X = ( ((SCREEN_WIDTH -60) * TOUCH_CAL_X1) / TOUCH_WIDTH  ) - 28;
s32 TOUCH_OFFSET_Y = ( ((SCREEN_HEIGHT-60) * TOUCH_CAL_Y1) / TOUCH_HEIGHT ) - 28;
#else
#define TOUCH_WIDTH  (TOUCH_CAL_X2 - TOUCH_CAL_X1)
#define TOUCH_HEIGHT (TOUCH_CAL_Y2 - TOUCH_CAL_Y1)
#define TOUCH_OFFSET_X (( ((SCREEN_WIDTH -60) * TOUCH_CAL_X1) / TOUCH_WIDTH  ) - 28)
#define TOUCH_OFFSET_Y (( ((SCREEN_HEIGHT-60) * TOUCH_CAL_Y1) / TOUCH_HEIGHT ) - 28)
#endif


//////////////////////////////////////////////////////////////////////


//void startSound(int sampleRate, const void* data, uint32 bytes, u8 channel=0, u8 vol=0x7F,  u8 pan=63, u8 format=0) {
void startSound(int sampleRate, const void* data, uint32 bytes, u8 channel, u8 vol,  u8 pan, u8 format) {
  SCHANNEL_TIMER(channel)  = SOUND_FREQ(sampleRate);
  SCHANNEL_SOURCE(channel) = (uint32)data;
  SCHANNEL_LENGTH(channel) = bytes;
  SCHANNEL_CR(channel)     = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(vol) | SOUND_PAN(pan) | (format==1?SOUND_8BIT:SOUND_16BIT);
}


s8 getFreeSoundChannel() {
  int i;
  for (i=0; i<16; i++) {
    if ( (SCHANNEL_CR(i) & SCHANNEL_ENABLE) == 0 ) return i;
  }
  return -1;
}

//////////////////////////////////////////////////////////////////////
//DSPIP
extern void APU_FakeConstructor();
extern void APU_DoFrame();
extern void APU_hasExt_VRC6();

extern void UpdateAPUShare();
extern void APU_ProcessSharedQueue();
extern void APU_EmptyQueue();
void APUInterruptLogic(void)
{
	if (g_sharedPData->nesRomRunning)
	{
		if (g_sharedPData->setSoundExt)
		{
			switch (g_sharedPData->setSoundExt)
			{
			case SETSOUNDEXT_VRC6:
				APU_hasExt_VRC6();
				break;
			default:
				break;
			}
			g_sharedPData->setSoundExt = 0;
		}

		//g_sharedPData->debugValue++;
		APU_ProcessSharedQueue(); //DSPIP
		APU_DoFrame();
		UpdateAPUShare(); //DSPIP

		if (!g_sharedPData->soundEnabled)
		{
			memset(g_audioBuffer, 0, buffer_len);
			SCHANNEL_CR(0) = 0;
			SCHANNEL_CR(1) = 0;
		}
	}
}

void ARM7InterruptVBlank(void) {
  static int heartbeat = 0;
 
	u32 i;
    uint16 but=0, x=0, y=0, xpx=0, ypx=0, z1=0, z2=0, batt=0, aux=0;
    int t1=0, t2=0;
    uint32 temp=0;
    uint8 ct[sizeof(IPC->curtime)];

    
    // Update the heartbeat
    heartbeat++;
 
    // Read the X/Y buttons and the /PENIRQ line
    but = REG_KEYXY;
    if (!(but & 0x40)) {
      // Read the touch screen
      x = touchRead(TSC_MEASURE_X);
      y = touchRead(TSC_MEASURE_Y);
      xpx = ( ((SCREEN_WIDTH -60) * x) / TOUCH_WIDTH  ) - TOUCH_OFFSET_X;
      ypx = ( ((SCREEN_HEIGHT-60) * y) / TOUCH_HEIGHT ) - TOUCH_OFFSET_Y;
      z1 = touchRead(TSC_MEASURE_Z1);
      z2 = touchRead(TSC_MEASURE_Z2);
    }

    batt = touchRead(TSC_MEASURE_BATTERY);
    aux  = touchRead(TSC_MEASURE_AUX);

    // Read the time
    rtcGetTime((uint8 *)ct);
    BCDToInteger((uint8 *)&(ct[1]), 7);
 
    // Read the temperature
    temp = touchReadTemperature(&t1, &t2);
 
    // Update the IPC struct
    IPC->heartbeat = heartbeat;
    IPC->buttons   = but;
    IPC->touchX    = x;
    IPC->touchY    = y;
    IPC->touchXpx  = xpx;
    IPC->touchYpx  = ypx;
    IPC->touchZ1   = z1;
    IPC->touchZ2   = z2;
    IPC->battery   = batt;
    IPC->aux       = aux;

    for(i=0; i<sizeof(ct); i++) {
      IPC->curtime[i] = ct[i];
    }

	IPC->temperature = temp;

    //IPC->temperature = temp;
    IPC->tdiode1 = t1;
    IPC->tdiode2 = t2;

	APUInterruptLogic();
}

void ARM7InterruptTimer(void)
{
#ifdef _EWRAM_AUDIO_BUFFER
	  if (g_audioBuffer)
#endif
	  {
#if 1
		g_whichHalfDoYouOwn = !g_whichHalfDoYouOwn;

		if (!g_whichHalfDoYouOwn)
		{
			static uint32 chan = 0;
			SCHANNEL_CR(chan) = 0;
			SCHANNEL_TIMER(chan)  = SOUND_FREQ(APU_SOUND_FREQ);
			SCHANNEL_SOURCE(chan) = (uint32)g_audioBuffer;
			SCHANNEL_LENGTH(chan) = buffer_len;
			SCHANNEL_REPEAT_POINT(chan) = 0;
			SCHANNEL_CR(chan)     = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(0x7F) | SOUND_PAN(63) | g_sampleRateFlag;
			chan = !chan;
			SCHANNEL_CR(chan) = 0;
		}
#endif
	  }
}

//int fakeMallocCount = 0;
//uint8 *fakeMallocArray;//EWRAM_BSS;
void *armmallocfn(int size)
{
	/*
	void *p = (void *)&fakeMallocArray[fakeMallocCount];
	fakeMallocCount += size;
	return p;
	*/
	//ASSERT(0);
	return NULL;
}
void armfreefn(void *p)
{
}

int main(int argc, char ** argv) {
  //enable sound
  powerON(POWER_SOUND);

  // Reset the clock if needed
  rtcReset();

#if 1
  //DSSM_FakeConstructor(APU_SOUND_FREQ, 8, 3);
  DSSM_FakeConstructor(APU_SOUND_FREQ, 8, 1);
  APU_FakeConstructor();
#endif

  //debugging ewram in arm7
  //extern int __ewram_start, __ewram_end;
  //g_sharedPData->debugValue = (int)&__ewram_end - (int)&__ewram_start;

  SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F); //DSPIP4
  IPC->soundData = 0;

  //sound test, fill buffer with static
#if 0
	uint8 *s = g_audioBuffer;
	uint32 j = 0;
	while (j < buffer_len)
	{
		*(s+j) = rand()%255;
		j++;
	}
#endif

  //stick around until sound is enabled at first
  while (!g_sharedPData->soundEnabled);

  //ugliness required due to inability to query hardware to see where it's at in the given buffer
  TIMER2_DATA = TIMER_FREQ(g_sample_rate);
  TIMER2_CR = TIMER_ENABLE|TIMER_DIV_1;
  TIMER3_DATA = (1<<16)-(buffer_len>>2);
  TIMER3_CR = TIMER_ENABLE|TIMER_CASCADE|TIMER_IRQ_REQ;

  // Set up the interrupt handler
  /*
  IME = 0;
  IRQ_HANDLER = &ARM7InterruptHandler;
  IE = IRQ_VBLANK|IRQ_TIMER3; //DSPIP
  IF = ~0;
  DISP_SR = DISP_VBLANK_IRQ;
  IME = 1;
  */
  irqInit();
  irqSet(IRQ_VBLANK, ARM7InterruptVBlank);
  irqSet(IRQ_TIMER3, ARM7InterruptTimer);
  irqEnable(IRQ_VBLANK);
  irqEnable(IRQ_TIMER3);

  // Keep the ARM7 out of main RAM
  while (1)
  {
	  swiWaitForVBlank();
  }
  return 0;
}

 
//////////////////////////////////////////////////////////////////////

