#include "deflateInterface.h"
#include "zlib.h"

//#define INBUFSIZ   1024         /* ̓obt@TCYiCӁj */
//#define OUTBUFSIZ  1024         /* o̓obt@TCYiCӁj */
#define INBUFSIZ   128         /* ̓obt@TCYiCӁj */
#define OUTBUFSIZ  1024         /* o̓obt@TCYiCӁj */

void psp_progress(int cur,int max,int color)
{
    int per;
    char dec[3];

    if(max==0) return;

    /* per = 0-320 */
    per = cur*320 / max;

    pgDrawFrame(80,260,402,270,-1);
    pgFillBox(81,261,81+per,269,color);

    per = (per*10) / 32;
    dec[0] = (per/100) + 0x30;
    dec[1] = (per/10)%10+ 0x30;
    dec[2] = (per%10)  + 0x30;
    dec[3] = 0;
      
    mh_print(403,260,dec,-1);
    pgScreenFlip();
}

int do_compress_m2m(char *pIn,int nInSize,char *pOut,int nOutSize,int level)          /* k */
{
	int flush, status;
	z_stream z;                     /* CuƂƂ肷邽߂̍\ */

	char *pI = pIn;
	char *pO = pOut;
	int nUsedSizeIn  = 0;
	int nUsedSizeOut = 0;

	if((level < 0) || (9 < level))	level = 6;
	if(nOutSize < 0)	return DZEXR_OUTBUFFERROR;

    /* ׂẴǗOōs */
    z.zalloc = Z_NULL;
    z.zfree  = Z_NULL;
    z.opaque = Z_NULL;

    /*  */
    /* 2͈k̓xB0`9 ͈̔͂̐ŁC0 ͖k */
    if (deflateInit(&z, level) != Z_OK){return DZEXR_INITERROR;}

    z.avail_in  = 0;            /* ̓obt@̃f[^̃oCg */
    z.next_out  = pO;           /* o̓|C^ */
    z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut;    /* o̓obt@̃TCY */
	pO           += z.avail_out;
	nUsedSizeOut += z.avail_out;

    /* ʏ deflate() ̑2 Z_NO_FLUSH ɂČĂяo */
    flush = Z_NO_FLUSH;

    while(1)
	{
        if (z.avail_in == 0)
		{  /* ͂s */
            z.next_in  = pI;  /* ̓|C^̓obt@̐擪 */
            z.avail_in = (nInSize - nUsedSizeIn >= INBUFSIZ) ? INBUFSIZ : nInSize - nUsedSizeIn;	/* f[^ǂݍ */
			pI          += z.avail_in;
			nUsedSizeIn += z.avail_in;

            /* ͂ŌɂȂ deflate() ̑2 Z_FINISH ɂ */
            if (z.avail_in < INBUFSIZ) flush = Z_FINISH;
        }
        status = deflate(&z, flush); /* k */

        /* s󋵕\ */
        psp_progress(nUsedSizeIn,nInSize,0x001f<<10);
        
        if (status == Z_STREAM_END) break; /*  */
        if (status != Z_OK) {   /* G[ */
            return DZEXR_DEFLATEERROR;
        }
        if (z.avail_out == 0)
		{ /* o̓obt@s */
            z.next_out  = pO;        /* o̓|C^ɖ߂ */
            z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut; /* o̓obt@cʂɖ߂ */
			pO           += z.avail_out;
			nUsedSizeOut += z.avail_out;

			if(z.avail_out == 0)	return DZEXR_OUTBUFFERROR;
        }
    }

    /* cfo */
    nUsedSizeOut -= z.avail_out;

    /* n */
    if (deflateEnd(&z) != Z_OK)
	{
        return DZEXR_DEFLATEERROR;
    }

	return nUsedSizeOut;
}

int do_decompress_m2m(char *pIn,int nInSize,char *pOut,int nOutSize)        /* WJij */
{
	int status;
	z_stream z;                     /* CuƂƂ肷邽߂̍\ */

	char *pI = pIn;
	char *pO = pOut;
	int nUsedSizeIn  = 0;
	int nUsedSizeOut = 0;

	if(nOutSize < 0)	return DZEXR_OUTBUFFERROR;

   /* ׂẴǗOōs */
    z.zalloc = Z_NULL;
    z.zfree  = Z_NULL;
    z.opaque = Z_NULL;

    /*  */
    z.next_in  = Z_NULL;
    z.avail_in = 0;
    if (inflateInit(&z) != Z_OK){return DZEXR_INITERROR;}

    z.next_out  = pO;           /* o̓|C^ */
    z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut;    /* o̓obt@c */
 	pO           += z.avail_out;
	nUsedSizeOut += z.avail_out;
    status = Z_OK;

    while (status != Z_STREAM_END)
	{
        if (z.avail_in == 0)
		{  /* ͎cʂ[ɂȂ */
            z.next_in  = pI;  /* ̓|C^ɖ߂ */
            z.avail_in = (nInSize - nUsedSizeIn >= INBUFSIZ) ? INBUFSIZ : nInSize - nUsedSizeIn;	/* f[^ǂݍ */
			pI          += z.avail_in;
			nUsedSizeIn += z.avail_in;
        }
        status = inflate(&z, Z_NO_FLUSH); /* WJ */

        /* s󋵕\ */
        psp_progress(nUsedSizeIn,nInSize,0x1f<<8);
        
        if (status == Z_STREAM_END) break; /*  */
        if (status != Z_OK)
		{   /* G[ */
            return DZEXR_INFLATEERROR;
        }
        if (z.avail_out == 0)
		{ /* o̓obt@s */
            z.next_out    = pO;        /* o̓|C^ɖ߂ */
            z.avail_out   = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut; /* o̓obt@cʂɖ߂ */
			pO           += z.avail_out;
			nUsedSizeOut += z.avail_out;

			if(z.avail_out == 0)	return DZEXR_OUTBUFFERROR;
        }
    }

    /* cfo */
    nUsedSizeOut -= z.avail_out;

    /* n */
    if (inflateEnd(&z) != Z_OK)
	{
        return DZEXR_INFLATEERROR;
    }

	return nUsedSizeOut;
}


///////////////////////////////////////////////////////////////////////////////
// 
// ZIPkobNOEhŎs
// 
///////////////////////////////////////////////////////////////////////////////
#include "syscall.h"
#include "zlibpsp.h"

// Compress with Callback
int do_compress_cb(int flag,INPUT_BUFFER* pIn)
{
    z_stream z;
	int flush, status;
    int level;
	char *pI;
    char *pO;
    int nInSize;
    int nOutSize;
	int nUsedSizeIn  = 0;
	int nUsedSizeOut = 0;
    PZLIB_Q pFunc;

    mh_print_hex8(0, 0,pIn->pfQuery,-1);
    mh_print_hex8(0,10,pIn, -1);
    
    sceKernelDcacheWritebackAll();
    pgScreenFlipV();

    
    if(pIn==0) {
        if(pFunc)
          pFunc(ZIPTHD_ERROR,DZEXR_OUTBUFFERROR);
        return DZEXR_INITERROR;
    }
    
    level = pIn->level;
	pI = pIn->i_ptr;
    pO = pIn->o_ptr;
    nInSize  = pIn->i_size;
    nOutSize = pIn->o_size;
	nUsedSizeIn  = 0;
	nUsedSizeOut = 0;
    pFunc = pIn->pfQuery;

    if((level < 1) || (9 < level))	level = 6;  /* k͐ݒs */


    if(nOutSize < 0) {
        pFunc(ZIPTHD_ERROR,DZEXR_OUTBUFFERROR);
        return DZEXR_OUTBUFFERROR;
    }

    /* ׂẴǗOōs */
    z.zalloc = Z_NULL;
    z.zfree  = Z_NULL;
    z.opaque = Z_NULL;

    /*  */
    /* 2͈k̓xB0`9 ͈̔͂̐ŁC0 ͖k */
    if (deflateInit(&z, level) != Z_OK){
        pFunc(ZIPTHD_ERROR,DZEXR_INITERROR);
        return DZEXR_INITERROR;
    }

    z.avail_in  = 0;            /* ̓obt@̃f[^̃oCg */
    z.next_out  = pO;           /* o̓|C^ */
    z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut;    /* o̓obt@̃TCY */
	pO           += z.avail_out;
	nUsedSizeOut += z.avail_out;

    flush = Z_NO_FLUSH;

    while( 1 )
	{
        /* p邩₢킹 */
        if( pFunc(ZIPTHD_QUERY,0)!=0 ) {
            pFunc(ZIPTHD_CANCELED,0);
            break;
        }
        
        pFunc(ZIPTHD_PROGRESS,nUsedSizeIn);
        pFunc(ZIPTHD_MAX     ,nUsedSizeOut);
        
        
        if(z.avail_in == 0) {  /* ͂s */
            z.next_in  = pI;  /* ̓|C^̓obt@̐擪 */
            z.avail_in = (nInSize - nUsedSizeIn >= INBUFSIZ) ? INBUFSIZ : nInSize - nUsedSizeIn;	/* f[^ǂݍ */
            pI          += z.avail_in;
            nUsedSizeIn += z.avail_in;

            /* ͂ŌɂȂ deflate() ̑2 Z_FINISH ɂ */
            if (z.avail_in < INBUFSIZ) flush = Z_FINISH;
        }
        
        status = deflate(&z, flush); /* k */
        
        if(status == Z_STREAM_END) break; /*  */
        if(status != Z_OK) {   /* G[ */
            pFunc(ZIPTHD_ERROR,DZEXR_DEFLATEERROR);
            return DZEXR_DEFLATEERROR;
        }
        
        if(z.avail_out == 0) { /* o̓obt@s */
            z.next_out  = pO;        /* o̓|C^ɖ߂ */
            z.avail_out = (nOutSize - nUsedSizeOut >= OUTBUFSIZ) ? OUTBUFSIZ : nOutSize - nUsedSizeOut; /* o̓obt@cʂɖ߂ */
            pO           += z.avail_out;
            nUsedSizeOut += z.avail_out;

            if(z.avail_out == 0) {
                pFunc(ZIPTHD_ERROR,DZEXR_OUTBUFFERROR);
                return DZEXR_OUTBUFFERROR;
            }
        }
    }
    
    /* cfo */
    nUsedSizeOut -= z.avail_out;
    
    /* n */
    if(deflateEnd(&z) != Z_OK) {
        pFunc(ZIPTHD_ERROR,DZEXR_DEFLATEERROR);
        return DZEXR_DEFLATEERROR;
    }
    
    pFunc(ZIPTHD_COMPLETE,nUsedSizeOut);
    pFunc(ZIPTHD_PROGRESS,nUsedSizeIn);
    pFunc(ZIPTHD_MAX     ,nUsedSizeOut);
    
	return nUsedSizeOut;
}


int compress_thread(int flag,INPUT_BUFFER *pInp)
{
    do_compress_cb(flag,pInp);
    /* kXbhI点 */
    sceKernelExitThread(0);
    return 0;
}


// 
int ZipThread(INPUT_BUFFER* pInp)
{
    int zip_thd = sceKernelCreateThread("zip",compress_thread,0x21,0x10000,0,0);

    if(zip_thd<0) {
        return -1;
    }

    sceKernelStartThread(zip_thd,sizeof(INPUT_BUFFER),pInp);
    return 0;
}

