//////////////////////////////////////////////////////////////////////
// Simple ARM7 stub (sends RTC, TSC, and X/Y data to the ARM 9)
// -- joat
// -- modified by Darkain and others
//////////////////////////////////////////////////////////////////////

#include "../../common/ipc2.h"
#include <NDS.h>
#include "emu2149.h"
#include "emu2212.h"
//#include "emu2413.h"
#include <string.h>

//////////////////////////////////////////////////////////////////////

/*
#define TOUCH_CAL_X1 (*(vs16*)0x027FFCD8)
#define TOUCH_CAL_Y1 (*(vs16*)0x027FFCDA)
#define TOUCH_CAL_X2 (*(vs16*)0x027FFCDE)
#define TOUCH_CAL_Y2 (*(vs16*)0x027FFCE0)
#define SCREEN_WIDTH    256
#define SCREEN_HEIGHT   192
s32 TOUCH_WIDTH  = TOUCH_CAL_X2 - TOUCH_CAL_X1;
s32 TOUCH_HEIGHT = TOUCH_CAL_Y2 - TOUCH_CAL_Y1;
s32 TOUCH_OFFSET_X = ( ((SCREEN_WIDTH -60) * TOUCH_CAL_X1) / TOUCH_WIDTH  ) - 28;
s32 TOUCH_OFFSET_Y = ( ((SCREEN_HEIGHT-60) * TOUCH_CAL_Y1) / TOUCH_HEIGHT ) - 28;
*/

// those are pixel positions of the two points you click when calibrating
#define TOUCH_CNTRL_X1   (*(vu8*)0x027FFCDC)
#define TOUCH_CNTRL_Y1   (*(vu8*)0x027FFCDD)
#define TOUCH_CNTRL_X2   (*(vu8*)0x027FFCE2)
#define TOUCH_CNTRL_Y2   (*(vu8*)0x027FFCE3)

// those are the corresponding touchscreen values:
#define TOUCH_CAL_X1   (*(vu16*)0x027FFCD8)
#define TOUCH_CAL_Y1   (*(vu16*)0x027FFCDA)
#define TOUCH_CAL_X2   (*(vu16*)0x027FFCDE)
#define TOUCH_CAL_Y2   (*(vu16*)0x027FFCE0)

// linear mapping can be used to go from touchscreen position to pixel position
// precalculate some values
static int16 TOUCH_WIDTH  = TOUCH_CAL_X2 - TOUCH_CAL_X1;
static int16 TOUCH_HEIGHT = TOUCH_CAL_Y2 - TOUCH_CAL_Y1;
static int16 CNTRL_WIDTH  = TOUCH_CNTRL_X2 - TOUCH_CNTRL_X1;
static int16 CNTRL_HEIGHT = TOUCH_CNTRL_Y2 - TOUCH_CNTRL_Y1;




PSG * psg;
SCC * scc;
//OPLL * opll;

#define MSX_CLK 3579545
#define SAMPLERATE  11025  //22050
#define SOUNDBUFCNT ((u16)(512))   //367

#define TIMERCOUNT  ((int)( 33554432 / SAMPLERATE ))

u16 * soundbuf;
int wptr  = 0; // f[^ʒu
int wbufp = 0; // f[^obt@
int SoundProcTiming = 0;

//////////////////////////////////////////////////////////////////////

void startSound(int sampleRate, const void* data, uint32 bytes, u8 channel=0, u8 vol=0x7F,  u8 pan=63, u8 format=0) {
  SCHANNEL_CR(channel)     = 0;
  SCHANNEL_TIMER(channel)  = SOUND_FREQ(sampleRate);
  SCHANNEL_SOURCE(channel) = (uint32)data;
  SCHANNEL_LENGTH(channel) = bytes >> 2;
  SCHANNEL_REPEAT_POINT(channel) = 0;
  SCHANNEL_CR(channel)     = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(vol) | SOUND_PAN(pan) | (format==1? SOUND_FORMAT_8BIT:SOUND_FORMAT_16BIT);
}

bool isFreeSoundChannel(int i) {
  if ( (SCHANNEL_CR(i) & SCHANNEL_ENABLE) == 0 ) return true;
  return false;
}

void waitForVBlank()
{
	while(!(DISP_SR & DISP_IN_VBLANK));
	while((DISP_SR & DISP_IN_VBLANK));
}

//////////////////////////////////////////////////////////////////////

EMU2149_API PSG *
_PSG_new (e_uint32 c, e_uint32 r)
{
  memset((char*)psg, 0, sizeof (PSG));

  PSG_setVolumeMode (psg, EMU2149_VOL_DEFAULT);
  psg->clk = c;
  psg->rate = r ? r : 44100;
  PSG_set_quality (psg, 0);

  return psg;
}

EMU2212_API SCC *
_SCC_new (e_uint32 c, e_uint32 r)
{
  memset((char*)scc, 0, sizeof (SCC));

  scc->clk = c;
  scc->rate = r ? r : 44100;
  SCC_set_quality (scc, 0);
  scc->type = SCC_ENHANCED;
  return scc;
}

void InitSound(int r)
{
	psg = (PSG*)&(IPC2->psg);
	scc = (SCC*)&(IPC2->scc);
	
	soundbuf = (u16*)(IPC2->soundbuf);

	// PSG initialize
	_PSG_new(MSX_CLK,r);
	PSG_reset( psg );

	// SCC initialize
	_SCC_new(MSX_CLK,r);
	SCC_reset( scc );

	// OPLL initialize
//	opll = OPLL_new(MSX_CLK,r);
//	OPLL_reset( opll );
}

static int nx, ny; 

static bool updateTouch(){ 
   int c = 7; 
   int i,j; 
   int x[c]; 
   int y[c]; 
   int temp; 

	for (i=0; i<c; i++){ 
		if (!(REG_KEYXY & (1<<6))){ 
			x[i] = touchRead(TSC_MEASURE_X); 
			y[i] = touchRead(TSC_MEASURE_Y); 
		} 
		else return false; 
	} 
	//Bubblesort 
	for (i=0;i<c-1;i++){ 
		for (j=0;j<c-1;j++){ 
			if (x[j]>x[j+1]){ 
				temp = x[j];x[j] = x[j+1];x[j+1] = temp; 
			} 
			if (y[j]>y[j+1]){ 
				temp = y[j];y[j] = y[j+1];y[j+1] = temp; 
			} 
		} 
	} 
	//Take the median 
	nx = x[(c-1)/2]; 
	ny = y[(c-1)/2]; 
	return true; 
} 

#define ABS(x) ((x) < 0) ? -(x) : (x) 
#ifndef max
#define max(a,b)  (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b)  (((a) < (b)) ? (a) : (b))
#endif
void vsync()
{
	static int heartbeat = 0;
	static const int savePad = 3; 
	static int oldX[3], oldY[3], oldKeys; 
	static int firsttouch; 

 
	uint16 but=0,x=0,y=0,xpx=0,ypx=0, z1=0, z2=0, batt=0, aux=0;
	int t1=0, t2=0;
	uint32 temp=0;
	uint8 ct[sizeof(IPC->curtime)];
	u32 i; 
	bool cleanread=false; 

	// Update the heartbeat
	heartbeat++;

	// Read the X/Y buttons and the /PENIRQ line
	but = REG_KEYXY;
	if (!(but & (1<<6))) { 
		cleanread = updateTouch(); 
		if (((oldKeys & (1<<6)) != 0)) firsttouch = heartbeat; 

		z1 = touchRead(TSC_MEASURE_Z1);
		z2 = touchRead(TSC_MEASURE_Z2);
	}
	//just released 
	if (((oldKeys & (1<<6)) == 0) && (!cleanread)){ 
		x = oldX[0];
		y = oldY[0];
		xpx = ((int)x - 700) / ((3450-700)/256);
		ypx = ((int)y - 570) / ((3450-570)/192);
//		xpx = 32 +(((SCREEN_WIDTH  - 64)*(x - TOUCH_CAL_X1))/ TOUCH_WIDTH);
//		ypx = 32 +(((SCREEN_HEIGHT - 64)*(y - TOUCH_CAL_Y1))/ TOUCH_HEIGHT);
//		xpx = (x - (int16) TOUCH_CAL_X1) * CNTRL_WIDTH  / TOUCH_WIDTH  + (int16) TOUCH_CNTRL_X1;
//		ypx = (y - (int16) TOUCH_CAL_Y1) * CNTRL_HEIGHT / TOUCH_HEIGHT + (int16) TOUCH_CNTRL_Y1;
		xpx=min(max(xpx, 0), 255);
		ypx=min(max(ypx, 0), 192);
		IPC->buttons  = REG_KEYXY & ~(1<<6); 
	} 
	else if (cleanread){ 
		for (i=0; i<savePad - 1; i++){ 
		 oldX[i]=oldX[i+1]; 
		 oldY[i]=oldY[i+1]; 
		} 
		oldX[savePad-1] = nx; 
		oldY[savePad-1] = ny; 
		x = oldX[savePad - 2];
		y = oldY[savePad - 2];
		xpx = ((int)x - 700) / ((3450-700)/256);
		ypx = ((int)y - 570) / ((3450-570)/192);
//		xpx = 32 +(((SCREEN_WIDTH  - 64)*(x - TOUCH_CAL_X1))/ TOUCH_WIDTH);
//		ypx = 32 +(((SCREEN_HEIGHT - 64)*(y - TOUCH_CAL_Y1))/ TOUCH_HEIGHT);
//		xpx = (x - (int16) TOUCH_CAL_X1) * CNTRL_WIDTH  / TOUCH_WIDTH  + (int16) TOUCH_CNTRL_X1;
//		ypx = (y - (int16) TOUCH_CAL_Y1) * CNTRL_HEIGHT / TOUCH_HEIGHT + (int16) TOUCH_CNTRL_Y1;
		xpx=min(max(xpx, 0), 255);
		ypx=min(max(ypx, 0), 192);
	} 
	if (ABS(heartbeat - firsttouch) < 4){ 
		//we have to wait 
		IPC->buttons = but | REG_KEYXY | (1<<6); 
	} else {
		IPC->buttons = but | REG_KEYXY; 
	}
	oldKeys = but | REG_KEYXY; 

	batt = touchRead(TSC_MEASURE_BATTERY);
	aux  = touchRead(TSC_MEASURE_AUX);

	// Read the time
	rtcGetTime((uint8 *)ct);
	BCDToInteger((uint8 *)&(ct[1]), 7);

	// Read the temperature
	temp = touchReadTemperature(&t1, &t2);

	// Update the IPC struct
	IPC->heartbeat = heartbeat;
	IPC->touchZ1   = z1;
	IPC->touchZ2   = z2;
	IPC->battery   = batt;
	IPC->aux       = aux;
	IPC->temperature = temp;
	IPC->tdiode1 = t1;
	IPC->tdiode2 = t2;
//	IPC->buttons   = but;
	IPC->touchX    = x;
	IPC->touchY    = y;
	IPC->touchXpx  = xpx;
	IPC->touchYpx  = ypx;

	for(u32 i=0; i<sizeof(ct); i++) {
	  IPC->curtime[i] = ct[i];
	}
}

void InterruptHandler(void) {

	if (REG_IF & IRQ_VBLANK) {
		vsync();
		VBLANK_INTR_WAIT_FLAGS |= IRQ_VBLANK;
	}
//	static int cnt=0;
	if (REG_IF & IRQ_TIMER0) {
		SoundProcTiming ++;
		VBLANK_INTR_WAIT_FLAGS |= IRQ_TIMER0;
	}
	// Acknowledge interrupts
	REG_IF = REG_IF;
}
 

/** LoopSound() **********************************************/
/** Main loop of the sound server.                          **/
/*************************************************************/

void ProcSound()
{
	e_uint16 P,S,O,A;
	static u16 * sbuf = soundbuf;
	P=O=A=S=0;

	P = PSG_calc(psg)  * 2;
	S = SCC_calc(scc)  * 2;
//		O = OPLL_calc(opll) * 2;
//			if(snd.opl)  A = OPL_calc(snd.opl);
	*sbuf = P+S; //O+(A>>2);

	sbuf ++;
	wptr ++ ;
	if( wptr >= SOUNDBUFCNT ){
		startSound(SAMPLERATE, soundbuf + wbufp*SOUNDBUFCNT, SOUNDBUFCNT*2, wbufp , 0x7f, 63, 0);
		wbufp = wbufp==0?1:0; 
		sbuf = soundbuf + wbufp*SOUNDBUFCNT;
		wptr = 0;
	}
}

int main(int argc, char ** argv) {

//	IPC->soundCommandResult	= 0;
	int SoundPause = true;
	// Reset the clock if needed
	rtcReset();

	//enable sound
	powerON(POWER_SOUND);
	SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F);

	// Set up the interrupt handler
	REG_IME = 0;
	IRQ_HANDLER = &InterruptHandler;
	REG_IE  = IRQ_VBLANK | IRQ_TIMER0;
	REG_IF  = ~0;
	DISP_SR = DISP_VBLANK_IRQ;
	REG_IME = 1;

	// Timer setting
	TIMER0_DATA = 0x10000 - TIMERCOUNT;
	TIMER0_CR = TIMER_DIV_1 | TIMER_IRQ_REQ | TIMER_ENABLE;

	
	while (1){
		switch( IPC2->soundCommand ){
			case 1: // Pause
				SoundPause = true;
				IPC2->soundCommand = 0;
				break;
			case 2: // Play
				SoundPause = false;
				SoundProcTiming = 0;
				wptr  = 0;
				wbufp = 0;
				IPC2->soundCommand = 0;
				break;
			case 3: // Sound Initialize
				InitSound(SAMPLERATE);
				IPC2->soundCommand = 0;
				break;
		}
		if( !SoundPause ){
			if( SoundProcTiming > 0 ){
				ProcSound();
				SoundProcTiming --;
			}
		}
//		swiWaitForVBlank();
	}
	return 0;
}
