// pthreadtest.c
// Testing basic threading manuevers

#include <pthread.h> // threads...

#include <errno.h> // errno
#include <stddef.h> // NULL
#include <stdio.h> // printf()
#include <string.h> // strerror()
#include <sys/select.h> // select()
#include <sys/types.h> // pid_t
#include <sys/wait.h> // waitpid()
#include <time.h> // struct timeval
#include <unistd.h> // select()

#include "../src/misc.h"


// Globals

pthread_t driverthread;
pthread_attr_t driverattr;
pthread_mutex_t drivermutex;

int testvar;


// Functions

// Starts child process as well.
void *ChildProcessLoop(void *garbage) {
  printf("  Child Thread started\n");

  while(testvar != 1)  TrueSleep(1, 0);
  printf("  Child starting TrueSleep() test\n");

  while(testvar != 2)  TrueSleep(1, 0);
  printf("  Child Thread starting pthread_mutex test\n");
  pthread_mutex_lock(&drivermutex);
  printf("  Child Thread released\n");
  pthread_mutex_unlock(&drivermutex);

  while(testvar != 3)  TrueSleep(1, 0);

  printf("  Child Thread stopping\n");
  pthread_exit(NULL);
} // END ChildProcessLoop()


// Main test area

int main(int argc, char *argv[]) {
  int returnval;

  printf("\n\n*** Dual Process Test ***\n");
  printf("*** Hope your CPU activity monitor is up ***\n\n");


  printf("Preparation\n");

  pthread_mutex_init(&drivermutex, NULL); // Default of 'fast' locks

  testvar = 0;

  printf("  Starting Child Thread\n");
  pthread_attr_init(&driverattr);
  pthread_attr_setdetachstate(&driverattr, PTHREAD_CREATE_JOINABLE);
  returnval = pthread_create(&driverthread,
                             NULL,
                             ChildProcessLoop,
                             NULL);
  if(returnval == -1) {
    printf("Error: Couldn't start child process\n");
    return(1);
  } // ENDIF- Couldn't start second process? Abort

  if(returnval == 1) {
    printf("Eeek! Child Process leaked into main loop! (failure)\n");
    return(0); // END Child Process?
  } // ENDIF- Child process came here? Try to stop process cleanly.

  // Parent stuff starts here.
  printf("  Interface section continuing\n");

  printf("\nFirst Test: 10 seconds under TrueSleep()\n");
  printf("  Starting Test\n");
  testvar = 1;
  TrueSleep(10, 0);

  printf("\nSecond Test: 10 seconds under pthread_mutex lock\n");
  printf("  Locking Parent Thread\n");
  pthread_mutex_lock(&drivermutex);

  printf("  Starting Test\n");
  testvar = 2;
  TrueSleep(0, 10000000);
  pthread_mutex_unlock(&drivermutex);

  printf("  Flushing mutex\n");
  pthread_mutex_lock(&drivermutex);
  pthread_mutex_unlock(&drivermutex);

  printf("\n Third Test: 10 seconds of terminated thread waiting for a 'join'\n");

  printf("  Starting Test\n");
  testvar = 3;
  TrueSleep(10, 0);

  returnval = pthread_join(driverthread, NULL);
  if(returnval != 0) {
    printf("Failed to wait for the child thread to stop!\n");
  } // ENDIF- Trouble terminating the child thread?

  pthread_attr_destroy(&driverattr);
  pthread_mutex_destroy(&drivermutex);

  printf("\n*** Test Complete ***\n\n");
  pthread_exit(NULL);
} // END main()
