// test.c
// Testing a CD for encryption

#include <errno.h> // errno
#include <dlfcn.h> // dlopen(), dlsym(), dlclose()
#include <stddef.h> // NULL
#include <stdio.h> // printf()
#include <string.h> // strerror()
#include <unistd.h> // sleep()

#define PLUGINtypedefs
#define PLUGINfuncs
#include "../src/PS2Edefs.h"


void HexDump(u8 *strptr, u8 count) {
  int i;
  u8 ch[2];

  ch[1] = 0;

  if(count == 0)  count = 16;
  if((count < 1) || (count > 16))  return;

  for(i = 0; i < count; i++) {
    printf("%.2x ", (*(strptr + i)) * 1);
  } // NEXT i- printing each new Hex number

  for(i = 0; i < count; i++) {
    if((*(strptr + i) < 32) || (*(strptr + i) > 127)) {
      printf(".");
    } else {
      ch[0] = *(strptr + i);
      printf("%s", ch);
    } // ENDIF- Is this an unprintable character?
  } // NEXT i- printing each new character
  printf("\n");
} // ENDIF HexDump()

int main(int argc, char *argv[]) {
  int returnval;
  char *dllerrorcode;

  void *CDVDplugin;
  char *buffer;
  int i;

  printf("\n\n*** Library loading shell test ***\n\n");

  CDVDplugin = NULL;
  buffer = NULL;

  CDVDinit = NULL;
  CDVDshutdown = NULL;
  CDVDopen = NULL;
  CDVDclose = NULL;
  CDVDgetTrayStatus = NULL;
  CDVDreadTrack = NULL;
  CDVDgetBuffer = NULL;

  printf("Retrieving Library\n");
  CDVDplugin = dlopen("../src/libCDVDlinuz.so", RTLD_NOW);
  if((CDVDplugin == NULL) || (errno != 0)) {
    printf("  Error: %s", dlerror());
  } // ENDIF- Trouble with a command? Print it out!

  if(CDVDplugin != NULL) {
    printf("Retrieving Symbol for CDVDinit\n");
    (_CDVDinit) CDVDinit = dlsym(CDVDplugin, "CDVDinit");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDinit = NULL;
    } // ENDIF- Error retrieving the symbol?

    printf("Retrieving Symbol for CDVDopen\n");
    (_CDVDopen) CDVDopen = dlsym(CDVDplugin, "CDVDopen");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDopen = NULL;
    } // ENDIF- Error retrieving the symbol?

    printf("Retrieving Symbol for CDVDclose\n");
    (_CDVDclose) CDVDclose = dlsym(CDVDplugin, "CDVDclose");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDclose = NULL;
    } // ENDIF- Error retrieving the symbol?

    printf("Retrieving Symbol for CDVDshutdown\n");
    (_CDVDshutdown) CDVDshutdown = dlsym(CDVDplugin, "CDVDshutdown");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDshutdown = NULL;
    } // ENDIF- Error retrieving the symbol?

    printf("Retrieving Symbol for CDVDgetTrayStatus\n");
    (_CDVDgetTrayStatus) CDVDgetTrayStatus = dlsym(CDVDplugin, "CDVDgetTrayStatus");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDclose = NULL;
    } // ENDIF- Error retrieving the symbol?

    printf("Retrieving Symbol for CDVDreadTrack\n");
    (_CDVDreadTrack) CDVDreadTrack = dlsym(CDVDplugin, "CDVDreadTrack");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDreadTrack = NULL;
    } // ENDIF- Error retrieving the symbol?

    printf("Retrieving Symbol for CDVDgetBuffer\n");
    (_CDVDgetBuffer) CDVDgetBuffer = dlsym(CDVDplugin, "CDVDgetBuffer");
    dllerrorcode = dlerror();
    if(dllerrorcode != NULL) {
      printf("  Error: %s", dlerror());
      CDVDgetBuffer = NULL;
    } // ENDIF- Error retrieving the symbol?
  } // ENDIF- We have a library loaded? Load the symbols from that library.

  if((CDVDinit != NULL) || 
     (CDVDopen != NULL) ||
     (CDVDgetTrayStatus != NULL) ||
     (CDVDreadTrack != NULL) ||
     (CDVDgetBuffer != NULL) ||
     (CDVDclose != NULL) ||
     (CDVDshutdown != NULL)) {
    printf("Calling CDVDinit\n");
    CDVDinit();

    printf("Calling CDVDopen\n");
    CDVDopen();

    sleep(2); // Needs to stabilize before below call will work
    printf("Calling CDVDgetTrayStatus\n");
    returnval = CDVDgetTrayStatus();

    if(returnval == CDVD_TRAY_CLOSE) {
      printf("Calling CDVDreadTrack()\n");
      returnval = CDVDreadTrack(16, CDVD_MODE_2048);
      if(returnval == 0) {
        buffer = CDVDgetBuffer();
        if(buffer != NULL) {
          for(i = 0; i < 2048; i += 16) {
            printf("%.4x  ", i);
            HexDump(buffer+i, 16);
          } // NEXT i- dumping the buffer, one line at a time
        } // ENDIF- got a buffer? print it.
        buffer = NULL;
      } // ENDIF- Read a track? Get the buffer pointer.
    } // ENDIF- Do we have a disc to play with?

    printf("Calling CDVDclose\n");
    CDVDclose();

    printf("Calling CDVDshutdown\n");
    CDVDshutdown();
  } // ENDIF- If the symbols are all loaded...

  if(CDVDplugin != NULL) {
    printf("Releasing Library\n");
    returnval = dlclose(CDVDplugin);
    if((returnval != 0) || (errno != 0)) {
      printf("  Error: (%i) %i:%s", returnval, errno, strerror(errno));
    } // ENDIF- Trouble with a command? Print it out!
    CDVDplugin = NULL;
    CDVDinit = NULL;
    CDVDshutdown = NULL;
    CDVDopen = NULL;
    CDVDclose = NULL;
    CDVDgetTrayStatus = NULL;
    CDVDreadTrack = NULL;
    CDVDgetBuffer = NULL;
  } // ENDIF- Do we even have a library to work with?

  printf("\n*** Test Complete ***\n\n");
  return(0);
} // END main()
