// test.c
// Testing device access directly

#include <errno.h> // errno
#include <stddef.h> // NULL
#include <stdio.h> // printf()
#include <string.h> // strerror()

#include "../src/device.h"
#include "../src/DVD.h" // HexDump()
#include "../src/misc.h"


int main(int argc, char *argv[]) {
  int returnval;
  int i;
  unsigned char testbuffer[2352];
  int offset;

  printf("\n\n*** Device access test ***\n\n");

  conf.devicename[0] = 0;
  devicehandle = -1;
  devicecapability = 0;

  printf("Calling LoadConf()\n");
  LoadConf();

  printf("Calling DeviceOpen\n");
  DeviceOpen();

  TrueSleep(2, 0); // Needs to stabilize before below call will work
  printf("Calling DeviceTrayStatus\n");
    returnval = DeviceTrayStatus();

    if(returnval == CDVD_TRAY_CLOSE) {
      printf("Calling DeviceReadTrack()\n");
      returnval = DeviceReadTrack(16, CDVD_MODE_2048, testbuffer);
      if(returnval == 0) {
          offset = DeviceBufferOffset();
          for(i = 0; i < 2048; i += 16) {
            // printf("%.4x  ", i);
            HexDump(testbuffer + offset + i, 16);
          } // NEXT i- dumping the buffer, one line at a time
      } // ENDIF- Read a track? Get the buffer pointer.
    } // ENDIF- Do we have a disc to play with?

    printf("Calling DeviceClose\n");
    DeviceClose();

  printf("\n*** Test Complete ***\n\n");
  return(0);
} // END main()
