// buffertest.c
// Testing basic buffer manuevers

#include <errno.h> // errno
#include <stddef.h> // NULL
#include <stdio.h> // printf()
#include <string.h> // strerror()

#define CDVDdefs
#include "../src/PS2Edefs.h" // Variable Types

#include "../src/buffer.h"


// Globals
#define ARRAYSIZE 250


// Holdover globals (while testing TrueSleep() in misc.c)


// Functions


// Main test area

int main(int argc, char *argv[]) {
  u16 retbuffer;
  u32 i;

  printf("\n\n*** Buffer Base Test ***\n\n");

  printf("Preparation\n");
  InitBuffer();

  printf("Trying to find a non-existant record from an empty buffer (65535)\n");
  retbuffer = FindListBuffer(50000);
  if(retbuffer != 0xffff)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Adding 1 Record to empty buffer (0)\n");
  bufferlist[0].lsn = 50000;
  AddListBuffer(0);

  printf("Trying to find a existing record from a 1 record buffer (0)\n");
  retbuffer = FindListBuffer(50000);
  if(retbuffer != 0)  printf("  Error: found %u instead!", retbuffer);

  printf("Trying to find a non-existant record from a 1 record buffer (65535)\n");
  retbuffer = FindListBuffer(40000);
  if(retbuffer != 0xffff)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Adding another record with the same LSN (replacing the old one)\n");
  bufferlist[1].lsn = 50000;
  AddListBuffer(1);

  printf("Removing 1 Record, emptying buffer (1)\n");
  RemoveListBuffer(1);

  printf("Adding 2 records, far away from each other in LSN\n");
  bufferlist[0].lsn = 0xff000000;
  bufferlist[1].lsn = 0x000000ff;
  AddListBuffer(0);
  AddListBuffer(1);

  printf("Trying to find the first record from a 2 record buffer\n");
  retbuffer = FindListBuffer(0xff000000);
  if(retbuffer != 0)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Trying to find the second record from a 2 record buffer\n");
  retbuffer = FindListBuffer(0x000000ff);
  if(retbuffer != 1)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Trying to find a non-existant record from a 1 record buffer (65535)\n");
  retbuffer = FindListBuffer(40000);
  if(retbuffer != 0xffff)  printf("  Error: found %u instead!\n", retbuffer);

#ifdef VERBOSE_FUNCTION_BUFFER
  PrintSortBuffers();
#endif /* VERBOSE_FUNCTION_BUFFER */

  printf("Removing 2 Records\n");
  RemoveListBuffer(0);
  RemoveListBuffer(1);

  printf("Adding a bunch of records, 1000 LSN spacing\n");
  for(i = 0; i < ARRAYSIZE; i++) {
    bufferlist[i].lsn = i * 1000;
    AddListBuffer(i);
  } // NEXT i- Adding each record

#ifdef VERBOSE_FUNCTION_BUFFER
  PrintSortBuffers();
#endif /* VERBOSE_FUNCTION_BUFFER */

  printf("Trying to find an existing record from the record buffer\n");
  retbuffer = FindListBuffer(20000);
  if(retbuffer != 20)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Trying to find a non-existant record from the record buffer (65535)\n");
  retbuffer = FindListBuffer(5050);
  if(retbuffer != 0xffff)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Replacing those records with 1 LSN spacing\n");
  for(i = 0; i < ARRAYSIZE; i++) {
    // RemoveListBuffer(i); // Shouldn't be needed to work.
    bufferlist[i].lsn = i + 2000;
    AddListBuffer(i);
  } // NEXT i- Adding each record

#ifdef VERBOSE_FUNCTION_BUFFER
  PrintSortBuffers();
#endif /* VERBOSE_FUNCTION_BUFFER */

  printf("Trying to find an existing record from the record buffer\n");
  retbuffer = FindListBuffer(2020);
  if(retbuffer != 20)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Trying to find a non-existant record from the record buffer (65535)\n");
  retbuffer = FindListBuffer(40000);
  if(retbuffer != 0xffff)  printf("  Error: found %u instead!\n", retbuffer);

  printf("Removing the Records\n");
  for(i = 0; i < ARRAYSIZE; i++) {
    RemoveListBuffer(i);
  } // NEXT i- Adding each record

  printf("\n*** Test Complete ***\n\n");
  return(0);
} // END main()
