/*  misc.c
 *  Copyright (C) 2002-2005  CDVDlinuz Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stddef.h> // NULL
#include <stdio.h> // printf()
#include <sys/time.h> // select()
#include <sys/types.h> // select()
#include <time.h> // time_t, time(), struct timeval
#include <unistd.h> // select()

// #define CDVDdefs
// #include "PS2Edefs.h"

#include "device.h" // devicehandle, traystatus, disctype
#include "misc.h"


void TrueSleep(int secs, int usecs) {
  struct timeval tv;
  int retval;

  if((secs < 0) || (usecs < 0))  return; // No invalid values, please.
  if((secs == 0) && (usecs == 0))  return; // No infinite loops, please.

#ifdef VERBOSE_FUNCTION_MISC
  printf("CDVD misc: TrueSleep()\n");
#endif /* VERBOSE_FUNCTION_MISC */

  tv.tv_sec = secs;
  tv.tv_usec = usecs;
  retval = select(1, NULL, NULL, NULL, &tv); // Let other programs run for a time
  return;
} // END TrueSleep()
