/*  interface.c
 *  Copyright (C) 2002-2005  CDVDlinuz Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <fcntl.h> // open()
#include <stddef.h> // NULL
#include <stdio.h> // printf()
#include <stdlib.h> // malloc(), free()
#include <sys/stat.h> // open()
#include <sys/types.h> // open()
#include <unistd.h> // close()

#include <glib.h> // GList, gpointer

#include <gtk/gtkbutton.h> // gtk_button_new_with_label()
#include <gtk/gtkcombo.h> // gtk_combo_new()
#include <gtk/gtkcontainer.h> // gtk_container_set_border_width()
#include <gtk/gtkentry.h> // gtk_entry_new()
#include <gtk/gtkhbox.h> // gtk_hbox_new()
#include <gtk/gtkhbbox.h> // gtk_hbutton_box_new()
#include <gtk/gtklabel.h> // gtk_label_new()
#include <gtk/gtkmain.h> // gtk_main(), gtk_main_quit()
#include <gtk/gtkobject.h> // gtk_object_set_data()
#include <gtk/gtksignal.h> // gtk_signal_connect()
#include <gtk/gtkvbox.h> // get_vbox_new()
#include <gtk/gtkwidget.h> // gtk_widget_destroy(), gtk_widget_ref()
#include <gtk/gtkwindow.h> // gtk_window_new()

// #define CDVDdefs
// #include "PS2Edefs.h"

#include "device.h"


// Globals
struct {
  GtkWidget *window;
  GtkWidget *GtkEntry_Dev;
  GtkWidget *GtkCombo_Mode;
  GtkWidget *GtkComboEntry_Mode;
  GtkWidget *GtkCombo_Speed;
  GtkWidget *GtkComboEntry_Speed;
} display;

char *ReadModeNames[] = {
	"00 - Normal",
	"01 - Threaded (faster)",
	""
};

char *DriveSpeedNames[] = {
	"00 - Let Device decide (recommended)",
	"01 - 1x Speed",
	"02 - 2x Speed",
	"03 - 3x Speed",
	"04 - 4x Speed",
	"05 - 5x Speed",
	"06 - 6x Speed",
	"07 - 7x Speed",
	"08 - 8x Speed",
	"09 - 9x Speed",
	"10 - 10x Speed",
	"11 - 11x Speed",
	"12 - 12x Speed",
	"13 - 13x Speed",
	"14 - 14x Speed",
	"15 - 15x Speed",
	"16 - 16x Speed",
	""
};


void DisplayShutdown() {
  // Do we have to destroy the 2 GLists we created separately?

  gtk_widget_destroy(display.window);
  display.window = NULL;
  display.GtkEntry_Dev = NULL;
  display.GtkCombo_Mode = NULL;
  display.GtkComboEntry_Mode = NULL;
  display.GtkCombo_Speed = NULL;
  display.GtkComboEntry_Speed = NULL;
  gtk_main_quit();
} // END DisplayShutdown()


void DisplaySaveAndShutdown() {
  gchar *tempptr;
  int i;

  i = 0;

  tempptr = gtk_entry_get_text(GTK_ENTRY(display.GtkEntry_Dev));
  if(tempptr != NULL) {
    while((i < 255) && (*(tempptr + i) != 0)) {
      conf.devicename[i] = *(tempptr + i);
      i++;
    } // ENDWHILE- copying characters of device name out...
    conf.devicename[i] = 0; // And 0-terminate
  } // ENDIF- Sanity check... Did a Gtk Device Entry field get made?

  tempptr = gtk_entry_get_text(GTK_ENTRY(display.GtkComboEntry_Mode));
  conf.readmode = (*(tempptr) - 48) * 10 + (*(tempptr+1) - 48);

  // tempptr = gtk_entry_get_text(GTK_ENTRY(display.GtkComboEntry_Speed));
  // conf.drivespeed = (*(tempptr) - 48) * 10 + (*(tempptr+1) - 48);

  devicehandle = open(conf.devicename, O_RDONLY | O_NONBLOCK);
  if(devicehandle == -1) {
    printf("*** Failed to open the device! ***\n");
    return;
  } // ENDIF- Succeed in finding the device? Save!
  close(devicehandle);
  devicehandle = -1;

  SaveConf();
  DisplayShutdown();
} // END DisplaySaveAndShutdown()


void CALLBACK CDVDabout() {
  GtkWidget *vbox;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *buttonbox;
  GtkWidget *button;

  display.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(display.window), "About", display.window);
  gtk_container_set_border_width(GTK_CONTAINER(display.window), 5);
  gtk_window_set_title(GTK_WINDOW(display.window), "About CDVDEFP");
  gtk_window_set_position(GTK_WINDOW(display.window), GTK_WIN_POS_CENTER);
  gtk_window_set_modal(GTK_WINDOW(display.window), TRUE);
  gtk_window_set_policy(GTK_WINDOW(display.window), FALSE, FALSE, FALSE);

  gtk_signal_connect(GTK_OBJECT(display.window), "destroy",
                     GTK_SIGNAL_FUNC(DisplayShutdown), NULL);

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_widget_ref(vbox);
  gtk_object_set_data_full(GTK_OBJECT(display.window), "vbox", vbox,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(display.window), vbox);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

  label1 = gtk_label_new("CDVDEFP Driver");
  gtk_widget_ref(label1);
  gtk_object_set_data_full(GTK_OBJECT(display.window), "label1", label1,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label1);
  gtk_box_pack_start(GTK_BOX(vbox), label1, FALSE, FALSE, 0);

  label2 = gtk_label_new("Author: linuzappz <linuzappz@hotmail.com>");
  gtk_widget_ref(label2);
  gtk_object_set_data_full(GTK_OBJECT(display.window), "label2", label2,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label2);
  gtk_box_pack_start(GTK_BOX(vbox), label2, FALSE, FALSE, 0);

  label3 = gtk_label_new("Modified by: EFP");
  gtk_widget_ref(label3);
  gtk_object_set_data_full(GTK_OBJECT(display.window), "label3", label3,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(label3);
  gtk_box_pack_start(GTK_BOX(vbox), label3, FALSE, FALSE, 0);

  buttonbox = gtk_hbutton_box_new();
  gtk_widget_ref(buttonbox);
  gtk_object_set_data_full(GTK_OBJECT(display.window), "buttonbox", buttonbox,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(buttonbox);
  gtk_box_pack_start(GTK_BOX(vbox), buttonbox, TRUE, TRUE, 0);

  button = gtk_button_new_with_label("Ok");
  gtk_widget_ref(button);
  gtk_object_set_data_full(GTK_OBJECT(display.window), "button", button,
                           (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show(button);
  gtk_container_add(GTK_CONTAINER(buttonbox), button);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     GTK_SIGNAL_FUNC(DisplayShutdown), NULL);

  gtk_widget_show_all(display.window);
  vbox = NULL;
  label1 = NULL;
  label2 = NULL;
  label3 = NULL;
  buttonbox = NULL;
  button = NULL;
  gtk_main();
} // END CDVDabout()


void CALLBACK CDVDconfigure() {
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  GtkWidget *label3;
  GtkWidget *vbox3;
  GtkWidget *label4;
  GtkWidget *hbuttonbox1;
  GtkWidget *button1;
  GtkWidget *button2;
  int i;
  GList *entrypointer;
  GList *newpointer;

  LoadConf();

  display.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data(GTK_OBJECT(display.window), "Config", display.window);
  gtk_container_set_border_width(GTK_CONTAINER(display.window), 5);
  gtk_window_set_title(GTK_WINDOW(display.window), "Configuring CDVDEFP");
  gtk_window_set_position(GTK_WINDOW(display.window), GTK_WIN_POS_CENTER);
  // gtk_window_set_modal(GTK_WINDOW(display.window), TRUE);
  gtk_window_set_policy(GTK_WINDOW(display.window), FALSE, FALSE, FALSE);

  gtk_signal_connect(GTK_OBJECT(display.window), "destroy",
                     GTK_SIGNAL_FUNC(DisplayShutdown), NULL);

  vbox1 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (display.window), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);

  hbox1 = gtk_hbox_new (FALSE, 5);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 5);

  label3 = gtk_label_new ("CD/DVD Device:");
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_box_pack_start (GTK_BOX (hbox1), label3, FALSE, FALSE, 0);

  display.GtkEntry_Dev = gtk_entry_new ();
  gtk_widget_ref (display.GtkEntry_Dev);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "GtkEntry_Dev", display.GtkEntry_Dev,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_entry_set_text(GTK_ENTRY(display.GtkEntry_Dev), conf.devicename);
  gtk_widget_show (display.GtkEntry_Dev);
  gtk_box_pack_start (GTK_BOX (hbox1), display.GtkEntry_Dev, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (vbox3);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "vbox3", vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox3), 5);

  label4 = gtk_label_new ("Select Read Mode:");
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (vbox3), label4, FALSE, FALSE, 0);

  i = 0;
  entrypointer = NULL;
  newpointer = NULL;
  while(*(ReadModeNames[i]) != 0) i++;
  while(i > 0) {
    i--;
    newpointer = (GList *) malloc(sizeof(GList));
    newpointer->next = entrypointer;
    if(entrypointer != NULL)  entrypointer->prev = newpointer;
    newpointer->data = (gpointer *) ReadModeNames[i];
    entrypointer = newpointer;
    newpointer = NULL;
  } // ENDWHILE- Loading names into a GList for a Combo Box

  display.GtkCombo_Mode = gtk_combo_new ();
  gtk_widget_ref (display.GtkCombo_Mode);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "GtkCombo_Mode", display.GtkCombo_Mode,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_combo_set_popdown_strings(GTK_COMBO(display.GtkCombo_Mode),
                                entrypointer);
  entrypointer = NULL;
  gtk_combo_set_value_in_list(GTK_COMBO(display.GtkCombo_Mode),
                              TRUE,
                              FALSE);
  gtk_widget_show (display.GtkCombo_Mode);
  gtk_box_pack_start (GTK_BOX (vbox3), display.GtkCombo_Mode, FALSE, FALSE, 0);

  display.GtkComboEntry_Mode = GTK_COMBO (display.GtkCombo_Mode)->entry;
  gtk_widget_ref (display.GtkComboEntry_Mode);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "combo_entry1",
                            display.GtkComboEntry_Mode,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (display.GtkComboEntry_Mode);
  gtk_entry_set_editable (GTK_ENTRY (display.GtkComboEntry_Mode), FALSE);
  gtk_entry_set_text(GTK_ENTRY(display.GtkComboEntry_Mode),
                     ReadModeNames[conf.readmode]);

  // vbox3 = gtk_vbox_new (FALSE, 5);
  // gtk_widget_ref (vbox3);
  // gtk_object_set_data_full (GTK_OBJECT (display.window), "vbox4", vbox3,
  //                           (GtkDestroyNotify) gtk_widget_unref);
  // gtk_widget_show (vbox3);
  // gtk_box_pack_start (GTK_BOX (vbox1), vbox3, TRUE, TRUE, 0);
  // gtk_container_set_border_width (GTK_CONTAINER (vbox3), 5);

  // label4 = gtk_label_new ("Select Device's Maximum Spin Speed:");
  // gtk_widget_ref (label4);
  // gtk_object_set_data_full (GTK_OBJECT (display.window), "label5", label4,
  //                           (GtkDestroyNotify) gtk_widget_unref);
  // gtk_widget_show (label4);
  // gtk_box_pack_start (GTK_BOX (vbox3), label4, FALSE, FALSE, 0);

  // i = 0;
  // entrypointer = NULL;
  // newpointer = NULL;
  // while(*(DriveSpeedNames[i]) != 0) i++;
  // while(i > 0) {
  //   i--;
  //   newpointer = (GList *) malloc(sizeof(GList));
  //   newpointer->next = entrypointer;
  //   if(entrypointer != NULL)  entrypointer->prev = newpointer;
  //   newpointer->data = (gpointer *) DriveSpeedNames[i];
  //   entrypointer = newpointer;
  //   newpointer = NULL;
  // } // ENDWHILE- Loading names into a GList for a Combo Box

  // display.GtkCombo_Speed = gtk_combo_new ();
  // gtk_widget_ref (display.GtkCombo_Speed);
  // gtk_object_set_data_full (GTK_OBJECT (display.window), "GtkCombo_Speed",
  //                           display.GtkCombo_Speed,
  //                           (GtkDestroyNotify) gtk_widget_unref);
  // gtk_combo_set_popdown_strings(GTK_COMBO(display.GtkCombo_Speed),
  //                               entrypointer);
  // entrypointer = NULL;
  // gtk_combo_set_value_in_list(GTK_COMBO(display.GtkCombo_Speed),
  //                             TRUE,
  //                             FALSE);
  // gtk_widget_show (display.GtkCombo_Speed);
  // gtk_box_pack_start (GTK_BOX (vbox3), display.GtkCombo_Speed, FALSE, FALSE, 0);

  // display.GtkComboEntry_Speed = GTK_COMBO (display.GtkCombo_Speed)->entry;
  // gtk_widget_ref (display.GtkComboEntry_Speed);
  // gtk_object_set_data_full (GTK_OBJECT (display.window), "combo_entry2",
  //                           display.GtkComboEntry_Speed,
  //                           (GtkDestroyNotify) gtk_widget_unref);
  // gtk_widget_show (display.GtkComboEntry_Speed);
  // gtk_entry_set_editable (GTK_ENTRY (display.GtkComboEntry_Speed), FALSE);
  // gtk_entry_set_text(GTK_ENTRY(display.GtkComboEntry_Speed),
  //                    DriveSpeedNames[conf.drivespeed]);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbuttonbox1, TRUE, TRUE, 0);

  button1 = gtk_button_new_with_label ("Ok");
  gtk_widget_ref (button1);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "button1", button1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button1);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button1);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
                      GTK_SIGNAL_FUNC (DisplaySaveAndShutdown),
                      NULL);
  button2 = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (button2);
  gtk_object_set_data_full (GTK_OBJECT (display.window), "button2", button2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button2);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button2);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
                      GTK_SIGNAL_FUNC (DisplayShutdown),
                      NULL);

  gtk_widget_show_all(display.window);
  vbox1 = NULL;
  hbox1 = NULL;
  label3 = NULL;
  vbox3 = NULL;
  label4 = NULL;
  // combo_entry1 = NULL;
  hbuttonbox1 = NULL;
  button1 = NULL;
  button2 = NULL;
  gtk_main();
} // END CDVDconfigure()
