/*  device.h
 *  Copyright (C) 2002-2005  CDVDlinuz Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DEVICE_H__
#define __DEVICE_H__


#include <time.h> // time_t

#define CDVDdefs
#include "PS2Edefs.h"

#include "CDVD.h"


// #define VERBOSE_FUNCTION_DEVICE


// Configuration Data

typedef struct {
  u8 devicename[256];
  int readmode;
  int drivespeed;
} CDVDconf;
extern CDVDconf conf;

#define DEFAULT_DEVICE "/dev/cdrom"

#define READMODE_NORMAL		0
#define READMODE_THREADED	1
#define READ_MODES		2


// Configuration Functions

void LoadConf();
void SaveConf();


// Device Data

extern int devicehandle;
extern s32 devicecapability; // Need to export?

extern time_t lasttime;
extern s32 traystatus;
extern s32 disctype;
extern u8 tocbuffer[];


// Device Functions

extern void InitDisc();
extern s32 DiscInserted();
extern s32 DeviceOpen();
extern void DeviceClose();
extern s32 DeviceReadTrack(u32 lsn, int mode, u8 *buffer);
extern s32 DeviceBufferOffset();
extern s32 DeviceGetDiskType();
extern s32 DeviceTrayStatus();
extern s32 DeviceTrayOpen();
extern s32 DeviceTrayClose();


#endif /* __DEVICE_H__ */
