#include "syscall.h"

#define	SCREEN_WIDTH	480
#define	SCREEN_HEIGHT	272
#define	SCREEN_PITCH	512

unsigned short *vramtop = 0x44000000;

static int inited;
void g_init(void)
{
	if (inited) return;
	inited = 0;
	sceDisplaySetMode(0,SCREEN_WIDTH,SCREEN_HEIGHT);
	sceDisplaySetFrameBuf((char*)vramtop-0x40000000,SCREEN_PITCH,1,1);
	sceCtrlInit(0);
	sceCtrlSetAnalogMode(1);
}

void g_flip(void)
{
	sceDisplaySetFrameBuf((char*)vramtop-0x40000000,SCREEN_PITCH,1,1);
	vramtop = (unsigned short*)((int)vramtop ^ SCREEN_PITCH*SCREEN_HEIGHT*2);
}

unsigned short* g_vramaddr(int x,int y)
{
	return vramtop + x + y*SCREEN_PITCH;
}


void g_fillrect(int x0,int y0,int width,int height,int color)
{
	int x,y;
	unsigned short *dst = g_vramaddr(x0,y0);

	if (((int)dst&3)==0 && (width&1)==0) {
		color = color | (color<<16);
		for(y=0;y<height;y++) {
			for(x=0;x<width/2;x++)
				((long*)dst)[x] = color;
			dst += SCREEN_PITCH;
		}
	} else {
			for(y=0;y<height;y++) {
			for(x=0;x<width;x++)
				dst[x] = color;
			dst += SCREEN_PITCH;
		}
	}
}

void g_bitblt(int x0,int y0,int width,int height,void *data)
{
	int x,y;
	int *dst = (int*)g_vramaddr(x0,y0);
	int *src = data;

		for(y=0;y<height;y++) {
			for(x=0;x<width/8;x++) {
				dst[0] = src[0];
				dst[1] = src[1];
				dst[2] = src[2];
				dst[3] = src[3];
				src+=4;
				dst+=4;
			}
			dst += SCREEN_PITCH-width;
		}
}

int g_getpad(void)
{
	ctrl_data_t paddata;
	sceCtrlRead(&paddata,1);
	return paddata.buttons;
}

int g_gettick(void)
{
	ctrl_data_t paddata;
	sceCtrlRead(&paddata,1);
	return paddata.frame*1000/60;
}

#include "imageio.h"

#define	RGB(r,g,b)	 ((((r)>>3)<<10) | (((g)>>3)<<5) | ((b)>>3))

static void image_put(int x0,int y0,IMAGE* img)
{
	unsigned short *dst = g_vramaddr(x0,y0);
	unsigned char* src = img->pixels;
	unsigned short pal[256];
	int i;
	for(i=0;i<img->n_palette;i++)
		pal[i] = RGB(img->palette[i].r,img->palette[i].g,img->palette[i].b);

	int x,y;
	for(y=0;y<img->height;y++) {
		for(x=0;x<img->width;x++) {
			dst[x] = pal[*src++];
		}
		dst += SCREEN_PITCH;
	}
}

#include <fcntl.h>

static void nowloading(void)
{
	int fd = open("loading.bmp",O_RDONLY);
	if (fd==-1) {
		dbg_printf("can't load\n");
		return;
	}
	IMAGE* img = load_bmp(fd);
	close(fd);
	if (img) {
		image_put((SCREEN_WIDTH-img->width)/2,(SCREEN_HEIGHT-img->height)/2,img);
		image_free(img);
	}
}

int pgMain(int argc,char *argv)
{
	char path[256];
	strcpy(path,argv);
	char *p = strrchr(path,'/');
	if (p) {
		*p = 0;
		chdir(path);
	}

	g_init();
	nowloading();
	_exit(main(argc,&argv));
}
