/******************************************
**** Fixed Text Layer Drawing Routines ****
******************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "video.h"
#include "../neocd.h"


/* Draw Single FIX character */
INLINE void draw_fix(Uint16 code, Uint16 colour, Uint16 sx, Uint16 sy, Uint16 * palette, char * fix_memory)
{
	Uint8 y;
	Uint32 mydword;
	Uint32 * fix=(Uint32*)&(fix_memory[code<<5]);
	Uint16 * dest =  video_line_ptr[0] + sy*320 + sx;
	Uint16 * paldata=&palette[colour];
	Uint16 col;

	for(y=0;y<8;y++)
	{
		mydword  = *fix++;
		
		col = (mydword>> 0)&0x0f; if (col) dest[0] = paldata[col];
		col = (mydword>> 4)&0x0f; if (col) dest[1] = paldata[col];
		col = (mydword>> 8)&0x0f; if (col) dest[2] = paldata[col];
		col = (mydword>>12)&0x0f; if (col) dest[3] = paldata[col];
		col = (mydword>>16)&0x0f; if (col) dest[4] = paldata[col];
		col = (mydword>>20)&0x0f; if (col) dest[5] = paldata[col];
		col = (mydword>>24)&0x0f; if (col) dest[6] = paldata[col];
		col = (mydword>>28)&0x0f; if (col) dest[7] = paldata[col];
		dest += 320;
	}
}


/* Draw entire Character Foreground */
void video_draw_fix(void)
{
	Uint16 x, y;
	Uint16 code, colour;
	Uint16 * fixarea=(Uint16 *)&video_vidram[0xe004];


	for (y=0; y < 28; y++)
	{
		for (x = 0; x < 40; x++)
		{
			code = fixarea[x << 5];

			colour = (code&0xf000)>>8;
			code  &= 0xfff;

			if(video_fix_usage[code])
				draw_fix(code,colour,(x<<3),(y<<3), video_paletteram_pc, neogeo_fix_memory);
		}
		fixarea++;
	}
}



/* FIX palette for fixputs*/
Uint16 palette[16]={0x0000,0xffff,0x0000,0x0000,
		    0x0000,0x0000,0x0000,0x0000,
		    0xffff,0x0000,0x0000,0x0000,
		    0x0000,0x0000,0x0000,0xffff};

void fixputs( int x, int y, const char * string )
{
	Uint8 i;
	int length=strlen(string);
	
	if ( y>27 ) return;
	
	if ( x+length > 40 ) {
		length=40-x;
	}
	
	if (length<0) return;

	
	y<<=3;
		
	for (i=0; i<length; i++) {	
		draw_fix(toupper(string[i])+0x300,0,(x+i)<<3,y,palette, &neogeo_rom_memory[458752]);
	}
	
	

	return;
}
