#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#define	MAXSTRSLEN	1024;


#define	RGB(r,g,b)	 ((((r)>>3)<<10) | (((g)>>3)<<5) | ((b)>>3))

#define	SCREEN_WIDTH	480
#define	SCREEN_HEIGHT	272
#define	SCREEN_PITCH	512


extern const unsigned char hankaku_font10[];

//extern unsigned short* vramaddr(int x,int y);
static unsigned short* vramaddr(int x,int y)
{
	return (unsigned short*)0x44000000 + x + y*SCREEN_PITCH;
}

void draw_char(unsigned short *dst,int ch)
{
	if (ch<0x20) {
		ch = 0;
	} else if (ch<0x80) {
		ch -= 0x20;
	} else if (ch<0xa0) {
		ch = 0;
	} else {
		ch -= 0x40;
	}

	if (ch==0) return;

	const unsigned char * src = &hankaku_font10[ch*10];
	int x,y;
	for(y=0;y<10;y++) {
		unsigned bits = *src++;
		for(x = 0; x<5; x++) {
			if (bits&1) dst[x] = RGB(255,255,255);
			// else dst[x] = RGB(0,0,0);
			bits>>=1;
//
		}
		dst += SCREEN_PITCH;
	}
}

void draw_str(int x0,int y0,const char* str)
{
	const char *p = str;
	int ch;

	unsigned short *dst = vramaddr(x0,y0);

	while((ch=*p++)!=0) {
		draw_char(dst,ch);
		dst+=5;
	}
}

static void scrollup()
{
	memcpy(vramaddr(0,0),vramaddr(0,10),SCREEN_PITCH*26*10*2);
	memset(vramaddr(0,26*10),0,SCREEN_PITCH*10*2);
}

static int cx,cy;
void dbg_putc(int ch)
{
	unsigned short *dst = vramaddr(cx*5,cy*10);

	if (ch == '\n') {
		cx = 0; cy++;
	} else {
		draw_char(dst,ch);
		cx++;
		if (cx>=96) {
			cx = 0; cy++;
		}
	}
	if (cy>=27) {
		cy = 26; scrollup();
	}
}

int dbg_write(const char* buf,int len)
{
	int i;
	for(i=0;i<len;i++) dbg_putc(buf[i]);
}

void dbg_puts(const char *buf)
{
	const char *p = buf;
	int ch;
	while((ch=*p++)!=0) dbg_putc(ch);
}

int dbg_vprintf(const char *fmt,va_list argp)
{
	char buf[1024];

	int ret = vsprintf(buf,fmt,argp);
	dbg_write(buf,ret);
	return ret;
}

int dbg_printf(const char *fmt,...)
{
	int ret;
	va_list         argp;
	va_start (argp,fmt);
	ret = dbg_vprintf (fmt,argp);
	va_end (argp);

	return ret;
}
