/**************************************
****   INPUT.C  -  Input devices   ****
**************************************/

/*-- Include Files ---------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include "../neocd.h"
#include "../psp/syscall.h"

/*--------------------------------------------------------------------------*/
#define P1UP    0x00000001
#define P1DOWN  0x00000002
#define P1LEFT  0x00000004
#define P1RIGHT 0x00000008
#define P1A     0x00000010
#define P1B     0x00000020
#define P1C     0x00000040
#define P1D     0x00000080

#define P2UP    0x00000100
#define P2DOWN  0x00000200
#define P2LEFT  0x00000400
#define P2RIGHT 0x00000800
#define P2A     0x00001000
#define P2B     0x00002000
#define P2C     0x00004000
#define P2D     0x00008000

#define P1START 0x00010000
#define P1SEL   0x00020000
#define P2START 0x00040000
#define P2SEL   0x00080000

#define SPECIAL 0x01000000


/*--------------------------------------------------------------------------*/
Uint32 keys   =~0;
            
/*--------------------------------------------------------------------------*/
void input_init(void) {
}


void input_shutdown(void) {
}

#if 0
INLINE void specialKey (SDLKey key) {
    switch(key) {
        case SDLK_F1: video_fullscreen_toggle(); break;
        case SDLK_F2: video_mode_toggle(); break;
        case SDLK_F3: incframeskip(); break;
        case SDLK_F4: sound_toggle(); break;
        case SDLK_F12: video_save_snapshot(); break;
        case SDLK_ESCAPE: exit(0); break;
        default:
            break;
    }
}
#endif

void processEvents(void) {
	static int cvtbl[][2] = {
	{CTRL_UP,	P1UP},
	{CTRL_DOWN,	P1DOWN},
	{CTRL_LEFT,	P1LEFT},
	{CTRL_RIGHT,P1RIGHT},
	{CTRL_CROSS,P1A},
	{CTRL_CIRCLE,P1B},
	{CTRL_SQUARE,P1C},
	{CTRL_START,P1START},
	{CTRL_SELECT,P1SEL},
//	{CTRL_RTRIGGER,P1COIN},
	};
	int i;
	int buttons = g_getpad();
	int newkey = 0;
	for(i=0;i<sizeof(cvtbl)/sizeof(cvtbl[0]);i++) {
		if (buttons & cvtbl[i][0]) newkey |= cvtbl[i][1];
	}
	if (buttons & CTRL_LTRIGGER) _exit(0);
	keys = ~newkey;
}
        
/*--------------------------------------------------------------------------*/
unsigned char read_player1(void) {
    return keys&0xff;
}

/*--------------------------------------------------------------------------*/
unsigned char read_player2(void) {
    return (keys>>8)&0xff;
}

/*--------------------------------------------------------------------------*/
unsigned char read_pl12_startsel(void) {
    return (keys>>16)&0x0f;
}


