int ExitCallback()
{
	// Cleanup the games resources etc (if required)
	Settings.Paused = TRUE;
	Memory.SaveSRAM( S9xGetFilename("SRM") );

	if ( g_thread !=-1 ){
		Settings.ThreadSound = FALSE;
		sceKernelWaitThreadEnd( g_thread, NULL );
		sceKernelDeleteThread( g_thread );
	}

	S9xCloseSoundDevice();

	g_bLoop = false;

	// Exit game
	sceKernelExitGame();

	return 0;
}

void PowerCallback(int unknown, int pwrflags)
{
//	Settings.Paused = TRUE;
	Memory.SaveSRAM( S9xGetFilename("SRM") );

	if ( g_thread !=-1 ){
		Settings.ThreadSound = FALSE;
		sceKernelWaitThreadEnd( g_thread, NULL );
		sceKernelDeleteThread( g_thread );
	}

	S9xCloseSoundDevice();

	g_bLoop = false;

	// Combine pwrflags and the above defined masks
}

// Thread to create the callbacks and then begin polling
int CallbackThread(void *arg)
{
	int cbid;

	cbid = sceKernelCreateCallback( "Exit Callback", (void*)ExitCallback );
	sceKernelRegisterExitCallback( cbid );
	cbid = sceKernelCreateCallback( "Power Callback", (void*)PowerCallback );
	sceKernelRegisterPowerCallback( 0, cbid );

	sceKernelPollCallbacks();
}

/* Sets up the callback thread and returns its thread id */
int SetupCallbacks()
{
	int thid = 0;

	thid = sceKernelCreateThread( "update_thread", (threadfunc_t)CallbackThread, 0x11, 0xFA0, 0, 0 );
	if( thid >= 0 ){
		sceKernelStartThread(thid, 0, 0);
	}

	return thid;
}
