/*******************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.
 
  (c) Copyright 1996 - 2002 Gary Henderson (gary.henderson@ntlworld.com) and
                            Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2001 - 2004 John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2004 Brad Jorsch (anomie@users.sourceforge.net),
                            funkyass (funkyass@spam.shaw.ca),
                            Joel Yliluoma (http://iki.fi/bisqwit/)
                            Kris Bleakley (codeviolation@hotmail.com),
                            Matthew Kendora,
                            Nach (n-a-c-h@users.sourceforge.net),
                            Peter Bortas (peter@bortas.org) and
                            zones (kasumitokoduck@yahoo.com)

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003 zsKnight (zsknight@zsnes.com),
                            _Demo_ (_demo_@zsnes.com), and Nach

  C4 C++ code
  (c) Copyright 2003 Brad Jorsch

  DSP-1 emulator code
  (c) Copyright 1998 - 2004 Ivar (ivar@snes9x.com), _Demo_, Gary Henderson,
                            John Weidman, neviksti (neviksti@hotmail.com),
                            Kris Bleakley, Andreas Naive

  DSP-2 emulator code
  (c) Copyright 2003 Kris Bleakley, John Weidman, neviksti, Matthew Kendora, and
                     Lord Nightmare (lord_nightmare@users.sourceforge.net

  OBC1 emulator code
  (c) Copyright 2001 - 2004 zsKnight, pagefault (pagefault@zsnes.com) and
                            Kris Bleakley
  Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code
  (c) Copyright 2002 Matthew Kendora with research by
                     zsKnight, John Weidman, and Dark Force

  S-DD1 C emulator code
  (c) Copyright 2003 Brad Jorsch with research by
                     Andreas Naive and John Weidman
 
  S-RTC C emulator code
  (c) Copyright 2001 John Weidman
  
  ST010 C++ emulator code
  (c) Copyright 2003 Feather, Kris Bleakley, John Weidman and Matthew Kendora

  Super FX x86 assembler emulator code 
  (c) Copyright 1998 - 2003 zsKnight, _Demo_, and pagefault 

  Super FX C emulator code 
  (c) Copyright 1997 - 1999 Ivar, Gary Henderson and John Weidman


  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004 Marcus Comstedt (marcus@mc.pp.se) 

 
  Specific ports contains the works of other authors. See headers in
  individual files.
 
  Snes9x homepage: http://www.snes9x.com
 
  Permission to use, copy, modify and distribute Snes9x in both binary and
  source form, for non-commercial purposes, is hereby granted without fee,
  providing that this license information and copyright notice appear with
  all copies and any derived work.
 
  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software.
 
  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes
  charging money for Snes9x or software derived from Snes9x.
 
  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.
 
  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
*******************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "snes9x.h"
#include "memmap.h"
#include "debug.h"
#include "cpuexec.h"
#include "ppu.h"
#include "snapshot.h"
#include "apu.h"
#include "display.h"
#include "gfx.h"
#include "soundux.h"
#include "spc700.h"
#include "spc7110.h"
#include "psp.h"
#include "font.c"

#define RELEASE

static struct timeval	s_tvStart;
static int				s_iFrame;
static int				s_iFlip = 0;

volatile bool8			g_bLoop = true;
int						g_thread = -1;
static uint8 SoundBuffer[MAX_BUFFER_SIZE + 8129];

#define FRAMESIZE				0x44000			//in byte

//#define SOUND_SAMPLE	1024
#define SOUND_SAMPLE			2048

#define FIXED_POINT				0x10000
#define FIXED_POINT_SHIFT		16
#define FIXED_POINT_REMAINDER	0xffff

#define timercmp(a, b, CMP)	(((a)->tv_sec == (b)->tv_sec) ? ((a)->tv_usec CMP (b)->tv_usec) : ((a)->tv_sec CMP (b)->tv_sec))

static volatile bool8 block_signal = FALSE;
static volatile bool8 block_generate_sound = FALSE;
static volatile bool8 pending_signal = FALSE;

void S9xCloseSoundDevice();

#include "psp2.cpp"

extern "C" {
void *S9xProcessSound (void *);

#define	PIXELSIZE	1				//in short
#define	LINESIZE	512				//in short
#define CMAX_X 60
#define CMAX_Y 38

char *pg_vramtop=(char *)0x04000000;

char *pgGetVramAddr(unsigned long x,unsigned long y)
{
	return pg_vramtop+x*PIXELSIZE*2+y*LINESIZE*2+0x40000000;
}

void pgPutChar(unsigned long x,unsigned long y,unsigned long color,unsigned long bgcolor,unsigned char ch,char drawfg,char drawbg,char mag)
{
	unsigned char *vptr0;		//pointer to vram
	unsigned char *vptr;		//pointer to vram
	const unsigned char *cfont;		//pointer to font
	unsigned long cx,cy;
	unsigned long b;
	char mx,my;

	if (ch>255) return;
	cfont=font+ch*8;
	vptr0=(unsigned char*)pgGetVramAddr(x,y);
	for (cy=0; cy<8; cy++) {
		for (my=0; my<mag; my++) {
			vptr=vptr0;
			b=0x80;
			for (cx=0; cx<8; cx++) {
				for (mx=0; mx<mag; mx++) {
					if ((*cfont&b)!=0) {
						if (drawfg) *(unsigned short *)vptr=color;
						if (drawfg) *(unsigned short *)(vptr + FRAMESIZE)=color;
					} else {
//						if (drawbg) *(unsigned short *)vptr=bgcolor;
						*(unsigned short *)vptr=bgcolor;
						*(unsigned short *)(vptr + FRAMESIZE)=bgcolor;
					}
					vptr+=PIXELSIZE*2;
				}
				b=b>>1;
			}
			vptr0+=LINESIZE*2;
		}
		cfont++;
	}
}

void pgPrint(unsigned long x,unsigned long y,unsigned long color,const char *str)
{
	while (*str!=0 && x<CMAX_X && y<CMAX_Y) {
		pgPutChar(x*8,y*8,color,0,*str,1,0,1);
		str++;
		x++;
		if (x>=CMAX_X) {
			x=0;
			y++;
		}
	}
}

int format_int( char* buf, int value )
{
	char*	org;
	int		div;
	int		val;
	bool	bFirst;
	int		i;

	org    = buf;
	bFirst = true;
	div    = 1000000000;
	for ( i = 0; i < 10; i++ ){
		val = (unsigned)value / div;

		if ( !bFirst || val ){
			*buf++ = val + '0';
			bFirst = false;
		}

		value %= div;
		div   /= 10;
	}

	if ( bFirst ){
		*buf++ = '0';
	}
	*buf = 0;

	return strlen( org );
}

void debug_log( const char* message )
{
#ifndef RELEASE
	static int	sy = 1;

	pgPrint( SNES_WIDTH / 8, sy, 0xffff, message );
	sy++;

	if ( sy >= CMAX_Y ){
		int 	x, y;
		uint16*	dest;

		dest = (uint16*)pgGetVramAddr( SNES_WIDTH, 0 );

		for ( y = 0; y < SCREEN_HEIGHT; y++ ){
			for ( x = 0; x < (SCREEN_WIDTH - SNES_WIDTH); x++ ){
				*dest++ = 0;
			}
			dest += (512 - (SCREEN_WIDTH - SNES_WIDTH));
		}
		sy = 1;
	}
#endif // RELEASE
}

void debug_int( const char* message, int value )
{
	strcpy( String, message );
	format_int( &String[strlen( String )], value );

	debug_log( String );
}

void debug_hex( int value )
{
	int		shift;
	int		val;
	int		i;

	shift = 28;
	for ( i = 0; i < 8; i++ ){
		val = (value >> shift) & 0x0f;
		if ( val < 10 ){
			String[i] = val + '0';
		} else {
			String[i] = val - 10 + 'A';
		}
		shift -= 4;
	}
	String[i] = 0;

	debug_log( String );
}

static struct timeval s_analyze;
void StartAnalyze()
{
	sceKernelLibcGettimeofday( &s_analyze, 0 );
}

void StopAnalyze()
{
	struct timeval now;
	int		diff;

	sceKernelLibcGettimeofday( &now, 0 );

	diff  = (now.tv_sec - s_analyze.tv_sec) * 1000000 + now.tv_usec - s_analyze.tv_usec;

	debug_int( "time:", diff );
}
};

//
// C++ Language
//
#ifndef OPTI
void JustifierButtons(uint32&)
{
}

bool JustifierOffscreen()
{
	return false;
}
#endif // OPTI

void S9xInitCheatData()
{
}

void S9xApplyCheat( uint32 which1 )
{
}

void S9xApplyCheats()
{
}

bool8 S9xLoadCheatFile( const char *filename )
{
	return FALSE;
}

void S9xAutoSaveSRAM()
{
//	Memory.SaveSRAM (S9xGetSRAMFilename ());
}

bool8 S9xOpenSoundDevice( int mode, bool8 stereo, int buffer_size )
{
	so.mute_sound  = TRUE;
/*
int		pos;

pos = format_int( buf, buffer_size );
strcat( &buf[pos], "BufSize" );

debug_log( buf );
*/
	if ( buffer_size <= 0 ){
		return FALSE;
	}

#ifndef OPTI
	so.sound_switch = 255;
	so.stereo       = TRUE;
	so.sixteen_bit  = TRUE;
#endif // OPTI
	so.buffer_size  = buffer_size;
	so.encoded      = FALSE;

	// Initialize channel and allocate buffer
	so.sound_fd = sceAudio_3( -1, buffer_size, 0 );
	if ( so.sound_fd < 0 ){
		return FALSE;
	}

#ifdef OPTI
	so.buffer_size *= 2;
	so.buffer_size *= 2;
#else
	if ( so.stereo ){
		so.buffer_size *= 2;
	}
	if ( so.sixteen_bit ){
		so.buffer_size *= 2;
	}
#endif // OPTI
	if ( so.buffer_size > MAX_BUFFER_SIZE ){
		so.buffer_size = MAX_BUFFER_SIZE;
	}

	S9xSetPlaybackRate( 44100 );

	so.mute_sound  = FALSE;

	return TRUE;
}

void S9xCloseSoundDevice()
{
	if ( so.sound_fd >= 0 ){
		sceAudio_4( so.sound_fd );
		so.sound_fd = -1;
	}
}

//
// C Language
//
extern "C" {
void S9xMessage( int type, int number, const char* message )
{
	debug_log( message );
	S9xSetInfoString( message );
}

void S9xMovieUpdate ()
{
}


bool8 S9xReadSuperScopePosition (int &x, int &y, uint32 &buttons)
{
	return FALSE;
}

bool8 S9xReadMousePosition (int which, int &x, int &y, uint32 &buttons)
{
	return FALSE;
}

void S9xLoadSDD1Data()
{
}

uint32 S9xReadJoypad( int which1 )
{
	ctrl_data_t	ctl;
	uint32		ret;

	if ( which1 ){
		return 0;
	}

	sceCtrlRead( &ctl, 1 );

	ret = ((ctl.buttons & CTRL_UP)       << 7) |	// 
		  ((ctl.buttons & CTRL_DOWN)     << 4) |	// 
		  ((ctl.buttons & CTRL_LEFT)     << 2) |	// 
		  ((ctl.buttons & CTRL_RIGHT)    << 3) |	// 
		  ((ctl.buttons & CTRL_CIRCLE)   >> 6) |	//  -> `
		  ((ctl.buttons & CTRL_CROSS)    << 1) |	// ~ -> a
		  ((ctl.buttons & CTRL_SQUARE)   >> 1) |	//  -> x
		  ((ctl.buttons & CTRL_TRIANGLE) >> 6) |	//  -> w
		  ((ctl.buttons & CTRL_LTRIGGER) >> 3) |	// k
		  ((ctl.buttons & CTRL_RTRIGGER) >> 5) |	// q
		  ((ctl.buttons & CTRL_START)    << 9) |	// rs`qs
		  ((ctl.buttons & CTRL_SELECT)   << 13);	// rdkdbs
/*
	     X		@
	Y @ A		@
	  B 			@~

SNES_TR			0x0010
SNES_TL			0x0020
SNES_X			0x0040
SNES_A			0x0080
SNES_RIGHT		0x0100
SNES_LEFT		0x0200
SNES_DOWN		0x0400
SNES_UP			0x0800
SNES_START		0x1000
SNES_SELECT		0x2000
SNES_Y			0x4000
SNES_B			0x8000

PSP_SQUARE		0x8000
PSP_TRIANGLE	0x1000
PSP_CIRCLE		0x2000
PSP_CROSS		0x4000
PSP_UP			0x0010
PSP_DOWN		0x0040
PSP_LEFT		0x0080
PSP_RIGHT		0x0020
PSP_START		0x0008
PSP_SELECT		0x0001
PSP_LTRIGGER	0x0100
PSP_RTRIGGER	0x0200
*/

	return ret | 0x80000000;
}

void S9xSetPalette()
{
}

bool8 S9xSPCDump( const char *filename )
{
	return FALSE;
}

#define MAXVOLUME	0x8000

void S9xGenerateSound()
{
    /* Linux and Sun versions */
    
#ifdef OPTI
    int bytes_so_far = so.samples_mixed_so_far << 1;
#else
    int bytes_so_far = so.sixteen_bit ? (so.samples_mixed_so_far << 1) :
				        so.samples_mixed_so_far;
#endif // OPTI
    if (Settings.SoundSync == 2)
    {
	// Assumes sound is signal driven
//	while (so.samples_mixed_so_far >= so.buffer_size && !so.mute_sound)
//	    pause ();
    }
    else
    if (bytes_so_far >= so.buffer_size)
	return;

    if (Settings.ThreadSound)
    {
//	if (block_generate_sound || pthread_mutex_trylock (&mutex))
	if (block_generate_sound)
	    return;
    }

    block_signal = TRUE;

    so.err_counter += so.err_rate;
    if (so.err_counter >= FIXED_POINT)
    {
        int sample_count = so.err_counter >> FIXED_POINT_SHIFT;
	int byte_offset;
	int byte_count;

        so.err_counter &= FIXED_POINT_REMAINDER;
#ifndef OPTI
	if (so.stereo)
#endif // OPTI
	    sample_count <<= 1;
	byte_offset = bytes_so_far + so.play_position;
	    
	do
	{
	    int sc = sample_count;
	    byte_count = sample_count;
#ifndef OPTI
	    if (so.sixteen_bit)
#endif // OPTI
		byte_count <<= 1;
	    
	    if ((byte_offset & SOUND_BUFFER_SIZE_MASK) + byte_count > SOUND_BUFFER_SIZE)
	    {
		sc = SOUND_BUFFER_SIZE - (byte_offset & SOUND_BUFFER_SIZE_MASK);
		byte_count = sc;
#ifndef OPTI
		if (so.sixteen_bit)
#endif // OPTI
		    sc >>= 1;
	    }
	    if (bytes_so_far + byte_count > so.buffer_size)
	    {
		byte_count = so.buffer_size - bytes_so_far;
		if (byte_count == 0)
		    break;
		sc = byte_count;
#ifndef OPTI
		if (so.sixteen_bit)
#endif // OPTI
		    sc >>= 1;
	    }
	    S9xMixSamplesO (SoundBuffer, sc,
			    byte_offset & SOUND_BUFFER_SIZE_MASK);
	    so.samples_mixed_so_far += sc;
	    sample_count -= sc;
#ifdef OPTI
	    bytes_so_far = so.samples_mixed_so_far << 1;
#else
	    bytes_so_far = so.sixteen_bit ? (so.samples_mixed_so_far << 1) :
	 	           so.samples_mixed_so_far;
#endif // OPTI
	    byte_offset += byte_count;
	} while (sample_count > 0);
    }
    block_signal = FALSE;

    if (Settings.ThreadSound)
		;
//	pthread_mutex_unlock (&mutex);
    else
    if (pending_signal)
    {
	S9xProcessSound (NULL);
	pending_signal = FALSE;
    }
}

void S9xExit()
{
//	Memory.SaveSRAM (S9xGetSRAMFilename ());
	Memory.Deinit();

//	exit (0);
}

void CopyAudio( char* buf, int len )
{
	static int	pos  = 0;
	static char	tmp[SOUND_SAMPLE * 2 * 2];
	int		i;

	for ( i = 0; i < len; i++ ){
		tmp[pos++] = buf[i];
		if ( pos >= (SOUND_SAMPLE * 2 * 2) ){
			sceAudio_2( so.sound_fd, MAXVOLUME, MAXVOLUME, (char*)tmp );
			pos = 0;
		}
	}
}

void *S9xProcessSound (void *)
{
debug_log( "Thread start!" );
    /* Linux and Sun versions */
    
    /* If threads in use, this is to loop indefinitely */
    /* If not, this will be called by timer */
    
    do
    {
//		sceDisplayWaitVblankStart();

    /* Number of samples to generate now */
    int sample_count = so.buffer_size;
    
#ifndef OPTI
    if (so.sixteen_bit)
#endif // OPTI
    {
        /* to prevent running out of buffer space,
         * create less samples
         */
	sample_count >>= 1;
    }
 
    if (Settings.ThreadSound)
		;
//	pthread_mutex_lock (&mutex);
    else
    if (block_signal)
    {
	pending_signal = TRUE;
	return (NULL);
    }

    block_generate_sound = TRUE;

    /* If we need more audio samples */
    if (so.samples_mixed_so_far < sample_count)
    {
	/* Where to put the samples to */
#ifdef OPTI
	unsigned byte_offset = so.play_position + (so.samples_mixed_so_far << 1);
#else
	unsigned byte_offset = so.play_position + 
		      (so.sixteen_bit ? (so.samples_mixed_so_far << 1)
				      : so.samples_mixed_so_far);
#endif // OPTI
//printf ("%d:", sample_count - so.samples_mixed_so_far); fflush (stdout);
	if (Settings.SoundSync == 2)
	{
	    /*memset (Buf + (byte_offset & SOUND_BUFFER_SIZE_MASK), 0,
		    sample_count - so.samples_mixed_so_far);*/
	}
	else
	{
	    /* Mix the missing samples */
	    S9xMixSamplesO (SoundBuffer, sample_count - so.samples_mixed_so_far,
			    byte_offset & SOUND_BUFFER_SIZE_MASK);
        }
	so.samples_mixed_so_far = sample_count;
    }
    
//    if (!so.mute_sound)
    {
	unsigned bytes_to_write = sample_count;
#ifdef OPTI
	bytes_to_write <<= 1;
#else
	if(so.sixteen_bit) bytes_to_write <<= 1;
#endif // OPTI

	unsigned byte_offset = so.play_position;
	so.play_position += bytes_to_write;
	so.play_position &= SOUND_BUFFER_SIZE_MASK; /* wrap to beginning */

//	if (Settings.ThreadSound)
//	    pthread_mutex_unlock (&mutex);
	block_generate_sound = FALSE;

	/* Feed the samples to the soundcard until nothing is left */
	for(;;)
	{
	    int I = bytes_to_write;
	    if (byte_offset + I > SOUND_BUFFER_SIZE)
	    {
	        I = SOUND_BUFFER_SIZE - byte_offset;
	    }
	    if(I == 0) break;
	    
//            I = write (so.sound_fd, (char *) Buf + byte_offset, I);
#if 0
			CopyAudio( (char*)SoundBuffer + byte_offset, I );
#else
			sceAudio_2( so.sound_fd, MAXVOLUME, MAXVOLUME, (char*)SoundBuffer + byte_offset );
//debug_log( "sceAudio_2" );
#endif
            if (I > 0)
            {
                bytes_to_write -= I;
                byte_offset += I;
                byte_offset &= SOUND_BUFFER_SIZE_MASK; /* wrap */
            }
            /* give up if an unrecoverable error happened */
//            if(I < 0 && errno != EINTR) break;
	}
	/* All data sent. */
    }

    so.samples_mixed_so_far -= sample_count;

    } while (Settings.ThreadSound);
debug_log( "Thread end" );

    return (NULL);
}

void InitTimer()
{
	debug_log( "Create Thread" );
//	g_thread = sceKernelCreateThread( "sound thread", (threadfunc_t)S9xProcessSound, 0x12, 0x10000, 0, NULL );
//	g_thread = sceKernelCreateThread( "sound thread", (threadfunc_t)S9xProcessSound, 0x12, 0x80000, 0, NULL );
	g_thread = sceKernelCreateThread( "sound thread", (threadfunc_t)S9xProcessSound, 0x8, 0x40000, 0, NULL );
	if ( g_thread < 0 ){
		debug_log( "Thread failed" );
		return;
	}

	sceKernelStartThread( g_thread, 0, 0 );

	debug_log( "Thread ok" );
}

void S9xSyncSpeed()
{
#ifndef RELEASE
	IPPU.FrameSkip = 0;
	IPPU.SkippedFrames = 0;
	IPPU.RenderThisFrame = TRUE;

	return;
#else
	if ( Settings.TurboMode ){
		if( ++IPPU.FrameSkip >= Settings.TurboSkipFrames ){
			IPPU.FrameSkip = 0;
			IPPU.SkippedFrames = 0;
			IPPU.RenderThisFrame = TRUE;
		} else {
			++IPPU.SkippedFrames;
			IPPU.RenderThisFrame = FALSE;
		}
		return;
	}

	static struct timeval next1 = { 0, 0 };
	struct timeval now;

	CHECK_SOUND(); S9xProcessEvents( FALSE );

	sceKernelLibcGettimeofday( &now, 0 );
	if ( next1.tv_sec == 0 ){
		next1 = now;
		++next1.tv_usec;
	}

#if 1
	unsigned limit = Settings.SkipFrames;

	IPPU.RenderThisFrame = ++IPPU.SkippedFrames >= limit;
	if ( IPPU.RenderThisFrame ){
		IPPU.SkippedFrames = 0;
	}
#else
#if 0
	if ( timercmp( &next1, &now, >= ) ){
 		if ( IPPU.SkippedFrames == 0 ){
			while ( timercmp( &next1, &now, > ) ){
				sceKernelLibcGettimeofday( &now, 0 );
			}
		}
		IPPU.RenderThisFrame = TRUE;
		IPPU.SkippedFrames = 0;
	} else {
		if ( IPPU.SkippedFrames < Settings.AutoMaxSkipFrames ){
			IPPU.SkippedFrames++;
			IPPU.RenderThisFrame = FALSE;
		} else {
			IPPU.RenderThisFrame = TRUE;
			IPPU.SkippedFrames = 0;
			next1 = now;
		}
	}
#else
	unsigned limit = Settings.SkipFrames == AUTO_FRAMERATE ? (timercmp( &next1, &now, < ) ? Settings.AutoMaxSkipFrames : 1) : Settings.SkipFrames;

	IPPU.RenderThisFrame = ++IPPU.SkippedFrames >= limit;
	if ( IPPU.RenderThisFrame ){
		IPPU.SkippedFrames = 0;
	} else {
		if ( timercmp( &next1, &now, < ) ){
			unsigned int lag;
			lag = (now.tv_sec - next1.tv_sec) * 1000000 + now.tv_usec - next1.tv_usec;
			if ( lag >= 1000000 ){
				next1 = now;
			}
		}
	}

	while ( timercmp( &next1, &now, > ) ){
/*
		unsigned timeleft;

		timeleft = (next1.tv_sec - now.tv_sec) * 1000000 + next1.tv_usec - now.tv_usec;
		usleep( timeleft );

		CHECK_SOUND(); S9xProcessEvents( FALSE );
*/
		sceKernelLibcGettimeofday( &now, 0 );
	}
#endif
	next1.tv_usec += Settings.FrameTime;
	if ( next1.tv_usec >= 1000000 ){
		next1.tv_sec += next1.tv_usec / 1000000;
		next1.tv_usec %= 1000000;
	}
#endif

#endif // RELEASE
}


const char *S9xGetFilename( const char *e )
{
	static char filename [_MAX_PATH + 1];
	char drive [_MAX_DRIVE + 1];
	char dir [_MAX_DIR + 1];
	char fname [_MAX_FNAME + 1];
	char ext [_MAX_EXT + 1];

	_splitpath (Memory.ROMFilename, drive, dir, fname, ext);
	_makepath (filename, drive, dir, fname, e);

	return (filename);
}

bool8 S9xInitUpdate()
{
	return TRUE;
}

#if 1
void S9xPutImage( int width, int height )
{
	uint32*	dest;
	uint32* pBuffer;
	int		x;

	pBuffer = (uint32*)GFX.Screen;
#ifdef RELEASE
	dest    = (uint32*)pgGetVramAddr( (SCREEN_WIDTH - SNES_WIDTH) >> 1, (SCREEN_HEIGHT - height) >> 1 );
#else
	dest    = (uint32*)pgGetVramAddr( 0, 0 );
#endif // RELEASE

	while ( height-- ){
		x = 16;
		while ( x-- ){
			uint32 data;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
			*dest++ = *pBuffer++;
		}
		dest += (512 - SNES_WIDTH) / 2;
	}
}
#else
void S9xPutImage( int width, int height )
{
	int 	x, y;
	uint16*	src;
	uint16*	dest;

	src  = (uint16*)GFX.Screen;
//	dest = (uint16*)(VRAM_ADDR + 0x40000000);
	dest = (uint16*)pgGetVramAddr( 0, 0 );

//	pspDisplayWaitVblankStart();

	for ( y = 0; y < SNES_HEIGHT_EXTENDED; y++ ){
		for ( x = 0; x < SNES_WIDTH; x++ ){
			*dest++ = *src++;
		}
		dest += (512 - SNES_WIDTH);
	}
}
#endif

#ifdef OPTI
bool8 S9xDeinitUpdate (int Width, int Height)
#else
bool8 S9xDeinitUpdate (int Width, int Height, bool8 sixteen_bit)
#endif // OPTI
{
//	S9xPutImage( Width, Height );
#ifdef RELEASE
	GFX.Screen = (uint8*)pgGetVramAddr( (SCREEN_WIDTH - SNES_WIDTH) >> 1, (SCREEN_HEIGHT - Height) >> 1 );
#else
	GFX.Screen = (uint8*)pgGetVramAddr( 0, 0 );
#endif // RELEASE
	s_iFlip = (s_iFlip + 1) & 1;
	if ( s_iFlip ){
		GFX.Screen += FRAMESIZE;
	}
	sceDisplaySetFrameBuf( pg_vramtop + (s_iFlip ? 0 : FRAMESIZE ), LINESIZE, PIXELSIZE, 0 );

#if 1
	char			buf[128];
	struct timeval	now;
	unsigned int	diff;

	s_iFrame++;
	sceKernelLibcGettimeofday( &now, 0 );

	diff  = (now.tv_sec - s_tvStart.tv_sec) * 1000000 + now.tv_usec - s_tvStart.tv_usec;
	diff /= 1000000;
	if ( diff ){
		buf[0] = ((s_iFrame / diff) / 10) + '0';
		buf[1] = ((s_iFrame / diff) % 10) + '0';
		buf[2] = 'F';
		buf[3] = 'P';
		buf[4] = 'S';
		buf[5] = '\0';

		pgPrint( CMAX_X - 6, 0, 0xffff, buf );

		s_tvStart = now;
		s_iFrame  = 0;

#ifdef RELEASE
		ctrl_data_t	ctl;
		int			up;
		int			iSkipFrames = Settings.SkipFrames;

		sceCtrlRead( &ctl, 1 );
		up = (*(int*)ctl.analog) >> 8;

		if ( up < 0x60 ){
			if ( Settings.SkipFrames > 0 ){
				Settings.SkipFrames--;
			}
		} else if ( up > 0xA0 ){
			if ( Settings.SkipFrames < 10 ){
				Settings.SkipFrames++;
			}
		}

		if ( iSkipFrames != Settings.SkipFrames ){
			iSkipFrames = Settings.SkipFrames;
			strcpy( String, "FrameSkip:" );
			if ( iSkipFrames < 10 ){
				String[10] = (iSkipFrames % 10) + '0';
				String[11] = 0;
			} else {
				String[10] = (iSkipFrames / 10) + '0';
				String[11] = (iSkipFrames % 10) + '0';
				String[12] = 0;
			}
			S9xSetInfoString( String );
		}

#endif // RELEASE
	}

#endif

	return TRUE;
}

static uint8	GFX_Screen[SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2];
static uint8	GFX_SubScreen[SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2];
static uint8	GFX_ZBuffer[SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2];
static uint8	GFX_SubZBuffer[SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2];

void S9xInitDisplay( int argc, char** argv )
{
//	Settings.Transparency = TRUE;
#ifndef OPTI
	Settings.SixteenBit   = TRUE;
#endif // OPTI
	Settings.SupportHiRes = 0; //interpolate;

	memset( GFX_Screen,     0, SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2 );
	memset( GFX_SubScreen,  0, SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2 );
	memset( GFX_ZBuffer,    0, SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2 );
	memset( GFX_SubZBuffer, 0, SNES_WIDTH * SNES_HEIGHT_EXTENDED * 2 );

//	GFX.Pitch      = IMAGE_WIDTH * 2;
//	GFX.Screen     = (uint8*)GFX_Screen;
	GFX.Pitch      = 512 * 2;
#ifdef RELEASE
	GFX.Screen     = (uint8*)pgGetVramAddr( (SCREEN_WIDTH - SNES_WIDTH) >> 1, (SCREEN_HEIGHT - SNES_HEIGHT_EXTENDED) >> 1 ) + FRAMESIZE;
#else
	GFX.Screen     = (uint8*)pgGetVramAddr( 0, 0 ) + FRAMESIZE;
#endif // RELEASE
	GFX.SubScreen  = (uint8*)GFX_SubScreen;
	GFX.ZBuffer    = (uint8*)GFX_ZBuffer;
	GFX.SubZBuffer = (uint8*)GFX_SubZBuffer;
}

void S9xInitInputDevices()
{
}

void S9xProcessEvents( bool8 block )
{
}

int xmain(int argc, char *argv)
{
	debug_log( argv );

	sceDisplaySetMode( 0, SCREEN_WIDTH, SCREEN_HEIGHT );
//	sceDisplaySetFrameBuf( 0, 0, 0, 1 );
	sceDisplaySetFrameBuf( (char*)VRAM_ADDR, 512, 1, 1 );

	SetupCallbacks();

	sceCtrlInit( 0 );
#ifdef RELEASE
	sceCtrlSetAnalogMode( 1 );
#else
	sceCtrlSetAnalogMode( 0 );
#endif // RELEASE

	so.sound_fd = -1;

	debug_log( "Snse9x for PSP Ver.0.02" );

	memset( &Settings, 0, sizeof( Settings ) );

#ifndef OPTI
	Settings.JoystickEnabled = FALSE;
#endif // OPTI
	Settings.SoundPlaybackRate = 4;
#ifndef OPTI
	Settings.Stereo = TRUE;
#endif // OPTI
	Settings.SoundBufferSize = 0;
	Settings.CyclesPercentage = 100;
	Settings.DisableSoundEcho = FALSE;
	Settings.APUEnabled = Settings.NextAPUEnabled = FALSE;
	Settings.H_Max = SNES_CYCLES_PER_SCANLINE;
	Settings.SkipFrames = AUTO_FRAMERATE;
	Settings.ShutdownMaster = TRUE;
	Settings.FrameTimePAL = 20000;
	Settings.FrameTimeNTSC = 16667;
	Settings.FrameTime = Settings.FrameTimeNTSC;
#ifndef OPTI
	Settings.StretchScreenshots = 1;
#endif // OPTI
	Settings.DisableMasterVolume = FALSE;
#ifndef OPTI
	Settings.Mouse = TRUE;
	Settings.SuperScope = TRUE;
	Settings.MultiPlayer5 = TRUE;
	Settings.ControllerOption = SNES_JOYPAD;
#endif // OPTI
	Settings.Transparency = FALSE;
#ifndef OPTI
	Settings.SixteenBit = FALSE;
	Settings.NetPlay = FALSE;
	Settings.ServerName [0] = 0;
	Settings.AutoSaveDelay = 30;
	Settings.ApplyCheats = TRUE;
#endif // OPTI
	Settings.SupportHiRes = FALSE;
	Settings.ThreadSound = FALSE;
	Settings.TurboMode = FALSE;
	Settings.TurboSkipFrames = 40;
#ifndef OPTI
	Settings.StretchScreenshots = 1;
#endif // OPTI
//Settings.DisplayFrameRate = TRUE;
Settings.SkipFrames = 0;
//Settings.SkipFrames = AUTO_FRAMERATE;
//Settings.AutoMaxSkipFrames = 10;
//Settings.SoundBufferSize = 44100 * 2 * 2 / 1000;
Settings.SoundBufferSize = SOUND_SAMPLE;
//Settings.SoundSync = 1;
Settings.ThreadSound = TRUE;
Settings.APUEnabled = Settings.NextAPUEnabled = TRUE;

#ifndef OPTI
	Settings.Transparency = Settings.ForceTransparency;
	if ( Settings.ForceNoTransparency ){
		Settings.Transparency = FALSE;
	}

	if ( Settings.Transparency ){
//		Settings.SixteenBit = TRUE;
	}
#endif // OPTI

	Settings.HBlankStart = (256 * Settings.H_Max) / SNES_HCOUNTER_MAX;

	if ( !Memory.Init() || !S9xInitAPU() ){
		return -1;
	}

#ifdef OPTI
	S9xInitSound( Settings.SoundPlaybackRate, 1, Settings.SoundBufferSize );
#else
	S9xInitSound( Settings.SoundPlaybackRate, Settings.Stereo, Settings.SoundBufferSize );
#endif // OPTI

	if ( !Settings.APUEnabled ){
		S9xSetSoundMute( TRUE );
	}

	uint32 saved_flags = CPU.Flags;

//	S9xSetRenderPixelFormat( RGB565 );

#if 1
	if ( !Memory.LoadROM( "fatms0:/PSP/GAME/SNES9X/ROM.SMC" ) ){
		debug_log( "LoadROM NG" );
		return -1;
	}
	debug_log( S9xGetFilename("SRM") );
	Memory.LoadSRAM( S9xGetFilename( "SRM" ) );
#else
	if ( rom_filename ){
		if ( !Memory.LoadROM (rom_filename ) ){
			char dir [_MAX_DIR + 1];
			char drive [_MAX_DRIVE + 1];
			char name [_MAX_FNAME + 1];
			char ext [_MAX_EXT + 1];
			char fname [_MAX_PATH + 1];

			_splitpath (rom_filename, drive, dir, name, ext);
			_makepath (fname, drive, dir, name, ext);

			strcpy (fname, S9xGetROMDirectory ());
			strcat (fname, SLASH_STR);
			strcat (fname, name);
			if ( ext[0] ){
				strcat (fname, ".");
				strcat (fname, ext);
			}
			_splitpath (fname, drive, dir, name, ext);
			_makepath (fname, drive, dir, name, ext);
			if ( !Memory.LoadROM (fname ) ){
				fprintf (stderr, "Error opening: %s\n", rom_filename);
				exit (1);
			}
		}
		Memory.LoadSRAM (S9xGetFilename (".srm"));
		S9xLoadCheatFile (S9xGetFilename (".cht"));
	} else {
		S9xReset();
		Settings.Paused |= 2;
	}
#endif
	CPU.Flags = saved_flags;

	S9xInitInputDevices();

	S9xInitDisplay( 0, 0 );
	if ( !S9xGraphicsInit() ){
		return -1;
	}

//	S9xTextMode();

/*
	if (snapshot_filename)
	{
	int Flags = CPU.Flags & (DEBUG_MODE_FLAG | TRACE_FLAG);
	if (!S9xLoadSnapshot (snapshot_filename))
		exit (1);
	CPU.Flags |= Flags;
	}
*/
//	S9xGraphicsMode();

//	sprintf (String, "\"%s\" %s: %s", Memory.ROMName, TITLE, VERSION);
//	S9xSetTitle( String );

	InitTimer();
	if ( !Settings.APUEnabled ){
		S9xSetSoundMute( FALSE );
	}

	s_iFrame = 0;
	sceKernelLibcGettimeofday( &s_tvStart, 0 );

	S9xSetSoundMute( TRUE );

	while ( g_bLoop ){
#if 1
		if ( !Settings.Paused ){
			S9xMainLoop();
		}
#else
		if ( !Settings.Paused ){
			S9xMainLoop();
		}

		if ( Settings.Paused ){
			S9xSetSoundMute( TRUE );
		}

		if ( Settings.Paused ){
			S9xProcessEvents( FALSE );
//			usleep(100000);
		}

		S9xProcessEvents( FALSE );
	
		if ( !Settings.Paused ){
			S9xSetSoundMute( FALSE );
		}
#endif
	}

	return 0;
}


};

/*
WIP
E҂葬Ȃ
ETEhYɂȂ
Eʂ̃Z^O
Et[XLbv(ԓƒx̂Ŗ{̃XLbv̂)
ESRAMZ[uL
Et[XLbvɃnOAbvs̏C
Eʋs̏C

http://www.geocities.jp/pasofami77/chip/sfcchip
*/
