/* FCE Ultra - NES/Famicom Emulator
 * 
 * Copyright notice for this file:
 *  Copyright (C) 2003 Xodnizel
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or   
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

static void FastRefreshLine(int firsttile, uint8 *target)
{
        uint32 smorkus=RefreshAddr;

        #define RefreshAddr smorkus
        uint32 vofs;
        int X1;
	int XOC;

        register uint8 *P;
        static int norecurse=0; /*  Prevent recursion:
                                    PPU_hook() functions can call
                                    mirroring/chr bank switching functions,
                                    which call FCEUPPU_LineUpdate, which call this
                                    function. */
        if(norecurse) return;

	target += firsttile << 3;
	P = target;

        vofs=((PPU[0]&0x10)<<8) | ((RefreshAddr>>12)&7);
        
        if(!ScreenON && !SpriteON)
        {
         memset(target,PALRAM[PALBG],(32 - firsttile)<<3);
         return;
        }

        if(!RCBGOn)
	{
	 memset(target, PALRAM[0] | 0x40, (32 - firsttile)<<3);
	 return;
	}
	/* Priority bits, needed for sprite emulation. */
        PALRAMCache[0x0]=PALRAMCache[0x4]=PALRAMCache[0x8]=PALRAMCache[0xC]=PALRAM[0] | 64;

        /* This high-level graphics MMC5 emulation code was written
           for MMC5 carts in "CL" mode.  It's probably not totally
           correct for carts in "SL" mode.
        */      

	XOC = 16 - XOffset;

	#define PPUT_MMC5
        if(MMC5Hack && geniestage!=1)
        {
         if(MMC5HackCHRMode==0 && (MMC5HackSPMode&0x80))
         {
          for(X1=firsttile;X1<32;X1++)
          {
           if((tochange<=0 && MMC5HackSPMode&0x40) || (tochange>0 && !(MMC5HackSPMode&0x40)))
           {
            #define PPUT_MMC5SP
            #include "fast-pputile.h"
 	    #undef PPUT_MMC5SP
	   }
	   else
	   {
	    #include "fast-pputile.h"	    
	   }
	   tochange--;
	   xs++;
	  }
	 }
         else if(MMC5HackCHRMode==1 && (MMC5HackSPMode&0x80))
	 {
          uint8 ys;
          ys=((scanline>>3)+MMC5HackSPScroll)&0x1F;
          if(ys>=0x1E) ys-=0x1E;

          #define PPUT_MMC5SP
	  #define PPUT_MMC5CHR1
          for(X1=firsttile;X1<32;X1++)
          {
           #include "fast-pputile.h"
          }
	  #undef PPUT_MMC5CHR1
          #undef PPUT_MMC5SP
	 }
         else if(MMC5HackCHRMode==1)
	 {
          #define PPUT_MMC5CHR1
          for(X1=firsttile;X1<32;X1++)
          {
           #include "fast-pputile.h"
          }
          #undef PPUT_MMC5CHR1
	 }
         else
	 {
	  for(X1=firsttile;X1<32;X1++)
	  {
	   #include "fast-pputile.h"
	  }
	 }
	}
	#undef PPUT_MMC5
	else if(PPU_hook)
	{
	 norecurse=1;
	 #define PPUT_HOOK
         for(X1=firsttile;X1<32;X1++)
         {
          #include "fast-pputile.h"
         }
	 #undef PPUT_HOOK
	 norecurse=0;
	}
	else
	{
         for(X1=firsttile;X1<32;X1++)
         {
	  #include "fast-pputile.h"
         }
	}

        #undef vofs
        #undef RefreshAddr

        RefreshAddr=smorkus;
        if(!firsttile && !(PPU[1]&2)) 
	 memset(target, PALRAM[0] | 0x40, 8);
}

static void FastLineEffects(int firsttile, uint8 *target)
{
 int x;

 if(ScreenON || SpriteON)
 {
  if(PPU[1]&0x01)
  {
   for(x=63;x>=0;x--)
   *(uint32 *)&target[x<<2]=(*(uint32*)&target[x<<2])&0x30303030;
  }
 }
 if((PPU[1]>>5)==0x7)
 {
  for(x=63;x>=0;x--)
   *(uint32 *)&target[x<<2]=((*(uint32*)&target[x<<2])&0x3f3f3f3f)|0xc0c0c0c0;
 }
 else if(PPU[1]&0xE0)
  for(x=63;x>=0;x--)
   *(uint32 *)&target[x<<2]=(*(uint32*)&target[x<<2])|0x40404040;
 else
  for(x=63;x>=0;x--)
   *(uint32 *)&target[x<<2]=((*(uint32*)&target[x<<2])&0x3f3f3f3f)|0x80808080;
}

static void FastCopySprites(int firsttile, uint8 *target)
{
      uint8 n=((PPU[1]&4)^4)<<1;
      uint8 *P=target;

      if(!spork) return;
      spork=0;

      if(sphitx != 0x100)
      {
       int meep, maxmeep, firstmeep;
       
       firstmeep = sphitx;
       maxmeep = sphitx + 8;
   
       if(firstmeep < (firsttile << 3)) firstmeep = firsttile << 3;
       if(maxmeep > 255) maxmeep = 255;	// Don't go over 256 pixels(the screen isn't that wide!), and don't check on the 255th column(NES PPU bug).

       for(meep = firstmeep; meep < maxmeep; meep++)
       {
        if((sphitdata & (0x80 >> (meep - sphitx)))&& !(target[meep]&64))
        {
        //printf("Hit: %d\n",scanline);
         PPU_status |= 0x40;
        }
       }
      }

      if(rendis & 1) return;	/* User asked to not display sprites. */

      if(n < (firsttile << 3)) n = firsttile << 3;
      loopskie:
      {
       uint32 t=*(uint32 *)(sprlinebuf+n);

       if(t!=0x80808080)
       {
        #ifdef LSB_FIRST
        if(!(t&0x80))
        {
         if(!(t&0x40) || (P[n]&0x40))       // Normal sprite || behind bg sprite
          P[n]=sprlinebuf[n];
        }

        if(!(t&0x8000))
        {
         if(!(t&0x4000) || (P[n+1]&0x40))       // Normal sprite || behind bg sprite
          P[n+1]=(sprlinebuf+1)[n];
        }

        if(!(t&0x800000))
        {
         if(!(t&0x400000) || (P[n+2]&0x40))       // Normal sprite || behind bg sprite
          P[n+2]=(sprlinebuf+2)[n];
        }

        if(!(t&0x80000000))
        {
         if(!(t&0x40000000) || (P[n+3]&0x40))       // Normal sprite || behind bg sprite
          P[n+3]=(sprlinebuf+3)[n];
        }
        #else
        /* TODO:  Simplify */
        if(!(t&0x80000000))
        {
         if(!(t&0x40000000))       // Normal sprite
          P[n]=sprlinebuf[n];
         else if(P[n]&64)        // behind bg sprite
          P[n]=sprlinebuf[n];
        }

        if(!(t&0x800000))
        {
         if(!(t&0x400000))       // Normal sprite
          P[n+1]=(sprlinebuf+1)[n];
         else if(P[n+1]&64)        // behind bg sprite
          P[n+1]=(sprlinebuf+1)[n];
        }

        if(!(t&0x8000))
        {
         if(!(t&0x4000))       // Normal sprite
          P[n+2]=(sprlinebuf+2)[n];
         else if(P[n+2]&64)        // behind bg sprite
          P[n+2]=(sprlinebuf+2)[n];
        }

        if(!(t&0x80))
        {
         if(!(t&0x40))       // Normal sprite
          P[n+3]=(sprlinebuf+3)[n];
         else if(P[n+3]&64)        // behind bg sprite
          P[n+3]=(sprlinebuf+3)[n];
        }
        #endif
       }
      }
      n+=4;
      if(n) goto loopskie;
}
