#define GL_GLEXT_LEGACY
#ifdef APPLEOPENGL
#include <OpenGL/gl.h>
#include <OpenGL/glu.h>
#include <OpenGL/glext.h>
#else
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#endif
#include <string.h>
#include <stdlib.h>

#include "main.h"
#include "opengl.h"
#include "../common/vidblit.h"

#ifndef APIENTRY
#define APIENTRY
#endif

static GLuint textures[2]={0,0};	// Normal image, scanline overlay.

static int left,right,top,bottom; // right and bottom are not inclusive.
static int scanlines;
static void *HiBuffer;

void APIENTRY (*p_glBindTexture)(GLenum target,GLuint texture);
void APIENTRY (*p_glColorTableEXT)(GLenum target, GLenum internalformat,  GLsizei width, GLenum format, GLenum type, const GLvoid *table);
void APIENTRY (*p_glTexImage2D)( GLenum target, GLint level,
                                    GLint internalFormat,
                                    GLsizei width, GLsizei height, GLint border,
                                    GLenum format, GLenum type,
                                    const GLvoid *pixels );
void APIENTRY (*p_glBegin)(GLenum mode);
void APIENTRY (*p_glVertex2f)(GLfloat x, GLfloat y);
void APIENTRY (*p_glTexCoord2f)(GLfloat s, GLfloat t);
void APIENTRY (*p_glEnd)(void);
void APIENTRY (*p_glEnable)(GLenum cap);
void APIENTRY (*p_glBlendFunc)(GLenum sfactor, GLenum dfactor);
const GLubyte* APIENTRY (*p_glGetString)(GLenum name);
void APIENTRY (*p_glViewport)(GLint x, GLint y,GLsizei width, GLsizei height);
void APIENTRY (*p_glGenTextures)(GLsizei n, GLuint *textures);
void APIENTRY (*p_glDeleteTextures)(GLsizei n,const GLuint *textures);
void APIENTRY (*p_glTexParameteri)(GLenum target, GLenum pname, GLint param);
void APIENTRY (*p_glClearColor)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
void APIENTRY (*p_glLoadIdentity)(void);
void APIENTRY (*p_glClear)(GLbitfield mask);
void APIENTRY (*p_glMatrixMode)(GLenum mode);
void APIENTRY (*p_glDisable)(GLenum cap);
void APIENTRY (*p_glFinish)(void);

static uint32 TSourceWMul;
static uint32 TSourceHMul;

void SetOpenGLPalette(uint8 *data)
{
 if(!HiBuffer)
 {
  p_glBindTexture(GL_TEXTURE_2D, textures[0]);
  p_glColorTableEXT(GL_TEXTURE_2D,GL_RGB,256,GL_RGBA,GL_UNSIGNED_BYTE,data);
 }
 else
  SetPaletteBlitToHigh((uint8*)data); 
}

void BlitOpenGL(uint8 *buf)
{
 p_glBindTexture(GL_TEXTURE_2D, textures[0]);
 if(HiBuffer)
 {
  Blit8ToHigh(buf,(uint8*)HiBuffer,256,240,256*4*TSourceWMul,TSourceWMul,TSourceHMul);
  p_glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA8,256 * TSourceWMul,256 * TSourceHMul, 0, GL_RGBA,GL_UNSIGNED_BYTE,
			HiBuffer);
 }
 else
 {
  //glPixelStorei(GL_UNPACK_ROW_LENGTH, 256);
  p_glTexImage2D(GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, 256, 256, 0,
		GL_COLOR_INDEX,GL_UNSIGNED_BYTE,buf);
 }

 p_glBegin(GL_QUADS);
 p_glTexCoord2f(1.0f*left/256, 1.0f*bottom/(256));	// Bottom left of our picture.
 p_glVertex2f(-1.0f, -1.0f);	// Bottom left of target.

 p_glTexCoord2f(1.0f*right/256, 1.0f*bottom/(256));	// Bottom right of our picture.
 p_glVertex2f( 1.0f, -1.0f);	// Bottom right of target.

 p_glTexCoord2f(1.0f*right/256, 1.0f*top/(256));	// Top right of our picture.
 p_glVertex2f( 1.0f,  1.0f);	// Top right of target.

 p_glTexCoord2f(1.0f*left/256, 1.0f*top/256);	// Top left of our picture.
 p_glVertex2f(-1.0f,  1.0f);	// Top left of target.
 p_glEnd();

 //printf("%d\n",bottom);
 //glDisable(GL_BLEND);
 if(scanlines)
 {
  p_glEnable(GL_BLEND);

  p_glBindTexture(GL_TEXTURE_2D, textures[1]);
  p_glBlendFunc(GL_DST_COLOR, GL_SRC_ALPHA);

  p_glBegin(GL_QUADS);

  p_glTexCoord2f(1.0f*left/256, 1.0f*bottom/256);  // Bottom left of our picture.
  p_glVertex2f(-1.0f, -1.0f);      // Bottom left of target.
 
  p_glTexCoord2f(1.0f*right/256, 1.0f*bottom/256); // Bottom right of our picture.
  p_glVertex2f( 1.0f, -1.0f);      // Bottom right of target.
 
  p_glTexCoord2f(1.0f*right/256, 1.0f*top/256);    // Top right of our picture.
  p_glVertex2f( 1.0f,  1.0f);      // Top right of target.
 
  p_glTexCoord2f(1.0f*left/256, 1.0f*top/256);     // Top left of our picture.
  p_glVertex2f(-1.0f,  1.0f);      // Top left of target.

  p_glEnd();
  p_glDisable(GL_BLEND);
 }

  PumpWrap();
  SDL_GL_SwapBuffers();
}

void KillOpenGL(void)
{
 if(textures[0])
  p_glDeleteTextures(2, &textures[0]);
 textures[0]=0;
 if(HiBuffer)
 {
  free(HiBuffer);
  HiBuffer=0;
 }
}
/* Rectangle, left, right(not inclusive), top, bottom(not inclusive). */

static int rw,rh,sx,sy;

int InitOpenGL(int l, int r, int t, int b, double xscale, double yscale, int efx, int ipolate,
		int stretchx, int stretchy, int special, int srcw, int srch, SDL_Surface *screen)
{
 const char *extensions;

 p_glBindTexture = (void APIENTRY (*)(GLenum,GLuint)) SDL_GL_GetProcAddress("glBindTexture");
 p_glColorTableEXT = (void APIENTRY (*)(GLenum, GLenum,  GLsizei, GLenum, GLenum, const GLvoid *))  SDL_GL_GetProcAddress("glColorTableEXT");

 p_glTexImage2D = (void APIENTRY (*)( GLenum target, GLint level,
                                    GLint internalFormat,
                                    GLsizei width, GLsizei height, GLint border,
                                    GLenum format, GLenum type,
                                    const GLvoid *pixels ))  SDL_GL_GetProcAddress("glTexImage2D");
 p_glBegin = (void APIENTRY (*)(GLenum mode)) SDL_GL_GetProcAddress("glBegin");
 p_glVertex2f = (void APIENTRY (*)(GLfloat x, GLfloat y))  SDL_GL_GetProcAddress("glVertex2f");
 p_glTexCoord2f = (void APIENTRY (*)(GLfloat s, GLfloat t)) SDL_GL_GetProcAddress("glTexCoord2f");
 p_glEnd = (void APIENTRY (*)(void)) SDL_GL_GetProcAddress("glEnd");
 p_glEnable = (void APIENTRY (*)(GLenum cap)) SDL_GL_GetProcAddress("glEnable");
 p_glBlendFunc = (void APIENTRY (*)(GLenum sfactor, GLenum dfactor)) SDL_GL_GetProcAddress("glBlendFunc");
 p_glGetString = (const GLubyte* APIENTRY (*)(GLenum name)) SDL_GL_GetProcAddress("glGetString");
 p_glViewport = (void APIENTRY (*)(GLint x, GLint y,GLsizei width, GLsizei height)) SDL_GL_GetProcAddress("glViewport");
 p_glGenTextures = (void APIENTRY (*)(GLsizei n, GLuint *textures)) SDL_GL_GetProcAddress("glGenTextures");
 p_glDeleteTextures = (void APIENTRY (*)(GLsizei n,const GLuint *textures)) SDL_GL_GetProcAddress("glDeleteTextures");
 p_glTexParameteri = (void APIENTRY (*)(GLenum target, GLenum pname, GLint param)) SDL_GL_GetProcAddress("glTexParameteri");
 p_glClearColor = (void APIENTRY (*)(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)) SDL_GL_GetProcAddress("glClearColor");
 p_glLoadIdentity = (void APIENTRY (*)(void)) SDL_GL_GetProcAddress("glLoadIdentity");
 p_glClear = (void APIENTRY (*)(GLbitfield mask)) SDL_GL_GetProcAddress("glClear");
 p_glMatrixMode = (void APIENTRY (*)(GLenum mode)) SDL_GL_GetProcAddress("glMatrixMode");
 p_glDisable = (void APIENTRY (*)(GLenum cap)) SDL_GL_GetProcAddress("glDisable");
 p_glFinish = (void APIENTRY (*)(void)) SDL_GL_GetProcAddress("glFinish");

 /* Don't check for glColorTableEXT, as it's not necessary */
 if(!p_glBindTexture || !p_glTexImage2D || !p_glBegin || !p_glVertex2f || !p_glTexCoord2f || !p_glEnd || !p_glEnable || !p_glBlendFunc 
	|| !p_glGetString || !p_glViewport || !p_glGenTextures || !p_glDeleteTextures || !p_glTexParameteri || !p_glClearColor
	|| !p_glLoadIdentity || !p_glClear || !p_glMatrixMode || !p_glDisable || !p_glFinish)
 {
  FCEUD_PrintError(_("Error obtaining function address(es) in the OpenGL library."));
  return(0);
 }

 left=l;
 right=r;
 top=t;
 bottom=b;

 HiBuffer=0;
 
 extensions=(const char*)p_glGetString(GL_EXTENSIONS);

 //printf("%d\n",srcw);
 TSourceWMul = srcw;
 TSourceHMul = srch;

 if((efx&2) || special || !extensions || !p_glColorTableEXT || !strstr(extensions,"GL_EXT_paletted_texture"))
 {
  if(!(efx&2) && !special) // Don't want to print out a warning message in this case...
   FCEU_printf(_("Paletted texture extension not found.  Using slower texture format...\n"));
  HiBuffer=malloc(4*256*256*TSourceWMul*TSourceHMul);
  memset(HiBuffer,0x00,4*256*256*TSourceWMul*TSourceWMul);
  #ifndef LSB_FIRST
  if(!InitBlitToHigh(4,0xFF000000,0xFF0000,0xFF00,efx&2,special))
  #else
  if(!InitBlitToHigh(4,0xFF,0xFF00,0xFF0000,efx&2,special))
  #endif
  {
   FCEUD_PrintError(_("Error initializing BPP conversion code."));
   return(0);
  }
 }

 rw=(r-l)*xscale;
 rh=(b-t)*yscale;
 sx=(screen->w-rw)/2;     // Start x
 sy=(screen->h-rh)/2;      // Start y

 if(stretchx) { sx=0; rw=screen->w; }
 if(stretchy) { sy=0; rh=screen->h; }
 p_glViewport(sx, sy, rw, rh);	// Called later.

 p_glGenTextures(2, &textures[0]);
 scanlines=0;

 if(efx&1)
 {
  uint8 *buf;
  int x,y;

  scanlines = 1;

  p_glBindTexture(GL_TEXTURE_2D, textures[1]);
  p_glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,ipolate?GL_LINEAR:GL_NEAREST);
  p_glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,ipolate?GL_LINEAR:GL_NEAREST);

  if(scanlines == 2)
   buf=(uint8*)malloc(256*(256*4)*4);
  else
   buf=(uint8*)malloc(256*(256*2)*4);

  if(scanlines == 1)
   for(y=0;y<(256*2);y++)
    for(x=0;x<256;x++)
    {
     buf[y*256*4+x*4]=0;
     buf[y*256*4+x*4+1]=0;
     buf[y*256*4+x*4+2]=0;
     buf[y*256*4+x*4+3]=(y&1)?0x00:0xFF; //?0xa0:0xFF; // <-- Pretty
     //buf[y*256+x]=(y&1)?0x00:0xFF;
    }
  else
   for(y=0;y<(256*4);y++)
    for(x=0;x<256;x++)
    {
     buf[y*256*4+x*4]=0;
     buf[y*256*4+x*4+1]=0;
     buf[y*256*4+x*4+2]=0;
     buf[y*256*4+x*4+3]=(y&3)?0xFF:0x00; //?0xa0:0xFF; // <-- Pretty
     //buf[y*256+x]=(y&1)?0x00:0xFF;
    }

  p_glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA8, 256, (scanlines==2)?256*4:512, 0,
                GL_RGBA,GL_UNSIGNED_BYTE,buf);
  free(buf);
 }
 p_glBindTexture(GL_TEXTURE_2D, textures[0]);
     
 p_glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,ipolate?GL_LINEAR:GL_NEAREST);
 p_glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,ipolate?GL_LINEAR:GL_NEAREST);
 p_glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
 p_glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
 p_glEnable(GL_TEXTURE_2D);
 p_glClearColor(0.0f, 0.0f, 0.0f, 0.0f);	// Background color to black.
 p_glMatrixMode(GL_MODELVIEW);

 //p_glViewport(0, 0, screen->w, screen->h);
 //p_glClear(GL_COLOR_BUFFER_BIT);
 //p_glViewport(sx, sy, rw, rh);
 p_glLoadIdentity();

 p_glFinish();

 return(1);
}

void ClearGLSurfaces(SDL_Surface *screen)
{
 int x;

 p_glViewport(0, 0, screen->w, screen->h);
 p_glFinish();

 for(x=0;x<2;x++)
 {
  p_glClear(GL_COLOR_BUFFER_BIT);
  p_glFinish();
  SDL_GL_SwapBuffers();
 }
 p_glViewport(sx, sy, rw, rh);
 p_glFinish();
}
