/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 *CHRRAM = NULL;
static uint8 Latch[2];

static void DoSuper(void)
{
 setprg8r((Latch[0]&0xC)>>2,0x6000,((Latch[0]&0x3)<<4)|0xF);
 if(Latch[0]&0x10)
 {
  setprg16r((Latch[0]&0xC)>>2,0x8000,((Latch[0]&0x3)<<3)|(Latch[1]&7));
  setprg16r((Latch[0]&0xC)>>2,0xc000,((Latch[0]&0x3)<<3)|7);
 }
 else
  setprg32r(4,0x8000,0);

 setmirror(((Latch[0]&0x20)>>5)^1);
}

static DECLFW(SuperWrite)
{
 if(!(Latch[0]&0x10))
 {
  Latch[0]=V;
  DoSuper();
 }
}

static DECLFW(SuperHi)
{
 Latch[1]=V; 
 DoSuper();
}

static void SuperReset(void)
{
  SetWriteHandler(0x6000,0x7FFF,SuperWrite);
  SetWriteHandler(0x8000,0xFFFF,SuperHi);
  SetReadHandler(0x6000,0xFFFF,CartBR);  
  Latch[0]=Latch[1]=0;
  setprg32r(4,0x8000,0);
  setvram8(CHRRAM);
  memset(CHRRAM,0,8192);
}

static void SuperRestore(int version)
{
 DoSuper();
}

static void SuperClose(void)
{
 if(CHRRAM)
  free(CHRRAM);

 CHRRAM = NULL;
}

int Supervision16_Init(CartInfo *info)
{
  if(!(CHRRAM = (uint8 *)malloc(8192)))
   return(0);

  AddExState(&GameMemBlock[0], 1, 0,"L1");
  AddExState(&GameMemBlock[1], 1, 0,"L2");
  AddExState(CHRRAM, 8192, 0, "CHRR");
  info->Power=SuperReset;
  info->Close=SuperClose;
  GameStateRestore=SuperRestore;
  return(1);
}
