/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "main.h"
#include "sound.h"

#include "../sexyal/sexyal.h"

static SexyAL *Interface;
static SexyAL_device *Output;
static SexyAL_format format;
static SexyAL_buffering buffering;
static SexyAL_enumtype *DriverTypes;
static int CurDriverIndex = 0;


uint32 GetMaxSound(void)
{
 return(buffering.totalsize);
}

uint32 GetWriteSound(void)
{
 return(Output->CanWrite(Output));
}

void WriteSound(float *Buffer, int Count)
{
 //printf("%d\n",Output->CanWrite(Output));
 Output->Write(Output, Buffer, Count);
}

int InitSound(FCEUGI *gi)
{
 if(!_sound) return(0);

 memset(&format,0,sizeof(format));
 memset(&buffering,0,sizeof(buffering));

 FCEUI_SetSoundVolume(soundvol);
 FCEUI_SetSoundQuality(soundq);

 Interface = (SexyAL *)SexyAL_Init(0);
 DriverTypes = Interface->EnumerateTypes(Interface);

 format.sampformat=SEXYAL_FMT_PCMFLOAT;
 format.channels=gi->soundchan?gi->soundchan:1;
 format.rate=gi->soundrate?gi->soundrate:soundrate;
 buffering.fragcount=buffering.fragsize=0;
 buffering.ms=soundbufsize;

 FCEUI_printf(_("\nInitializing sound...\n"));
 FCEU_indent(1);
 FCEUI_printf(_("Using \"%s\" audio driver:"),DriverTypes[CurDriverIndex].name);
 FCEU_indent(1);

 if(!(Output=Interface->Open(Interface,NULL,&format,&buffering, DriverTypes[CurDriverIndex].type)))
 {
  FCEUD_PrintError(_("Error opening a sound device."));
  Interface->Destroy(Interface);
  Interface=0;
  FCEU_indent(-2);
  return(0);
 }

 if(format.rate<8192 || format.rate > 96000)
 {
  FCEUD_PrintError(_("Set rate is out of range [8192-96000]"));
  KillSound();
  FCEU_indent(-2);
  return(0);
 }
 FCEUI_printf(_("\nBits: %u\nRate: %u\nChannels: %u\nByte order: CPU %s\nBuffer size: %u sample frames(%f ms)\n"),(format.sampformat>>4)*8,format.rate,format.channels,format.byteorder?"Reversed":"Native",buffering.totalsize,(double)buffering.totalsize*1000/format.rate);

 format.sampformat=SEXYAL_FMT_PCMFLOAT;
 format.channels=gi->soundchan?gi->soundchan:1;
 format.byteorder=0;

 //format.rate=gi->soundrate?gi->soundrate:soundrate;

 Output->SetConvert(Output,&format);

 FCEUI_Sound(format.rate);
 FCEU_indent(-2);
 return(1);
}

void SilenceSound(int n)
{

}

int KillSound(void)
{
 FCEUI_Sound(0);
 if(Output)
  Output->Close(Output);
 if(Interface)
  Interface->Destroy(Interface);
 Interface=0;
 if(!Output) return(0);
 Output=0;
 return(1);
}
