/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

typedef struct __EXPSOUND {
	   void (*HiFill)(void);
	   void (*HiSync)(int32 ts);

	   void (*RChange)(struct __EXPSOUND *);
	   void (*Kill)(void);
} EXPSOUND;

extern EXPSOUND GameExpSound;

int GetSoundBuffer(float **W);
int FlushEmulateSound(void);
extern float WaveFinal[2048+512] __attribute__ ((aligned (16)));
extern int32 WaveHi[40000] __attribute__ ((aligned (16)));
extern int16 WaveHiEx[40000] __attribute__ ((aligned (16)));

extern uint32 soundtsoffs;
#define SOUNDTS (timestamp + soundtsoffs)

int FCEUSND_Init(int PAL);
int FCEUSND_SetVidSystem(int PAL);
void FCEUSND_Close(void);
void FCEUSND_Power(void);
void FCEUSND_Reset(void);
void FCEUSND_SaveState(void);
void FCEUSND_LoadState(int version);

void FASTAPASS(1) FCEU_SoundCPUHook(int);
