/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2003 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mapinc.h"

static uint8 PRGSel;
static uint8 PBuf[4],PSel;
static uint8 cmd;
static uint8 DRegs[8];
static uint32 count=0;
static uint32 last=0;

static DECLFW(M208Write1)
{
 PRGSel=(V&0x1)|((V>>3)&0x2);  
 setprg32(0x8000,PRGSel);
}

static DECLFW(M208Write2)
{
 static uint8 lut[256]={
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x59, 0x49, 0x19, 0x09, 0x59, 0x49, 0x19, 0x09,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x51, 0x41, 0x11, 0x01, 0x51, 0x41, 0x11, 0x01,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x59, 0x49, 0x19, 0x09, 0x59, 0x49, 0x19, 0x09,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x51, 0x41, 0x11, 0x01, 0x51, 0x41, 0x11, 0x01,
  0x00, 0x10, 0x40, 0x50, 0x00, 0x10, 0x40, 0x50,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x18, 0x48, 0x58, 0x08, 0x18, 0x48, 0x58,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x40, 0x50, 0x00, 0x10, 0x40, 0x50,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0x18, 0x48, 0x58, 0x08, 0x18, 0x48, 0x58,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x58, 0x48, 0x18, 0x08, 0x58, 0x48, 0x18, 0x08,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x50, 0x40, 0x10, 0x00, 0x50, 0x40, 0x10, 0x00,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x58, 0x48, 0x18, 0x08, 0x58, 0x48, 0x18, 0x08,
  0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59,0x50, 0x40, 0x10, 0x00, 0x50, 0x40, 0x10, 0x00,
  0x01, 0x11, 0x41, 0x51, 0x01, 0x11, 0x41, 0x51,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x19, 0x49, 0x59, 0x09, 0x19, 0x49, 0x59,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x11, 0x41, 0x51, 0x01, 0x11, 0x41, 0x51,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x09, 0x19, 0x49, 0x59, 0x09, 0x19, 0x49, 0x59,0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 
  
 };
 if(A<=0x57FF) PSel=V;
 else
  PBuf[(A&0x03)]=V^lut[PSel];
}

static DECLFR(M208Read)
{
 return(PBuf[(A&0x3)]);
}

static void Sync(void)
{
 int x;

 setchr2(0x0000,DRegs[0]>>1);
 setchr2(0x0800,DRegs[1]>>1);
 for(x=0;x<4;x++)
  setchr1(0x1000+x*0x400,DRegs[2+x]);
}

static DECLFW(M208HWrite)
{
 switch(A&0xe001)
 {
  case 0xc000:IRQLatch=IRQCount=V;break;
  case 0xc001:IRQCount=IRQLatch;last=count=0;break;
  case 0xe000:IRQa=0;X6502_IRQEnd(FCEU_IQEXT);break;
  case 0xe001:IRQa=1;break;
  case 0x8000:cmd=V;break;
  case 0x8001:DRegs[cmd&7]=V;
		Sync();
		break;

 }
}

static void M208Power(void)
{
 PRGSel=3;
 setprg32(0x8000,3);
 SetWriteHandler(0x4800,0x4FFF,M208Write1);
 SetWriteHandler(0x5000,0x5fff,M208Write2);
 SetWriteHandler(0x8000,0xFFFF,M208HWrite); 
 SetReadHandler(0x5800,0x5FFF,M208Read);
 SetReadHandler(0x8000,0xffff,CartBR);
}

static void sl(void)
{
 if(IRQa)
 {
  if(IRQCount>=0) 
  {
   IRQCount--;
   if(IRQCount<0)
   {
    X6502_IRQBegin(FCEU_IQEXT);
   }
  }
 }
}

static void FP_FASTAPASS(1) foo(uint32 A)
{
 if((A&0x2000) && !(last&0x2000))
 {
  count++;
  if(count==42)
  { 
   sl();
   count=0;
  }
 }
 last=A;
}

int Mapper208_Init(CartInfo *info)
{
 info->Power=M208Power;
 //GameHBIRQHook=sl;
 PPU_hook=foo;
 return(1);
}

