/* FCE Ultra - NES/Famicom Emulator
 *
 * Copyright notice for this file:
 *  Copyright (C) 2002 Xodnizel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../../driver.h"
#include "../common/config.h"
#include "../common/args.h"

#include <SDL.h>
#include <SDL_thread.h>

#include "../../gettext.h"

#ifndef _
#define _(String) gettext(String)
#endif

extern int eoptions;
#define EO_NO8LIM      1
#define EO_SUBASE      2
#define EO_CLIPSIDES   8
#define EO_SNAPNAME    16
#define EO_NOFOURSCORE	32
#define EO_NOTHROTTLE	64
#define EO_GAMEGENIE	128
#define EO_PAL		256
#define EO_AUTOHIDE	1024
#define EO_AUTOSAVE	2048

extern int srendlinev[2],erendlinev[2];
extern int NoWaiting;

extern int soundvol;
extern long soundq;
extern int _sound;
extern long soundrate;
extern long soundbufsize;

typedef struct {
        int xres;
        int yres;
        double xscale,yscale;
        double xscalefs,yscalefs;
        int efx,efxfs;
        int bpp;
        int fullscreen;
        int doublebuf;
        char *fshack;
        char *fshacksave;
        #ifdef OPENGL
        int opengl;
        int openglip;
        int stretchx,stretchy;
        #endif
        int special,specialfs;
	int ffspeed;
	int fnscan;
} DSETTINGS;

extern DSETTINGS Settings;

#define _doublebuf Settings.doublebuf
#define _bpp Settings.bpp
#define _xres Settings.xres
#define _yres Settings.yres
#define _fullscreen Settings.fullscreen
#define _xscale Settings.xscale
#define _yscale Settings.yscale
#define _xscalefs Settings.xscalefs
#define _yscalefs Settings.yscalefs
#define _efx Settings.efx
#define _efxfs Settings.efxfs
#define _ebufsize Settings.ebufsize
#define _fshack Settings.fshack
#define _fshacksave Settings.fshacksave

#ifdef OPENGL
#define _opengl Settings.opengl
#define _openglip Settings.openglip
#define _stretchx Settings.stretchx
#define _stretchy Settings.stretchy
#endif

extern FCEUGI *CurGame;
int CloseGame(void);

void RefreshThrottleFPS(int);

void PumpWrap(void);
