//===================================================================
//
// File:  vid.h
//
// OS-Dependent Video Routines
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Alastair Bridgewater (1998-2001)
//     - http://www.dridus.com/~nyef/darcnes
//     - Initial distribution use in this port
//
//===================================================================
//
// Ported By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// DarcNES is Copyright 1998, 1999, 2000, 2001 by Alastair Bridgewater.
//
// Commercial use prohibited without express written permission from
// the author. Everyone else can do whatever they want, provided that
// I am credited in the documentation (and, if released, the source code).
//
// See the "readme" file for complete DarcNES details
//
//===================================================================

/* $Id: video.h,v 1.10 2000/08/22 02:33:44 nyef Exp $ */

#ifndef __VID_H__
#define __VID_H__

#define VIDEO_MODE_FIT_TO_SCREEN   (1)
#define VIDEO_MODE_CENTER          (2)

extern void video_init( unsigned short *pScreen
                      , unsigned short  x
                      , unsigned short  y
                      , unsigned short  bpp
                      , unsigned short  mode
                      );
extern void video_destroy( void );

extern void video_display_buffer( void );
extern void video_setsize( int x, int y );
extern void video_setpal( int num_colors, int *red, int *green, int *blue );
extern unsigned short *video_get_vbp( int line );
extern int  video_skipframe( void );

extern unsigned char *vid_pre_xlat;

#define MAX_PALETTE_ENTRIES  (64)
extern unsigned short vid_palette[MAX_PALETTE_ENTRIES];

#endif // __VID_H__
