//===================================================================
//
// File:  menudata.h
//
// Created for EGBoy
//
// Credits:
//
//   Steve Fischer (2004)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Peter van Sebille (2002-2003)
//     - http://mobile.yipton.net
//     - Author of EDoom & EMame for P800/P900 for which much of the
//       front-end GUI application came from
//
//   WildPalm
//     - http://www.wildpalm.co.uk
//     - Authors of GoBoy, a Symbian based port of the GnuBoy emulator
//       which was the basis for the port to the A920
//
//   Laguna & Gilgamesh (2000-2001)
//     - http://gnuboy.unix-fu.org/
//     - Authors of the GnuBoy emulator which is the basis for this
//       implementation
//
//===================================================================

#ifndef _MENUDATA_H_
#define _MENUDATA_H_

#ifdef __cplusplus
extern "C" {
#endif

// Menu Entry IDs
enum
{ EMenuIDMainTitle
, EMenuIDFileSave
, EMenuIDFileLoad
, EMenuIDLoadTitle
, EMenuIDLoad
, EMenuIDFileDelete
, EMenuIDDeleteTitle
, EMenuIDDelete
, EMenuIDQuitMenu

, EMenuIDMaxValue
};

// Menu Definition
TMenuEntry MenuTable[] =
{ { EMenuIDMainTitle,     CMenu::EMenuTitle,          0, 0, "Main Menu"     }
, { EMenuIDFileSave,      CMenu::EMenuStaticEntry,    0, 0, "Save"          }
, { EMenuIDFileLoad,      CMenu::EMenuSubMenu,        0, 0, "Load"          }
,   { EMenuIDLoadTitle,   CMenu::EMenuTitle,          1, 0, "Load Menu"     }
,   { EMenuIDLoad,        CMenu::EMenuDynamicEntry,   1, 0, ""              }
, { EMenuIDFileDelete,    CMenu::EMenuSubMenu,        0, 0, "Delete"        }
,   { EMenuIDDeleteTitle, CMenu::EMenuTitle,          1, 0, "Delete Menu"   }
,   { EMenuIDDelete,      CMenu::EMenuDynamicEntry,   1, 0, ""              }
, { EMenuIDQuitMenu,      CMenu::EMenuStaticEntry,    0, 0, "Exit Game"     }
};

#ifdef __cplusplus
}
#endif

#endif // _MENUDATA_H_

