//===================================================================
//
// File:  user_menu.h
//
// User menu
//
// Credits:
//
//   Steve Fischer (2004-2005)
//     - http://stevesprojects.com
//
//===================================================================

#ifndef MENU_H
#define MENU_H

#include <e32base.h>
#include "navigation.h"

#define CLIENT_WINDOW_WIDTH   (256)
#define CLIENT_WINDOW_HEIGHT  (208)

// A struct used to be used in an array to define the menu
struct TMenuEntry
{
   TUint16 iEntryID;
   TUint8  iType;
   TUint8  iLevel;
   TUint   iFlags;
   char   *iName;
};

// Class used to request info on dynamic menu entries
class CDynamicMenuEntry
{
public:
   virtual void AppendEntry( TUint16 aSubEntryID, TUint aFlags, char *aName ) = 0;
};

// The callback class
class MMenuObserver
{
public:
	virtual void EntrySelection( TUint16 aEntryID, TUint16 aSubEntryID ) = 0;
   virtual void GetDynamicEntry( TUint16 aEntryID, CDynamicMenuEntry& aEntry ) = 0;
};

// The menu class
class CMenu : public CBase
{
public:
   static CMenu* NewL( TMenuEntry aMenu[], TInt aNumOfEntries, MMenuObserver &aObserver );

   virtual void Draw( TUint16* aPtr ) = 0;
   virtual void KeyEvent( TInt aKeyCode ) = 0;
   virtual TInt GetEntryState( TUint16 aEntryID, TUint16 aEntrySubID = 0 ) = 0;
   virtual void SetEntryState( TUint16 aEntryID, TUint16 aEntrySubID, TInt aEntryState ) = 0;
   virtual void DisplayMsg( char *aMsgLine1, char *aMsgLine2, TUint aTimeoutInDrawCallCounts ) = 0;
   virtual void Reload( void ) = 0;
   virtual void Reset( void ) = 0;

   // Reserved & Special Use EntryIDs & EntrySubIDs
   enum
   { EEntryIDExitMenu    = 0xFFFA  // Returned when "Return" is selected in level 0 menu
   , EEntryIDReserved1   = 0xFFFB
   , EEntryIDReserved2   = 0xFFFC
   , EEntryIDReserved3   = 0xFFFD
   , EEntryIDReserved4   = 0xFFFE
   , EEntryIDReserved5   = 0xFFFF
   , EEntrySubIDReserved = 0
   };

   // Used with Get/SetEntryState methods
   enum
   { EEntryStateNotSelected
   , EEntryStateSelected
   };

   enum TEntryType
   { EMenuTitle
   , EMenuSubMenu
   , EMenuStaticEntry
   , EMenuDynamicEntry
   , EMenuReturnEntry   // For internal use only
   };

   // Only use flags with Static or Dynamic entries
   enum TEntryFlags
   // Entry State, selected or not
   { EEntrySelected    = 0x00000001
   // Entry type, check box or radio button, only one type per entry
   , EEntryCheckBox    = 0x00000010
   , EEntryRadioButton = 0x00000020
   };

   // Used to define the display size & button count, equate as needed
   enum 
   { KDisplayWidth  = CLIENT_WINDOW_WIDTH
   , KDisplayHeight = CLIENT_WINDOW_HEIGHT
   , KButtonCount   = 13   // Should divide KDisplayHeight fairly evenly
   };

   // Used to define the value of the keycodes, equate as needed
   enum 
   { KKeyEventUp1     = DEVICE_SCANCODE_UP
   , KKeyEventUp2     = DEVICE_SCANCODE_PXXX_JOG_UP
   , KKeyEventDown1   = DEVICE_SCANCODE_DOWN
   , KKeyEventDown2   = DEVICE_SCANCODE_PXXX_JOG_DOWN
   , KKeyEventSelect1 = DEVICE_SCANCODE_BUTTON1
   , KKeyEventSelect2 = DEVICE_SCANCODE_PXXX_JOG_INWARD
   };   
};

#endif