//===================================================================
//
// File:  ui.h
//
// Interface between the NES engine and the UI/GUI
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Alastair Bridgewater (1998-2001)
//     - http://www.dridus.com/~nyef/darcnes
//     - Initial distribution use in this port
//
//===================================================================
//
// Ported By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// DarcNES is Copyright 1998, 1999, 2000, 2001 by Alastair Bridgewater.
//
// Commercial use prohibited without express written permission from
// the author. Everyone else can do whatever they want, provided that
// I am credited in the documentation (and, if released, the source code).
//
// See the "readme" file for complete DarcNES details
//
//===================================================================

// $Id: ui.h,v 1.11 2000/06/29 01:06:05 nyef Exp $

#ifndef __UI_H__
#define __UI_H__

#include "types.h"

//===================================================================
// System Interface
//

extern void sys_init( const char     *pFilename
                    , unsigned short *pScreen
                    , unsigned short  video_x
                    , unsigned short  video_y
                    , unsigned short  video_bpp
                    , unsigned short  video_mode
                    , unsigned short  sound_rate
                    );
extern void sys_destroy( void );
extern void sys_execute( void );

extern int  sys_get_context_length( void );
extern int  sys_get_context( unsigned char *buffer, int maxlength );
extern void sys_set_context( unsigned char *buffer, int length );

//===================================================================
// Debug Console Interface
//

extern void deb_printf(const char *fmt, ...);

//===================================================================
// Timeslicer Interface
//

extern void set_timeslice(void (*proc)(void *), void *data);
extern void unset_timeslice(void);

//===================================================================
// Shutdown Callback
//

typedef void (*shutdown_t)(void);
extern shutdown_t dn_shutdown;

//===================================================================
// Joypad Interface
//

#define JPD_BUTTON_A  0x01
#define JPD_BUTTON_B  0x02
#define JPD_SELECT    0x04
#define JPD_START     0x08
#define JPD_UP        0x10
#define JPD_DOWN      0x20
#define JPD_LEFT      0x40
#define JPD_RIGHT     0x80

struct joypad_button_template
{
   int num_buttons;
   unsigned long buttons[0];
};

struct joypad
{
   const struct joypad_button_template *button_template;
   unsigned long data;
};

extern int ui_register_joypad(struct joypad *pad);
extern void ui_update_joypad(struct joypad *pad);

//===================================================================
// Keypad Interface
//

struct keypad
{
   u16 data;
};

extern int keypad_register(struct keypad *pad);
extern void keypad_update(struct keypad *pad);

#define KPD_0    0x0001
#define KPD_1    0x0002
#define KPD_2    0x0004
#define KPD_3    0x0008
#define KPD_4    0x0010
#define KPD_5    0x0020
#define KPD_6    0x0040
#define KPD_7    0x0080
#define KPD_8    0x0100
#define KPD_9    0x0200
#define KPD_STAR 0x0400
#define KPD_HASH 0x0800
#define KPD_A    0x1000 /* Unused */
#define KPD_B    0x2000 /* Unused */
#define KPD_C    0x4000 /* Unused */
#define KPD_D    0x8000 /* Unused */

#endif // __UI_H__
