//===================================================================
//
// File:  snd_epoc.c
//
// OS-Dependant Sound Routines
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Alastair Bridgewater (1998-2001)
//     - http://www.dridus.com/~nyef/darcnes
//     - Initial distribution use in this port
//
//===================================================================
//
// Ported By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// DarcNES is Copyright 1998, 1999, 2000, 2001 by Alastair Bridgewater.
//
// Commercial use prohibited without express written permission from
// the author. Everyone else can do whatever they want, provided that
// I am credited in the documentation (and, if released, the source code).
//
// See the "readme" file for complete DarcNES details
//
//===================================================================

#include "types.h"
#include "snd.h"
#include "nes_psg.h"
#include "nes_epoc.h"

static int snd_rate = KSndOff;

void snd_init( unsigned int sample_rate )
{
   switch ( sample_rate )
   {
   case 8000:
      snd_rate = KSnd8000;
      break;

   case 11025:
      snd_rate = KSnd11025;
      break;

   case 22050:
      snd_rate = KSnd22050;
      break;

   case 44100:
      snd_rate = KSnd44100;
      break;

   default:
      snd_rate = KSndOff;
      break;
   }
}

int snd_config( void )
{
   return ( snd_rate );
}

int snd_open( int samples_per_sync, int sample_rate )
{
   return ( 1 );
}

void snd_close( void )
{
}

void snd_output( int samples, u16 *wave )
{
//   ProfilerMark(11);

   AudioWrite( wave, samples );

//   ProfilerMark(12);
}
