//===================================================================
//
// File:  snd.h
//
// OS-Dependant Sound Routines
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Ported & integrated all the below code to the A920
//
//   Alastair Bridgewater (1998-2001)
//     - http://www.dridus.com/~nyef/darcnes
//     - Initial distribution use in this port
//
//===================================================================
//
// Ported By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================
//
// DarcNES is Copyright 1998, 1999, 2000, 2001 by Alastair Bridgewater.
//
// Commercial use prohibited without express written permission from
// the author. Everyone else can do whatever they want, provided that
// I am credited in the documentation (and, if released, the source code).
//
// See the "readme" file for complete DarcNES details
//
//===================================================================

/* $Id: snd.h,v 1.2 2000/01/01 02:38:11 nyef Exp $ */

#ifndef __SND_H__
#define __SND_H__

#include "types.h"

extern void snd_init( unsigned int sample_rate );

extern int  snd_config(void);
extern int  snd_open(int samples_per_sync, int sample_rate);
extern void snd_close(void);
extern void snd_output( int samples, u16 *wave );

#endif // __SND_H__

