//===================================================================
//
// File:  nes_epoc.h
//
// Interface between the NES engine and the game engine
//
// Credits:
//
//   Steve Fischer (2005)
//     - http://stevesprojects.com
//     - Created & integrated all the below code to the A920
//
//===================================================================
//
// Created By: Steve Fischer (steve@stevesprojects.com)
//
//	(c) Copyright 2005, Steve Fischer
//	All Rights Reserved
//
//===================================================================

#ifndef __NES_EPOC_H__
#define __NES_EPOC_H__

extern int FrameCount;
extern int AbortedFrameCount;
extern int Iterations;
extern int SkipThisFrame;

extern void          AudioWrite( unsigned short *aPtr, int aLen );
extern void          DebugPrint( char *p );
extern unsigned char GetKeyData( void );
extern void          DisplayFrame( void );
extern void          ProfilerMark( int type );
extern void          ProfilerDump( unsigned int value );
extern unsigned int  SystemTick( void );
extern int           ExecuteMenu( void );


#endif // __NES_EPOC_H__